/*
 * Decompiled with CFR 0.152.
 */
package Utils.KudosUtils;

import Utils.ConfigManagement;
import Utils.ItemCreator;
import de.urbance.Main;
import de.urbance.shaded.inventoryframework.gui.GuiItem;
import de.urbance.shaded.inventoryframework.gui.type.ChestGui;
import org.bukkit.ChatColor;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class UrbanceGUI {
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private FileConfiguration globalGuiSettingsConfig = ConfigManagement.getGlobalGuiSettingsConfig();
    private ChestGui chestGui;

    public UrbanceGUI create(String title, int size) {
        this.chestGui = new ChestGui(size, ChatColor.translateAlternateColorCodes((char)'&', (String)title));
        return this;
    }

    public UrbanceGUI cancelOnGlobalClick(boolean cancelOnGlobalClick) {
        this.chestGui.setOnGlobalClick(event -> event.setCancelled(cancelOnGlobalClick));
        return this;
    }

    public GuiItem getBackwardsPageSwitcher() {
        String arrowLeftURLSkull = "http://textures.minecraft.net/texture/bd69e06e5dadfd84e5f3d1c21063f2553b2fa945ee1d4d7152fdc5425bc12a9";
        GuiItem pageSwitcherLeft = new GuiItem(new ItemCreator("PLAYER_HEAD").setDisplayName(this.globalGuiSettingsConfig.getString("page-switcher.direction.backwards.item-name")).replaceSkullWithCustomURLSkull(arrowLeftURLSkull).get());
        return pageSwitcherLeft;
    }

    public GuiItem getForwardsPageSwitcher() {
        String arrowRightURLSkull = "http://textures.minecraft.net/texture/19bf3292e126a105b54eba713aa1b152d541a1d8938829c56364d178ed22bf";
        GuiItem pageSwitcherRight = new GuiItem(new ItemCreator("PLAYER_HEAD").replaceSkullWithCustomURLSkull(arrowRightURLSkull).setDisplayName(this.globalGuiSettingsConfig.getString("page-switcher.direction.forwards.item-name")).get());
        return pageSwitcherRight;
    }

    public void playsoundPageSwitcher(Player player) {
        if (!this.globalGuiSettingsConfig.getBoolean("page-switcher.playsound.enabled")) {
            return;
        }
        String sound = this.globalGuiSettingsConfig.getString("page-switcher.playsound.playsound-type");
        player.playSound(player.getLocation(), Sound.valueOf((String)sound), 1.0f, 1.0f);
    }

    public ChestGui get() {
        return this.chestGui;
    }
}

