/*
 * Decompiled with CFR 0.152.
 */
package de.urbance.shaded.inventoryframework.adventuresupport;

import de.urbance.shaded.inventoryframework.adventuresupport.TextHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.Merchant;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class StringHolder
extends TextHolder {
    @NotNull
    private static final StringHolder EMPTY = StringHolder.of("");
    @NotNull
    private final String value;

    @NotNull
    @Contract(pure=true)
    public static StringHolder of(@NotNull String value) {
        Validate.notNull((Object)value, (String)"value mustn't be null");
        return new StringHolder(value);
    }

    @NotNull
    @Contract(pure=true)
    public static StringHolder empty() {
        return EMPTY;
    }

    private StringHolder(@NotNull String value) {
        this.value = value;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.value + "}";
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && Objects.equals(this.value, ((StringHolder)other).value);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public String asLegacyString() {
        return this.value;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory asInventoryTitle(InventoryHolder holder, InventoryType type) {
        return Bukkit.createInventory((InventoryHolder)holder, (InventoryType)type, (String)this.value);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory asInventoryTitle(InventoryHolder holder, int size) {
        return Bukkit.createInventory((InventoryHolder)holder, (int)size, (String)this.value);
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Merchant asMerchantTitle() {
        return Bukkit.createMerchant((String)this.value);
    }

    @Override
    public void asItemDisplayName(ItemMeta meta) {
        meta.setDisplayName(this.value);
    }

    @Override
    public void asItemLoreAtEnd(ItemMeta meta) {
        List<String> lore = meta.hasLore() ? Objects.requireNonNull(meta.getLore()) : new ArrayList();
        lore.add(this.value);
        meta.setLore(lore);
    }
}

