/*
 * Decompiled with CFR 0.152.
 */
package de.urbance.shaded.inventoryframework.font;

import de.urbance.shaded.inventoryframework.font.util.Font;
import de.urbance.shaded.inventoryframework.util.CSVUtil;
import de.urbance.shaded.inventoryframework.util.SkullUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSVFont
extends Font {
    private final Map<Character, ItemStack> characterMappings;
    private final char defaultCharacter;

    public CSVFont(char defaultCharacter, String filePath) {
        this.defaultCharacter = defaultCharacter;
        try (InputStream inputStream = this.getClass().getResourceAsStream(filePath);){
            this.characterMappings = CSVUtil.readAll(inputStream).stream().collect(Collectors.toMap(v -> Character.valueOf(v[0].charAt(0)), v -> SkullUtil.getSkull(v[1])));
        }
        catch (IOException e) {
            throw new RuntimeException("Error loading CSV-based font: " + filePath, e);
        }
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public ItemStack getDefaultItem() {
        return this.characterMappings.get(Character.valueOf(this.defaultCharacter));
    }

    @Override
    @Nullable
    @Contract(pure=true)
    public ItemStack toItem(char character) {
        return this.characterMappings.get(Character.valueOf(character));
    }
}

