/*
 * Decompiled with CFR 0.152.
 */
package de.urbance.shaded.inventoryframework.gui.type;

import de.urbance.shaded.inventoryframework.HumanEntityCache;
import de.urbance.shaded.inventoryframework.abstraction.MerchantInventory;
import de.urbance.shaded.inventoryframework.adventuresupport.StringHolder;
import de.urbance.shaded.inventoryframework.adventuresupport.TextHolder;
import de.urbance.shaded.inventoryframework.exception.XMLLoadException;
import de.urbance.shaded.inventoryframework.gui.InventoryComponent;
import de.urbance.shaded.inventoryframework.gui.type.util.Gui;
import de.urbance.shaded.inventoryframework.gui.type.util.InventoryBased;
import de.urbance.shaded.inventoryframework.gui.type.util.NamedGui;
import de.urbance.shaded.inventoryframework.pane.Pane;
import de.urbance.shaded.inventoryframework.util.XMLUtil;
import de.urbance.shaded.inventoryframework.util.version.Version;
import de.urbance.shaded.inventoryframework.util.version.VersionMatcher;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.TradeSelectEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MerchantRecipe;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class MerchantGui
extends NamedGui
implements InventoryBased {
    private Consumer<? super TradeSelectEvent> onTradeSelect;
    @NotNull
    private InventoryComponent inputComponent = new InventoryComponent(2, 1);
    @NotNull
    private InventoryComponent playerInventoryComponent = new InventoryComponent(9, 4);
    @NotNull
    private final List<Map.Entry<MerchantRecipe, Integer>> trades = new ArrayList<Map.Entry<MerchantRecipe, Integer>>();
    private int experience = -1;
    private int level = 0;
    @NotNull
    private final MerchantInventory merchantInventory = VersionMatcher.newMerchantInventory(Version.getVersion());

    public MerchantGui(@NotNull String title) {
        this(StringHolder.of(title));
    }

    public MerchantGui(@NotNull TextHolder title) {
        this(title, (Plugin)JavaPlugin.getProvidingPlugin(MerchantGui.class));
    }

    public MerchantGui(@NotNull String title, @NotNull Plugin plugin) {
        this(StringHolder.of(title), plugin);
    }

    public MerchantGui(@NotNull TextHolder title, @NotNull Plugin plugin) {
        super(title, plugin);
    }

    public void setOnTradeSelect(@Nullable Consumer<? super TradeSelectEvent> onTradeSelect) {
        this.onTradeSelect = onTradeSelect;
    }

    public void callOnTradeSelect(@NotNull TradeSelectEvent event) {
        this.callCallback(this.onTradeSelect, event, "onTradeSelect");
    }

    @Override
    protected void initializeOrThrow(@NotNull Object instance, @NotNull Element element) {
        super.initializeOrThrow(instance, element);
        if (element.hasAttribute("onTradeSelect")) {
            this.setOnTradeSelect(XMLUtil.loadOnEventAttribute(instance, element, TradeSelectEvent.class, "onTradeSelect"));
        }
    }

    @Override
    public void update() {
        this.updating = true;
        if (this.isDirty()) {
            this.inventory = this.createInventory();
            this.markChanges();
        }
        this.getInventory().clear();
        this.getInputComponent().display(this.getInventory(), 0);
        this.getPlayerInventoryComponent().display();
        for (HumanEntity viewer : this.getViewers()) {
            ItemStack cursor = viewer.getItemOnCursor();
            viewer.setItemOnCursor(new ItemStack(Material.AIR));
            this.populateBottomInventory(viewer);
            if ((this.experience >= 0 || this.level > 0 || !this.trades.isEmpty()) && viewer instanceof Player) {
                this.merchantInventory.sendMerchantOffers((Player)viewer, this.trades, this.level, this.experience);
            }
            viewer.setItemOnCursor(cursor);
        }
        if (!this.updating) {
            throw new AssertionError((Object)"Gui#isUpdating became false before Gui#update finished");
        }
        this.updating = false;
    }

    @Override
    public void show(@NotNull HumanEntity humanEntity) {
        if (!(humanEntity instanceof Player)) {
            throw new IllegalArgumentException("Merchants can only be opened by players");
        }
        if (this.inventory == null) {
            this.update();
        }
        this.populateBottomInventory(humanEntity);
        humanEntity.openInventory(this.getInventory());
        if (this.experience >= 0 || this.level > 0 || !this.trades.isEmpty()) {
            this.merchantInventory.sendMerchantOffers((Player)humanEntity, this.trades, this.level, this.experience);
        }
    }

    private void populateBottomInventory(@NotNull HumanEntity humanEntity) {
        if (this.getPlayerInventoryComponent().hasItem()) {
            HumanEntityCache humanEntityCache = this.getHumanEntityCache();
            if (!humanEntityCache.contains(humanEntity)) {
                humanEntityCache.storeAndClear(humanEntity);
            }
            this.getPlayerInventoryComponent().placeItems(humanEntity.getInventory(), 0);
        }
    }

    @Override
    @NotNull
    public Gui copy() {
        MerchantGui gui = new MerchantGui(this.getTitleHolder(), this.plugin);
        gui.inputComponent = this.inputComponent.copy();
        gui.playerInventoryComponent = this.playerInventoryComponent.copy();
        gui.experience = this.experience;
        gui.level = this.level;
        for (Map.Entry<MerchantRecipe, Integer> trade : this.trades) {
            MerchantRecipe originalRecipe = trade.getKey();
            ItemStack result = originalRecipe.getResult().clone();
            int uses = originalRecipe.getUses();
            int maxUses = originalRecipe.getMaxUses();
            boolean experienceReward = originalRecipe.hasExperienceReward();
            int villagerExperience = originalRecipe.getVillagerExperience();
            float priceMultiplier = originalRecipe.getPriceMultiplier();
            MerchantRecipe recipe = new MerchantRecipe(result, uses, maxUses, experienceReward, villagerExperience, priceMultiplier);
            for (ItemStack ingredient : originalRecipe.getIngredients()) {
                recipe.addIngredient(ingredient.clone());
            }
            gui.trades.add(new AbstractMap.SimpleImmutableEntry<MerchantRecipe, Integer>(recipe, trade.getValue()));
        }
        gui.setOnTopClick(this.onTopClick);
        gui.setOnBottomClick(this.onBottomClick);
        gui.setOnGlobalClick(this.onGlobalClick);
        gui.setOnOutsideClick(this.onOutsideClick);
        gui.setOnTradeSelect(this.onTradeSelect);
        gui.setOnClose(this.onClose);
        return gui;
    }

    @Override
    public void click(@NotNull InventoryClickEvent event) {
        int rawSlot = event.getRawSlot();
        if (rawSlot >= 0 && rawSlot <= 1) {
            this.getInputComponent().click(this, event, rawSlot);
        } else if (rawSlot != 2) {
            this.getPlayerInventoryComponent().click(this, event, rawSlot - 3);
        }
    }

    @NotNull
    public Inventory getInventory() {
        if (this.inventory == null) {
            this.inventory = this.createInventory();
        }
        return this.inventory;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory() {
        Inventory inventory = this.merchantInventory.createInventory(this.getTitleHolder());
        this.addInventory(inventory, this);
        return inventory;
    }

    public void addTrade(@NotNull MerchantRecipe recipe, int discount) {
        this.trades.add(new AbstractMap.SimpleImmutableEntry<MerchantRecipe, Integer>(recipe, -discount));
    }

    public void setExperience(int experience) {
        if (experience < 0) {
            throw new IllegalArgumentException("Experience must be greater than or equal to zero");
        }
        this.experience = experience;
    }

    public void setLevel(int level) {
        if (level < 0 || level > 5) {
            throw new IllegalArgumentException("Level must be between one and five");
        }
        this.level = level;
    }

    public void addTrade(@NotNull MerchantRecipe recipe) {
        this.addTrade(recipe, 0);
    }

    @Override
    public boolean isPlayerInventoryUsed() {
        return this.getPlayerInventoryComponent().hasItem();
    }

    @Override
    @Contract(pure=true)
    public int getViewerCount() {
        return this.getInventory().getViewers().size();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public List<HumanEntity> getViewers() {
        return new ArrayList<HumanEntity>(this.getInventory().getViewers());
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getInputComponent() {
        return this.inputComponent;
    }

    @NotNull
    @Contract(pure=true)
    public InventoryComponent getPlayerInventoryComponent() {
        return this.playerInventoryComponent;
    }

    @Nullable
    @Contract(pure=true)
    public static MerchantGui load(@NotNull Object instance, @NotNull InputStream inputStream, @NotNull Plugin plugin) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(inputStream);
            Element documentElement = document.getDocumentElement();
            documentElement.normalize();
            return MerchantGui.load(instance, documentElement, plugin);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NotNull
    @Contract(pure=true)
    public static MerchantGui load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        if (!element.hasAttribute("title")) {
            throw new XMLLoadException("Provided XML element's gui tag doesn't have the mandatory title attribute set");
        }
        MerchantGui merchantGui = new MerchantGui(element.getAttribute("title"), plugin);
        merchantGui.initializeOrThrow(instance, element);
        if (element.hasAttribute("populate")) {
            return merchantGui;
        }
        NodeList childNodes = element.getChildNodes();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node item = childNodes.item(index);
            if (item.getNodeType() != 1) continue;
            Element nestedElement = (Element)item;
            String tagName = nestedElement.getTagName();
            if (tagName.equalsIgnoreCase("component")) {
                InventoryComponent component;
                if (!nestedElement.hasAttribute("name")) {
                    throw new XMLLoadException("Component tag does not have a name specified");
                }
                switch (nestedElement.getAttribute("name")) {
                    case "input": {
                        component = merchantGui.getInputComponent();
                        break;
                    }
                    case "player-inventory": {
                        component = merchantGui.getPlayerInventoryComponent();
                        break;
                    }
                    default: {
                        throw new XMLLoadException("Unknown component name");
                    }
                }
                component.load(instance, nestedElement, plugin);
                continue;
            }
            if (tagName.equalsIgnoreCase("trade")) {
                NodeList tradeNodes = nestedElement.getChildNodes();
                ArrayList<ItemStack> ingredients = new ArrayList<ItemStack>(2);
                ItemStack result = null;
                for (int tradeIndex = 0; tradeIndex < tradeNodes.getLength(); ++tradeIndex) {
                    Node tradeNode = tradeNodes.item(tradeIndex);
                    if (tradeNode.getNodeType() != 1) continue;
                    Element tradeElement = (Element)tradeNode;
                    if (tradeElement.getTagName().equalsIgnoreCase("ingredient")) {
                        if (ingredients.size() >= 2) {
                            throw new XMLLoadException("Too many ingredients specified, must be no more than two");
                        }
                        NodeList ingredientNodes = tradeElement.getChildNodes();
                        for (int ingredientIndex = 0; ingredientIndex < ingredientNodes.getLength(); ++ingredientIndex) {
                            Node ingredientNode = ingredientNodes.item(ingredientIndex);
                            if (ingredientNode.getNodeType() != 1) continue;
                            ingredients.add(Pane.loadItem(instance, (Element)ingredientNode).getItem());
                        }
                        continue;
                    }
                    if (tradeElement.getTagName().equalsIgnoreCase("result")) {
                        NodeList resultNodes = tradeElement.getChildNodes();
                        for (int resultIndex = 0; resultIndex < resultNodes.getLength(); ++resultIndex) {
                            Node resultNode = resultNodes.item(resultIndex);
                            if (resultNode.getNodeType() != 1) continue;
                            if (result != null) {
                                throw new XMLLoadException("Multiple results specified for the same trade");
                            }
                            result = Pane.loadItem(instance, (Element)resultNode).getItem();
                        }
                        continue;
                    }
                    throw new XMLLoadException("Trade element is neither an ingredient nor a result");
                }
                if (result == null) {
                    throw new XMLLoadException("Trade must have a result specified");
                }
                if (ingredients.size() < 1) {
                    throw new XMLLoadException("Trade must have at least one ingredient");
                }
                MerchantRecipe recipe = new MerchantRecipe(result, Integer.MAX_VALUE);
                recipe.setIngredients(ingredients);
                merchantGui.addTrade(recipe);
                continue;
            }
            throw new XMLLoadException("Nested element is neither a component nor a trade");
        }
        return merchantGui;
    }

    @Nullable
    @Contract(pure=true)
    public static MerchantGui load(@NotNull Object instance, @NotNull InputStream inputStream) {
        return MerchantGui.load(instance, inputStream, (Plugin)JavaPlugin.getProvidingPlugin(MerchantGui.class));
    }

    @NotNull
    @Contract(pure=true)
    public static MerchantGui load(@NotNull Object instance, @NotNull Element element) {
        return MerchantGui.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(MerchantGui.class));
    }
}

