/*
 * Decompiled with CFR 0.152.
 */
package de.urbance.shaded.inventoryframework.nms.v1_16_1;

import de.urbance.shaded.inventoryframework.abstraction.MerchantInventory;
import de.urbance.shaded.inventoryframework.adventuresupport.TextHolder;
import de.urbance.shaded.inventoryframework.nms.v1_16_1.util.TextHolderUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.server.v1_16_R1.Container;
import net.minecraft.server.v1_16_R1.ContainerMerchant;
import net.minecraft.server.v1_16_R1.ContainerUtil;
import net.minecraft.server.v1_16_R1.EntityHuman;
import net.minecraft.server.v1_16_R1.EntityPlayer;
import net.minecraft.server.v1_16_R1.IChatBaseComponent;
import net.minecraft.server.v1_16_R1.IInventory;
import net.minecraft.server.v1_16_R1.IMerchant;
import net.minecraft.server.v1_16_R1.MerchantRecipe;
import net.minecraft.server.v1_16_R1.MerchantRecipeList;
import net.minecraft.server.v1_16_R1.MerchantWrapper;
import net.minecraft.server.v1_16_R1.NonNullList;
import net.minecraft.server.v1_16_R1.PlayerInventory;
import net.minecraft.server.v1_16_R1.Slot;
import net.minecraft.server.v1_16_R1.TileEntityContainer;
import net.minecraft.server.v1_16_R1.TileEntityTypes;
import net.minecraft.server.v1_16_R1.World;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftHumanEntity;
import org.bukkit.craftbukkit.v1_16_R1.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftInventoryView;
import org.bukkit.craftbukkit.v1_16_R1.inventory.CraftItemStack;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MerchantInventoryImpl
extends MerchantInventory {
    @Override
    @NotNull
    @Contract(pure=true)
    public Inventory createInventory(@NotNull TextHolder title) {
        MerchantWrapper merchant = new MerchantWrapper(null);
        InventoryViewProvider container = new InventoryViewProvider((IMerchant)merchant, title){
            final /* synthetic */ IMerchant val$merchant;
            final /* synthetic */ TextHolder val$title;
            {
                this.val$merchant = iMerchant;
                this.val$title = textHolder;
            }

            @NotNull
            @Contract(pure=true)
            public Container createContainer(int containerId, @NotNull PlayerInventory inventory) {
                return new ContainerMerchantImpl(containerId, inventory.player, (IInventory)this, this.val$merchant);
            }

            @NotNull
            @Contract(pure=true)
            public IChatBaseComponent getContainerName() {
                return TextHolderUtil.toComponent(this.val$title);
            }
        };
        return new CraftInventory((IInventory)container, (IInventory)container){
            final /* synthetic */ IInventory val$container;
            {
                this.val$container = iInventory;
                super(inventory);
            }

            @NotNull
            @Contract(pure=true)
            public InventoryType getType() {
                return InventoryType.MERCHANT;
            }

            public IInventory getInventory() {
                return this.val$container;
            }
        };
    }

    @Override
    public void sendMerchantOffers(@NotNull Player player, @NotNull List<? extends Map.Entry<? extends org.bukkit.inventory.MerchantRecipe, ? extends Integer>> trades, int level, int experience) {
        MerchantRecipeList offers = new MerchantRecipeList();
        for (Map.Entry<? extends org.bukkit.inventory.MerchantRecipe, ? extends Integer> entry : trades) {
            org.bukkit.inventory.MerchantRecipe recipe = entry.getKey();
            List ingredients = recipe.getIngredients();
            if (ingredients.size() < 1) {
                throw new IllegalStateException("Merchant recipe has no ingredients");
            }
            ItemStack itemA = (ItemStack)ingredients.get(0);
            ItemStack itemB = null;
            if (ingredients.size() >= 2) {
                itemB = (ItemStack)ingredients.get(1);
            }
            net.minecraft.server.v1_16_R1.ItemStack nmsItemA = CraftItemStack.asNMSCopy((ItemStack)itemA);
            net.minecraft.server.v1_16_R1.ItemStack nmsItemB = net.minecraft.server.v1_16_R1.ItemStack.b;
            net.minecraft.server.v1_16_R1.ItemStack nmsItemResult = CraftItemStack.asNMSCopy((ItemStack)recipe.getResult());
            if (itemB != null) {
                nmsItemB = CraftItemStack.asNMSCopy((ItemStack)itemB);
            }
            int uses = recipe.getUses();
            int maxUses = recipe.getMaxUses();
            int exp = recipe.getVillagerExperience();
            float multiplier = recipe.getPriceMultiplier();
            MerchantRecipe merchantOffer = new MerchantRecipe(nmsItemA, nmsItemB, nmsItemResult, uses, maxUses, exp, multiplier);
            merchantOffer.setSpecialPrice(entry.getValue().intValue());
            offers.add((Object)merchantOffer);
        }
        EntityPlayer entityPlayer = this.getEntityPlayer(player);
        entityPlayer.openTrade(this.getWindowId(entityPlayer), offers, level, experience, true, false);
    }

    @NotNull
    @Contract(pure=true)
    private EntityPlayer getEntityPlayer(@NotNull Player player) {
        return ((CraftPlayer)player).getHandle();
    }

    @Contract(pure=true)
    private int getWindowId(@NotNull EntityPlayer entityPlayer) {
        return entityPlayer.activeContainer.windowId;
    }

    private static class ContainerMerchantImpl
    extends ContainerMerchant {
        @NotNull
        private final HumanEntity humanEntity;
        @NotNull
        private final IInventory container;
        @Nullable
        private CraftInventoryView bukkitEntity;

        public ContainerMerchantImpl(int containerId, @NotNull EntityHuman player, @NotNull IInventory container, @NotNull IMerchant merchant) {
            super(containerId, player.inventory, merchant);
            this.humanEntity = player.getBukkitEntity();
            this.container = container;
            this.checkReachable = false;
            this.updateSlot(0, container);
            this.updateSlot(1, container);
            Slot slot = (Slot)this.slots.get(2);
            Slot newSlot = new Slot(container, slot.index, slot.e, slot.f){

                @Contract(value="_ -> false", pure=true)
                public boolean isAllowed(@Nullable EntityHuman player) {
                    return false;
                }

                @Contract(value="_ -> false", pure=true)
                public boolean isAllowed(@Nullable net.minecraft.server.v1_16_R1.ItemStack itemStack) {
                    return false;
                }
            };
            newSlot.rawSlotIndex = slot.rawSlotIndex;
            this.slots.set(2, newSlot);
        }

        @NotNull
        public CraftInventoryView getBukkitView() {
            if (this.bukkitEntity != null) {
                return this.bukkitEntity;
            }
            CraftInventory inventory = new CraftInventory(this.container);
            this.bukkitEntity = new CraftInventoryView(this.humanEntity, (Inventory)inventory, (Container)this);
            return this.bukkitEntity;
        }

        public void a(@Nullable IInventory container) {
        }

        public void b(@Nullable EntityHuman player) {
        }

        protected void a(@Nullable EntityHuman player, @Nullable World world, @Nullable IInventory container) {
        }

        public void d(int i) {
        }

        public void g(int i) {
        }

        private void updateSlot(int slotIndex, @NotNull IInventory container) {
            Slot slot = (Slot)this.slots.get(slotIndex);
            Slot newSlot = new Slot(container, slot.index, slot.e, slot.f);
            newSlot.rawSlotIndex = slot.rawSlotIndex;
            this.slots.set(slotIndex, newSlot);
        }
    }

    private static abstract class InventoryViewProvider
    extends TileEntityContainer {
        private final NonNullList<net.minecraft.server.v1_16_R1.ItemStack> items = NonNullList.a((int)3, (Object)net.minecraft.server.v1_16_R1.ItemStack.b);
        private final List<HumanEntity> transaction = new ArrayList<HumanEntity>();
        private int maxStack = 64;

        protected InventoryViewProvider() {
            super(TileEntityTypes.FURNACE);
        }

        public void clear() {
            this.items.clear();
            this.update();
        }

        public int getSize() {
            return 3;
        }

        public boolean isEmpty() {
            for (net.minecraft.server.v1_16_R1.ItemStack itemStack : this.items) {
                if (itemStack.isEmpty()) continue;
                return false;
            }
            return true;
        }

        public net.minecraft.server.v1_16_R1.ItemStack getItem(int index) {
            return index >= 0 && index < this.items.size() ? (net.minecraft.server.v1_16_R1.ItemStack)this.items.get(index) : net.minecraft.server.v1_16_R1.ItemStack.b;
        }

        public net.minecraft.server.v1_16_R1.ItemStack splitStack(int firstIndex, int secondIndex) {
            net.minecraft.server.v1_16_R1.ItemStack itemstack = ContainerUtil.a(this.items, (int)firstIndex, (int)secondIndex);
            if (!itemstack.isEmpty()) {
                this.update();
            }
            return itemstack;
        }

        public net.minecraft.server.v1_16_R1.ItemStack splitWithoutUpdate(int index) {
            net.minecraft.server.v1_16_R1.ItemStack itemStack = (net.minecraft.server.v1_16_R1.ItemStack)this.items.get(index);
            if (itemStack.isEmpty()) {
                return net.minecraft.server.v1_16_R1.ItemStack.b;
            }
            this.items.set(index, (Object)net.minecraft.server.v1_16_R1.ItemStack.b);
            return itemStack;
        }

        public void setItem(int index, net.minecraft.server.v1_16_R1.ItemStack itemStack) {
            this.items.set(index, (Object)itemStack);
            if (!itemStack.isEmpty() && itemStack.getCount() > this.getMaxStackSize()) {
                itemStack.setCount(this.getMaxStackSize());
            }
            this.update();
        }

        public int getMaxStackSize() {
            return this.maxStack;
        }

        public boolean a(EntityHuman entityHuman) {
            return true;
        }

        public List<net.minecraft.server.v1_16_R1.ItemStack> getContents() {
            return this.items;
        }

        public void onOpen(CraftHumanEntity craftHumanEntity) {
            this.transaction.add((HumanEntity)craftHumanEntity);
        }

        public void onClose(CraftHumanEntity craftHumanEntity) {
            this.transaction.remove(craftHumanEntity);
        }

        public List<HumanEntity> getViewers() {
            return this.transaction;
        }

        public void setMaxStackSize(int maxStack) {
            this.maxStack = maxStack;
        }
    }
}

