/*
 * Decompiled with CFR 0.152.
 */
package Commands;

import GUI.OverviewGUI;
import Utils.ConfigManagement;
import Utils.KudosUtils.KudosManagement;
import Utils.KudosUtils.KudosMessage;
import Utils.SQL.SQLGetter;
import Utils.WorkaroundManagement;
import de.urbance.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;

public class Kudos
implements CommandExecutor,
TabCompleter {
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private FileConfiguration locale;
    private SQLGetter data;
    private UUID targetPlayer;
    private KudosManagement kudosManagement;
    private KudosMessage kudosMessage;

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (WorkaroundManagement.isLegacyConfig || WorkaroundManagement.isSQLMigrationNeeded || WorkaroundManagement.isConfigMigrationNeeded) {
            return false;
        }
        this.locale = ConfigManagement.getLocalesConfig();
        this.data = new SQLGetter(this.plugin);
        this.kudosManagement = new KudosManagement();
        this.kudosMessage = new KudosMessage(this.plugin);
        if (!this.validateInput(args, sender)) {
            return false;
        }
        if (args.length == 0) {
            this.openGUI(sender);
        }
        if (args.length == 1) {
            this.showKudos(sender);
        }
        return false;
    }

    public void openGUI(CommandSender sender) {
        if (!(sender instanceof Player)) {
            Bukkit.getServer().getLogger().info("Please use /kudos [player]");
            return;
        }
        if (!sender.hasPermission("kudos.player.gui") && !sender.hasPermission("kudos.player.*")) {
            this.kudosMessage.noPermission(sender);
            return;
        }
        FileConfiguration overviewConfig = ConfigManagement.getOverviewGuiConfig();
        if (!overviewConfig.getBoolean("general-settings.enabled")) {
            this.kudosMessage.sendSender(sender, this.locale.getString("error.specify-player"));
            return;
        }
        Player player = Bukkit.getPlayer((String)sender.getName());
        OverviewGUI kudosGUI = new OverviewGUI();
        kudosGUI.open(player);
    }

    public void showKudos(CommandSender sender) {
        if (!sender.hasPermission("kudos.player.show") && !sender.hasPermission("kudos.player.*")) {
            this.kudosMessage.noPermission(sender);
            return;
        }
        this.kudosManagement.showPlayerKudos(sender, this.targetPlayer);
    }

    public boolean validateInput(String[] args, CommandSender sender) {
        if (args.length == 0) {
            return true;
        }
        if (args.length > 1) {
            this.kudosMessage.wrongUsage(sender);
            return false;
        }
        if (args.length == 1) {
            boolean targetPlayerExists = this.data.existsByDisplayName(args[0]);
            if (targetPlayerExists) {
                this.targetPlayer = this.data.getPlayerByDisplayName(args[0]);
                return true;
            }
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("kudos_targetplayer_name", args[0]);
            this.kudosMessage.sendSender(sender, this.kudosMessage.setPlaceholders(this.locale.getString("error.player-not-found"), values));
            return false;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        ArrayList<String> playerNameList = new ArrayList<String>();
        ArrayList<String> tabCompletions = new ArrayList<String>();
        if (!sender.hasPermission("kudos.player.show") && !sender.hasPermission("kudos.player.*")) {
            return playerNameList;
        }
        if (WorkaroundManagement.isConfigMigrationNeeded) {
            return tabCompletions;
        }
        if (args.length == 1) {
            for (Player player : Bukkit.getOnlinePlayers()) {
                playerNameList.add(player.getName());
            }
            StringUtil.copyPartialMatches((String)args[0], playerNameList, tabCompletions);
        }
        return tabCompletions;
    }
}

