/*
 * Decompiled with CFR 0.152.
 */
package Events;

import Utils.ConfigManagement;
import Utils.SQL.SQLGetter;
import Utils.WorkaroundManagement;
import de.urbance.Main;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class OnPlayerJoin
implements Listener {
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private FileConfiguration locale = ConfigManagement.getLocalesConfig();

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        String prefix = this.plugin.prefix;
        this.sendNoDatabaseFoundMessage(player, prefix);
        if (!this.createDatabasePlayer(uuid)) {
            Bukkit.getLogger().warning(prefix + "An error has occurred: No player could be created in the database. Please contact the system administrator or the developer of the plugin");
            return;
        }
        this.sendWorkaroundNeededMessage(player);
    }

    private void sendNoDatabaseFoundMessage(Player player, String prefix) {
        if (!this.plugin.isConnected && player.hasPermission("kudos.admin.*")) {
            player.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(prefix + "&cNo database found. If you're trying to connect to a database server please check your credentials in the mysql.yml!")));
        }
    }

    private boolean createDatabasePlayer(UUID uuid) {
        if (!this.plugin.isConnected) {
            return false;
        }
        if (Main.oldTableScheme) {
            return true;
        }
        SQLGetter data = new SQLGetter(this.plugin);
        return data.updatePlayer(uuid);
    }

    private void sendWorkaroundNeededMessage(Player player) {
        if (!player.hasPermission("kudos.admin.*")) {
            return;
        }
        if (WorkaroundManagement.isLegacyConfig) {
            WorkaroundManagement.notifyInstanceAboutLegacyWorkaround((CommandSender)player);
            return;
        }
        if (WorkaroundManagement.isSQLMigrationNeeded || WorkaroundManagement.isConfigMigrationNeeded) {
            WorkaroundManagement.notifyInstanceAboutWorkaround((CommandSender)player);
        }
    }
}

