/*
 * Decompiled with CFR 0.152.
 */
package GUI;

import GUI.GUI_Interface;
import GUI.OverviewGUI;
import Utils.ConfigManagement;
import Utils.ItemCreator;
import Utils.KudosUtils.UrbanceGUI;
import Utils.SQL.SQLGetter;
import de.urbance.Main;
import de.urbance.shaded.inventoryframework.gui.GuiItem;
import de.urbance.shaded.inventoryframework.gui.type.ChestGui;
import de.urbance.shaded.inventoryframework.pane.PaginatedPane;
import de.urbance.shaded.inventoryframework.pane.StaticPane;
import de.urbance.shaded.inventoryframework.pane.util.Slot;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class ReceivedKudosGUI
implements GUI_Interface,
Listener {
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private SQLGetter data;
    private FileConfiguration receivedKudosConfig;
    private ChestGui receivedKudosGUI;
    private PaginatedPane paginatedPane;
    private HashMap<Integer, String> receivedKudosList;
    private Player player;
    private int lastPage;
    private UrbanceGUI urbanceGUI;

    public ReceivedKudosGUI() {
        this.data = this.plugin.data;
        this.receivedKudosConfig = ConfigManagement.getReceivedKudosGuiConfig();
    }

    private void init() {
        this.createGUI();
        this.fillGUI();
        this.receivedKudosGUI.addPane(this.paginatedPane);
    }

    private void fillGUI() {
        this.paginatedPane = new PaginatedPane(0, 0, 9, 1);
        this.receivedKudosList = this.data.getPlayerReceivedKudosGUI(this.player.getUniqueId());
        int totalEntries = this.receivedKudosList.size();
        if (this.receivedKudosList.isEmpty()) {
            return;
        }
        int entriesPerPane = 5;
        this.lastPage = (int)Math.ceil((double)totalEntries / (double)entriesPerPane);
        this.createReceivedKudosPanes(entriesPerPane, totalEntries);
    }

    private void createGUI() {
        FileConfiguration globalGuiSettingsConfig = ConfigManagement.getGlobalGuiSettingsConfig();
        String guiTitle = globalGuiSettingsConfig.getString("general-settings.gui-title");
        this.urbanceGUI = new UrbanceGUI();
        this.receivedKudosGUI = this.urbanceGUI.create(guiTitle, 1).cancelOnGlobalClick(true).get();
    }

    private void createReceivedKudosPanes(int entriesPerPane, int totalEntries) {
        for (int page = 1; page <= this.lastPage; ++page) {
            StaticPane staticPane = new StaticPane(0, 0, 9, 1);
            this.paginatedPane.addPane(page, staticPane);
            this.fillReceivedKudosPane(staticPane, page, entriesPerPane, totalEntries);
        }
    }

    private void fillReceivedKudosPane(StaticPane staticPane, int currentPage, int entriesPerPane, int totalEntries) {
        String serverURLSkull = "http://textures.minecraft.net/texture/b0f10e85418e334f82673eb4940b208ecaee0c95c287685e9eaf24751a315bfa";
        GuiItem pageSwitcherLeft = this.urbanceGUI.getBackwardsPageSwitcher();
        pageSwitcherLeft.setAction(inventoryClickEvent -> {
            if (currentPage == 1) {
                new OverviewGUI().open(this.player);
            } else {
                this.paginatedPane.setPage(currentPage - 1);
                this.receivedKudosGUI.update();
            }
            this.urbanceGUI.playsoundPageSwitcher(this.player);
        });
        GuiItem pageSwitcherRight = this.urbanceGUI.getForwardsPageSwitcher();
        pageSwitcherRight.setAction(inventoryClickEvent -> {
            this.paginatedPane.setPage(currentPage + 1);
            this.receivedKudosGUI.update();
            this.urbanceGUI.playsoundPageSwitcher(this.player);
        });
        int inventorySlot = 2;
        int firstKudoReceivedListEntry = (currentPage - 1) * 5;
        int lastKudoReceivedListEntry = Math.min(firstKudoReceivedListEntry + entriesPerPane, totalEntries);
        for (int entry = firstKudoReceivedListEntry; entry < lastKudoReceivedListEntry; ++entry) {
            String[] unsplittedReceivedKudosList = this.receivedKudosList.get(entry).split("@");
            String playerName = unsplittedReceivedKudosList[0].equals(SQLGetter.consoleCommandSenderPrefix) ? ConfigManagement.getConfig().getString("general-settings.console-name") : unsplittedReceivedKudosList[0];
            String awardReason = unsplittedReceivedKudosList[1];
            String awardDateString = unsplittedReceivedKudosList[2];
            LocalDateTime awardDate = LocalDateTime.parse(awardDateString);
            awardDateString = awardDate.format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"));
            List itemLore = this.receivedKudosConfig.getStringList("items.received-kudos-item.item-lore");
            ArrayList<String> modifiedItemLore = new ArrayList<String>();
            for (String itemLoreEntry : itemLore) {
                itemLoreEntry = itemLoreEntry.replace("%kudos_award_reason%", awardReason);
                itemLoreEntry = itemLoreEntry.replace("%kudos_award_date%", awardDateString);
                itemLoreEntry = itemLoreEntry.replace("%kudos_award_player%", playerName);
                modifiedItemLore.add(itemLoreEntry);
            }
            ItemCreator playerHead = new ItemCreator("PLAYER_HEAD");
            if (playerName.equals(ConfigManagement.getConfig().getString("general-settings.console-name"))) {
                playerHead.setDisplayName("&2" + playerName).replaceSkullWithCustomURLSkull(serverURLSkull);
            } else {
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)playerName);
                playerHead.setDisplayName("&2" + offlinePlayer.getName()).replaceSkullWithPlayerSkull(offlinePlayer);
            }
            playerHead.setLore(modifiedItemLore);
            staticPane.addItem(new GuiItem(playerHead.get()), Slot.fromIndex(inventorySlot));
            ++inventorySlot;
        }
        staticPane.addItem(pageSwitcherLeft, Slot.fromIndex(0));
        if (currentPage != this.lastPage) {
            staticPane.addItem(pageSwitcherRight, Slot.fromIndex(8));
        }
    }

    @Override
    public void open(Player player) {
        this.player = player;
        this.init();
        this.paginatedPane.setPage(1);
        this.receivedKudosGUI.show((HumanEntity)player);
    }
}

