/*
 * Decompiled with CFR 0.152.
 */
package Utils.KudosUtils;

import Utils.ConfigManagement;
import Utils.KudosUtils.KudosManagement;
import Utils.KudosUtils.KudosNotification;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class KudosAward {
    private FileConfiguration config = ConfigManagement.getConfig();
    private KudosManagement kudosManagement = new KudosManagement();

    public boolean sendKudoAward(CommandSender sender, Player targetPlayer, String reason) {
        if (!this.addRewards(sender, targetPlayer)) {
            return false;
        }
        if (!this.kudosManagement.addKudo(sender, targetPlayer.getUniqueId(), reason)) {
            return false;
        }
        this.sendNotification(sender, targetPlayer, reason);
        return true;
    }

    private void sendNotification(CommandSender sender, Player targetPlayer, String reason) {
        if (!this.config.getBoolean("kudo-award.notification.enabled")) {
            return;
        }
        KudosNotification kudosNotification = new KudosNotification();
        String notificationMode = this.kudosManagement.getNotificationMode();
        this.playNotificationSound(sender, targetPlayer, notificationMode);
        if (sender instanceof ConsoleCommandSender) {
            kudosNotification.fromConsole(targetPlayer, reason);
            return;
        }
        switch (notificationMode) {
            case "broadcast": {
                kudosNotification.sendBroadcastMessage(sender, targetPlayer, reason);
                break;
            }
            case "private": {
                kudosNotification.sendPrivate(sender, targetPlayer, reason);
            }
        }
    }

    private boolean addRewards(CommandSender sender, Player targetPlayer) {
        if (!this.kudosManagement.addItemRewards(sender, targetPlayer, "kudo-award.rewards.items")) {
            return false;
        }
        this.kudosManagement.performCommandRewards(KudosManagement.AwardType.AWARD, targetPlayer);
        targetPlayer.giveExp(this.config.getInt("kudo-award.rewards.xp"));
        return true;
    }

    private void playNotificationSound(CommandSender sender, Player targetPlayer, String notificationMode) {
        if (!this.config.getBoolean("kudo-award.notification.enable-playsound")) {
            return;
        }
        if (notificationMode.equals("private") || notificationMode.equals("broadcast")) {
            this.kudosManagement.playSound(sender, targetPlayer, this.config.getString("kudo-award.notification.playsound-type"));
        }
    }
}

