/*
 * Decompiled with CFR 0.152.
 */
package Utils.KudosUtils;

import Utils.ConfigManagement;
import Utils.KudosUtils.KudosMessage;
import de.urbance.Main;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.time.DateUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class KudosLimitation {
    private final Map<UUID, Integer> receivedKudos = new HashMap<UUID, Integer>();
    private final Map<UUID, Date> receivedKudosTime = new HashMap<UUID, Date>();
    FileConfiguration config;
    UUID targetPlayerUUID;

    public boolean setLimitation(CommandSender sender, Player targetPlayer) {
        Main plugin = (Main)Main.getPlugin(Main.class);
        this.config = ConfigManagement.getConfig();
        this.targetPlayerUUID = targetPlayer.getUniqueId();
        KudosMessage kudosMessage = new KudosMessage(plugin);
        FileConfiguration localeConfig = ConfigManagement.getLocalesConfig();
        Date currentDate = new Date();
        if (!this.receivedKudos.containsKey(this.targetPlayerUUID)) {
            this.initFirstKudo();
            return true;
        }
        if (currentDate.after(this.receivedKudosTime.get(this.targetPlayerUUID))) {
            this.clearLimitation();
            this.initFirstKudo();
            return true;
        }
        if (this.receivedKudos.get(this.targetPlayerUUID).equals(this.config.getInt("kudo-award.limitation.max-kudos-to-receive"))) {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("kudos_targetplayer_name", targetPlayer.getName());
            kudosMessage.sendSender(sender, kudosMessage.setPlaceholders(localeConfig.getString("error.player-received-too-many-kudos-last-time"), values));
            return false;
        }
        this.addReceivedKudo();
        return true;
    }

    private void addReceivedKudo() {
        this.receivedKudos.put(this.targetPlayerUUID, this.receivedKudos.get(this.targetPlayerUUID) + 1);
    }

    private void initFirstKudo() {
        Date currDate = new Date();
        this.receivedKudosTime.put(this.targetPlayerUUID, DateUtils.addSeconds((Date)currDate, (int)this.config.getInt("kudo-award.limitation.cooldown")));
        this.receivedKudos.put(this.targetPlayerUUID, 1);
    }

    private void clearLimitation() {
        this.receivedKudos.remove(this.targetPlayerUUID);
        this.receivedKudosTime.remove(this.targetPlayerUUID);
    }
}

