/*
 * Decompiled with CFR 0.152.
 */
package Utils.KudosUtils;

import Utils.ConfigManagement;
import Utils.ItemCreator;
import Utils.KudosUtils.KudosMessage;
import Utils.SQL.SQLGetter;
import de.urbance.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.java.JavaPlugin;

public class KudosManagement {
    private Main plugin = (Main)JavaPlugin.getPlugin(Main.class);
    private SQLGetter data = new SQLGetter(this.plugin);
    private FileConfiguration config = ConfigManagement.getConfig();
    private FileConfiguration locale = ConfigManagement.getLocalesConfig();
    private KudosMessage kudosMessage = new KudosMessage(this.plugin);

    public boolean addKudo(CommandSender sender, UUID targetPlayerUUID, String reason) {
        if (sender instanceof Player) {
            boolean kudosAdded = this.data.addKudos(targetPlayerUUID, String.valueOf(((Player)sender).getUniqueId()), reason, 1);
            if (kudosAdded) {
                return true;
            }
            this.kudosMessage.sendSender(sender, "An error has occurred: Please contact the system administrator or the developer of the plugin.");
            return false;
        }
        if (sender instanceof ConsoleCommandSender) {
            boolean kudosAdded = this.data.addKudos(targetPlayerUUID, SQLGetter.consoleCommandSenderPrefix, reason, 1);
            if (kudosAdded) {
                return true;
            }
            this.kudosMessage.sendSender(sender, "An error has occurred: Please contact the system administrator or the developer of the plugin.");
            return false;
        }
        return false;
    }

    public void showPlayerKudos(CommandSender sender, UUID targetPlayer) {
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("kudos_targetplayer_name", this.data.getPlayerDisplayName(targetPlayer.toString()));
        values.put("kudos_targetplayer_kudos", String.valueOf(this.data.getAmountKudos(targetPlayer)));
        this.kudosMessage.sendSender(sender, this.kudosMessage.setPlaceholders(this.locale.getString("kudos.show-player-kudos"), values));
    }

    public void playSound(CommandSender sender, Player targetPlayer, String playSoundType) {
        String prefix = this.plugin.prefix;
        if (this.getNotificationMode().equals("private") && !this.isMilestone(targetPlayer) && sender instanceof Player) {
            Player player = (Player)sender;
            player.playSound(player.getLocation(), Sound.valueOf((String)playSoundType), 1.0f, 1.0f);
            targetPlayer.playSound(targetPlayer.getLocation(), Sound.valueOf((String)playSoundType), 1.0f, 1.0f);
            return;
        }
        for (Player players : Bukkit.getOnlinePlayers()) {
            try {
                players.playSound((Entity)players, Sound.valueOf((String)playSoundType), 1.0f, 1.0f);
            }
            catch (Exception e) {
                Bukkit.getLogger().warning(prefix + "Error in the config: playsound-type \"" + playSoundType + "\" isn't a valid playsound!");
                return;
            }
        }
    }

    public String getNotificationMode() {
        if (this.config.getString("kudo-award.notification.notification-mode").equals("private")) {
            return "private";
        }
        return "broadcast";
    }

    public boolean isMilestone(Player targetPlayer) {
        if (this.config.getBoolean("kudo-award.milestones.enabled")) {
            int targetPlayerKudos = this.data.getAmountKudos(targetPlayer.getUniqueId()) + 1;
            return targetPlayerKudos % this.config.getInt("kudo-award.milestones.span-between-kudos") == 0;
        }
        return false;
    }

    public boolean itemCanBeAddedToInventory(ArrayList<ItemStack> itemsThatShouldBeAdded, Player targetplayer) {
        ArrayList<ItemStack> itemsThatCanBeAdded = new ArrayList<ItemStack>();
        PlayerInventory targetplayerInventory = targetplayer.getInventory();
        Inventory dummyInventory = Bukkit.createInventory(null, (int)36);
        targetplayer.updateInventory();
        for (int slot = 0; slot < 36; ++slot) {
            ItemStack itemStack = targetplayerInventory.getItem(slot);
            if (itemStack == null) continue;
            dummyInventory.setItem(slot, targetplayerInventory.getItem(slot));
        }
        for (ItemStack itemStack : itemsThatShouldBeAdded) {
            if (!dummyInventory.addItem(new ItemStack[]{itemStack}).isEmpty()) continue;
            itemsThatCanBeAdded.add(itemStack);
        }
        return itemsThatCanBeAdded.size() == itemsThatShouldBeAdded.size();
    }

    public void sendInventoryIsFullMessage(CommandSender sender, Player targetPlayer) {
        HashMap<String, String> placeholderValues = new HashMap<String, String>();
        placeholderValues.put("kudos_targetplayer_name", targetPlayer.getName());
        this.kudosMessage.sendSender(sender, this.kudosMessage.setPlaceholders(this.locale.getString("error.player-inventory-is-full"), placeholderValues));
    }

    public void performCommandRewards(AwardType awardType, Player targetPlayer) {
        switch (awardType.ordinal()) {
            case 0: {
                if (!this.config.getBoolean("kudo-award.rewards.command-rewards.enabled")) {
                    return;
                }
                for (String commands : this.config.getStringList("kudo-award.rewards.command-rewards.commands")) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    values.put("kudos_player_name", targetPlayer.getName());
                    String command = new KudosMessage(this.plugin).setPlaceholders(commands, values);
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
                }
                break;
            }
            case 1: {
                if (!this.config.getBoolean("kudo-award.milestones.rewards.command-rewards.enabled")) {
                    return;
                }
                for (String commands : this.config.getStringList("kudo-award.milestones.rewards.command-rewards.commands")) {
                    HashMap<String, String> values = new HashMap<String, String>();
                    values.put("kudos_player_name", targetPlayer.getName());
                    String command = new KudosMessage(this.plugin).setPlaceholders(commands, values);
                    Bukkit.getServer().dispatchCommand((CommandSender)Bukkit.getConsoleSender(), command);
                }
                break;
            }
        }
    }

    public boolean addItemRewards(CommandSender sender, Player targetplayer, String configItemRewardsListPath) {
        PlayerInventory targetplayerInventory = targetplayer.getInventory();
        ArrayList<ItemStack> itemStackList = this.getItemRewards(configItemRewardsListPath);
        if (!this.itemCanBeAddedToInventory(itemStackList, targetplayer)) {
            this.sendInventoryIsFullMessage(sender, targetplayer);
            return false;
        }
        for (ItemStack itemStack : itemStackList) {
            targetplayerInventory.addItem(new ItemStack[]{itemStack});
        }
        targetplayer.updateInventory();
        return true;
    }

    public ArrayList<ItemStack> getItemRewards(String configItemRewardsListPath) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (String itemKey : this.config.getConfigurationSection(configItemRewardsListPath).getKeys(false)) {
            String configItemRewardsPathKey = configItemRewardsListPath + "." + itemKey;
            if (!this.config.getBoolean(configItemRewardsPathKey + ".enabled")) continue;
            ItemCreator itemCreator = new ItemCreator(this.config.getString(configItemRewardsPathKey + ".material"));
            itemCreator.setDisplayName(this.config.getString(configItemRewardsPathKey + ".item-name"));
            itemCreator.setAmount(this.config.getInt(configItemRewardsPathKey + ".amount"));
            if (this.config.getBoolean(configItemRewardsPathKey + ".use-lore")) {
                itemCreator.setLore(this.config.getStringList(configItemRewardsPathKey + ".item-lore"));
            }
            itemStacks.add(itemCreator.get());
        }
        return itemStacks;
    }

    public String getReason(String[] args, int startIndex) {
        Object reason = args[startIndex - 1];
        int endIndex = args.length;
        for (int argumentPosition = startIndex; argumentPosition < endIndex; ++argumentPosition) {
            reason = (String)reason + " " + args[argumentPosition];
        }
        return reason;
    }

    public static enum AwardType {
        AWARD,
        MILESTONE;

    }
}

