/*
 * Decompiled with CFR 0.152.
 */
package Utils.KudosUtils;

import Utils.ConfigManagement;
import Utils.KudosUtils.KudosManagement;
import Utils.KudosUtils.KudosMessage;
import Utils.SQL.SQLGetter;
import de.urbance.Main;
import java.util.HashMap;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class KudosMilestone {
    private Main plugin = (Main)JavaPlugin.getPlugin(Main.class);
    private FileConfiguration config = ConfigManagement.getConfig();
    private SQLGetter data = new SQLGetter(this.plugin);
    private FileConfiguration locale = ConfigManagement.getLocalesConfig();
    private KudosMessage kudosMessage = new KudosMessage(this.plugin);
    private KudosManagement kudosManagement = new KudosManagement();

    public boolean sendMilestone(CommandSender sender, Player targetPlayer, String reason) {
        if (!this.addRewards(sender, targetPlayer)) {
            return false;
        }
        if (!this.kudosManagement.addKudo(sender, targetPlayer.getUniqueId(), reason)) {
            return false;
        }
        HashMap<String, String> placeholderValues = new HashMap<String, String>();
        placeholderValues.put("kudos_targetplayer_name", targetPlayer.getName());
        placeholderValues.put("kudos_targetplayer_kudos", String.valueOf(this.data.getAmountKudos(targetPlayer.getUniqueId())));
        if (reason != null) {
            placeholderValues.put("kudos_award_reason", reason);
        }
        String milestonesMessage = this.locale.getString("error.something-went-wrong-by-sending-milestone-broadcast");
        if (sender instanceof ConsoleCommandSender) {
            milestonesMessage = reason == null ? this.kudosMessage.setPlaceholders(this.locale.getString("milestone.player-reaches-milestone-through-console"), placeholderValues) : this.kudosMessage.setPlaceholders(this.locale.getString("milestone.player-reaches-milestone-through-console-with-reason"), placeholderValues);
        }
        if (sender instanceof Player) {
            placeholderValues.put("kudos_player_name", sender.getName());
            milestonesMessage = reason == null ? this.kudosMessage.setPlaceholders(this.locale.getString("milestone.player-reaches-milestone"), placeholderValues) : this.kudosMessage.setPlaceholders(this.locale.getString("milestone.player-reaches-milestone-with-reason"), placeholderValues);
        }
        if (!Objects.equals(milestonesMessage, this.locale.getString("error.something-went-wrong-by-sending-milestone-broadcast")) || milestonesMessage != null) {
            this.kudosMessage.broadcast(milestonesMessage);
            this.playMilestoneSound(sender, targetPlayer);
            return true;
        }
        this.kudosMessage.sendSender(sender, milestonesMessage);
        Bukkit.getLogger().warning(this.plugin.prefix + "Something went wrong by sending the milestone broadcast during a milestone for player " + String.valueOf(targetPlayer) + " from player " + sender.getName() + "!");
        return false;
    }

    private boolean addRewards(CommandSender sender, Player targetPlayer) {
        if (!this.kudosManagement.addItemRewards(sender, targetPlayer, "kudo-award.milestones.rewards.items")) {
            return false;
        }
        new KudosManagement().performCommandRewards(KudosManagement.AwardType.MILESTONE, targetPlayer);
        targetPlayer.giveExp(this.config.getInt("kudo-award.milestones.rewards.xp"));
        return true;
    }

    private void playMilestoneSound(CommandSender sender, Player targetPlayer) {
        if (!this.config.getBoolean("kudo-award.milestones.playsound.enabled")) {
            return;
        }
        this.kudosManagement.playSound(sender, targetPlayer, this.config.getString("kudo-award.milestones.playsound.playsound-type"));
    }
}

