/*
 * Decompiled with CFR 0.152.
 */
package Utils.KudosUtils;

import Utils.ConfigManagement;
import Utils.KudosUtils.KudosMessage;
import Utils.SQL.SQLGetter;
import de.urbance.Main;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class KudosNotification {
    private KudosMessage kudosMessage;
    private SQLGetter data;
    private FileConfiguration locale;

    public KudosNotification() {
        Main plugin = (Main)JavaPlugin.getPlugin(Main.class);
        this.kudosMessage = new KudosMessage(plugin);
        this.data = new SQLGetter(plugin);
        this.locale = ConfigManagement.getLocalesConfig();
    }

    public void fromConsole(Player targetPlayer, String reason) {
        UUID targetPlayerUUID = targetPlayer.getUniqueId();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("kudos_targetplayer_name", targetPlayer.getName());
        values.put("kudos_targetplayer_kudos", String.valueOf(this.data.getAmountKudos(targetPlayerUUID)));
        String awardMessage = this.kudosMessage.setPlaceholders(this.locale.getString("kudo.player-award-kudo-from-console"), values);
        if (reason != null) {
            values.put("kudos_award_reason", reason);
            awardMessage = this.kudosMessage.setPlaceholders(this.locale.getString("kudo.player-award-kudo-from-console-with-reason"), values);
        }
        this.kudosMessage.broadcast(awardMessage);
    }

    public void sendBroadcastMessage(CommandSender sender, Player targetPlayer, String reason) {
        UUID targetPlayerUUID = targetPlayer.getUniqueId();
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("kudos_player_name", sender.getName());
        values.put("kudos_targetplayer_name", targetPlayer.getName());
        values.put("kudos_targetplayer_kudos", String.valueOf(this.data.getAmountKudos(targetPlayerUUID)));
        String awardMessage = this.kudosMessage.setPlaceholders(this.locale.getString("kudo.player-award-kudo-broadcast"), values);
        if (reason != null) {
            values.put("kudos_award_reason", reason);
            awardMessage = this.kudosMessage.setPlaceholders(this.locale.getString("kudo.player-award-kudo-broadcast-with-reason"), values);
        }
        this.kudosMessage.broadcast(awardMessage);
    }

    public void sendPrivate(CommandSender sender, Player targetPlayer, String reason) {
        this.sendPrivateMessageToSender(sender, targetPlayer);
        this.sendPrivateMessageToTargetPlayer(sender, targetPlayer, reason);
    }

    private void sendPrivateMessageToSender(CommandSender sender, Player targetPlayer) {
        HashMap<String, String> valuesSender = new HashMap<String, String>();
        valuesSender.put("kudos_targetplayer_name", targetPlayer.getName());
        this.kudosMessage.sendSender(sender, this.kudosMessage.setPlaceholders(this.locale.getString("kudo.player-assigned-kudo"), valuesSender));
    }

    private void sendPrivateMessageToTargetPlayer(CommandSender sender, Player targetPlayer, String reason) {
        HashMap<String, String> valuesTargetPlayer = new HashMap<String, String>();
        valuesTargetPlayer.put("kudos_player_name", sender.getName());
        valuesTargetPlayer.put("kudos_player_kudos", String.valueOf(this.data.getAmountKudos(targetPlayer.getUniqueId()) + 1));
        String awardMessage = this.kudosMessage.setPlaceholders(this.locale.getString("kudo.player-award-kudo-from-player"), valuesTargetPlayer);
        if (reason != null) {
            valuesTargetPlayer.put("kudos_award_reason", reason);
            awardMessage = this.kudosMessage.setPlaceholders(this.locale.getString("kudo.player-award-kudo-from-player-with-reason"), valuesTargetPlayer);
        }
        this.kudosMessage.send(targetPlayer, awardMessage);
    }
}

