/*
 * Decompiled with CFR 0.152.
 */
package Utils.SQL;

import Utils.ConfigManagement;
import Utils.SQL.SQLGetter;
import de.urbance.Main;
import de.urbance.shaded.hikaricp.hikari.HikariConfig;
import de.urbance.shaded.hikaricp.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import org.bukkit.configuration.file.FileConfiguration;

public class SQL {
    private static HikariConfig hikariConfig = new HikariConfig();
    private static HikariDataSource hikariDataSource;
    private FileConfiguration mysqlConfig;
    private FileConfiguration config;
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private String host;
    private String port;
    private String database;
    private String username;
    private String password;
    private String useSSL;

    public SQL() {
        this.config = this.plugin.getConfig();
        this.mysqlConfig = ConfigManagement.getMySQLConfig();
        this.host = this.mysqlConfig.getString("hostname");
        this.port = this.mysqlConfig.getString("port");
        this.database = this.mysqlConfig.getString("database");
        this.username = this.mysqlConfig.getString("username");
        this.password = this.mysqlConfig.getString("password");
        this.useSSL = this.mysqlConfig.getString("useSSL");
    }

    public void connect() {
        boolean useMySQL = this.config.getBoolean("general-settings.use-MySQL");
        if (this.config.isConfigurationSection("general")) {
            useMySQL = this.config.getBoolean("general.use-SQL");
        }
        if (useMySQL) {
            hikariConfig.setJdbcUrl(String.format("jdbc:mysql://%s:%s/%s?&useSSL=%s", this.host, this.port, this.database, this.useSSL));
            hikariConfig.setDriverClassName("com.mysql.jdbc.Driver");
            hikariConfig.setUsername(this.username);
            hikariConfig.setPassword(this.password);
            hikariConfig.addDataSourceProperty("prepStmtCacheSize", 250);
            hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", 2048);
            hikariConfig.addDataSourceProperty("cachePrepStmts", true);
            hikariConfig.addDataSourceProperty("useServerPrepStmts ", true);
        } else {
            String dataFolderPath = String.format("%s/data", this.plugin.getDataFolder());
            this.createDataFolder(dataFolderPath);
            hikariConfig.setJdbcUrl(String.format("jdbc:sqlite:%s/database.db", dataFolderPath));
            hikariConfig.setDriverClassName("org.sqlite.JDBC");
        }
        SQLGetter.driverClassName = hikariConfig.getDriverClassName();
        hikariDataSource = new HikariDataSource(hikariConfig);
    }

    public static void disconnect() {
        hikariDataSource.close();
    }

    public static Connection getConnection() throws SQLException {
        return hikariDataSource.getConnection();
    }

    private void createDataFolder(String dataFolderPath) {
        File dataFolder = new File(dataFolderPath);
        if (!dataFolder.exists()) {
            dataFolder.mkdir();
        }
    }
}

