/*
 * Decompiled with CFR 0.152.
 */
package Utils.SQL;

import Utils.ConfigManagement;
import Utils.SQL.SQL;
import Utils.UrbanceDebug;
import de.urbance.Main;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;

public class SQLGetter {
    public static String driverClassName;
    public static String consoleCommandSenderPrefix;
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private FileConfiguration config = ConfigManagement.getConfig();

    public SQLGetter(Main plugin) {
    }

    public boolean initTables() {
        return this.createPlayersTable() && this.createKudosTable();
    }

    public boolean oldDateFormatUsed() {
        String rawFirstAwardedKudoDate = null;
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT Date FROM `kudos` ORDER BY Date ASC LIMIT 1;");){
            ResultSet results = preparedStatement.executeQuery();
            if (results.next()) {
                rawFirstAwardedKudoDate = results.getString("Date");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        if (rawFirstAwardedKudoDate == null) {
            return false;
        }
        try {
            LocalDateTime.parse(rawFirstAwardedKudoDate, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (DateTimeException e) {
            return true;
        }
        return false;
    }

    public boolean convertOldDateFormatToNewDateFormat() {
        UrbanceDebug.sendInfo("Step: SQLGetter.ConvertOldDateFormatToNewDateFormat");
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT KudoID, Date FROM kudos");){
            ResultSet results = preparedStatement.executeQuery();
            PreparedStatement updateDatesPreparedStatement = connection.prepareStatement("UPDATE kudos SET Date=? WHERE KudoID=?");
            int updatedRows = 0;
            while (results.next()) {
                String kudoID = results.getString("KudoID");
                String oldDate = results.getString("Date");
                DateTimeFormatter oldDateTimeFormat = DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss");
                LocalDateTime oldDateTime = LocalDateTime.parse(oldDate, oldDateTimeFormat);
                String newDate = oldDateTime.format(DateTimeFormatter.ISO_DATE_TIME) + ".000000000";
                updateDatesPreparedStatement.setString(1, newDate);
                updateDatesPreparedStatement.setString(2, kudoID);
                updatedRows += updateDatesPreparedStatement.executeUpdate();
            }
            UrbanceDebug.sendInfo("updatedRows: " + updatedRows);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean createPlayersTable() {
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("CREATE TABLE IF NOT EXISTS players (UUID VARCHAR(100) NOT NULL, DisplayName VARCHAR(100) NOT NULL, PRIMARY KEY (UUID))");){
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private boolean createKudosTable() {
        String createTableStatement = "CREATE TABLE IF NOT EXISTS kudos (KudoID INT PRIMARY KEY AUTO_INCREMENT, AwardedToPlayer VARCHAR(100) NOT NULL, ReceivedFromPlayer VARCHAR(100) NOT NULL, Reason VARCHAR(100), Date VARCHAR(100) NOT NULL)";
        if (driverClassName.equals("org.sqlite.JDBC")) {
            createTableStatement = createTableStatement.replace("AUTO_INCREMENT", "AUTOINCREMENT");
            createTableStatement = createTableStatement.replace("INT", "INTEGER");
        }
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(createTableStatement);){
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean updatePlayer(UUID uuid) {
        if (!this.columnExists("players", "DisplayName")) {
            this.addColumn("players", "DisplayName", "VARCHAR(100)", "undefined", true);
        }
        if (this.exists(uuid)) {
            return this.updateDisplayName(uuid);
        }
        return this.createPlayer(uuid);
    }

    private boolean createPlayer(UUID uuid) {
        String displayName = "";
        displayName = Bukkit.getPlayer((UUID)uuid) != null ? Bukkit.getPlayer((UUID)uuid).getName() : Bukkit.getOfflinePlayer((UUID)uuid).getName();
        if (!this.columnExists("players", "DisplayName")) {
            this.addColumn("players", "DisplayName", "VARCHAR(100)", "undefined", true);
        }
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO players (UUID, DisplayName) VALUES (?,?)");){
            if (!this.exists(uuid)) {
                preparedStatement.setString(1, uuid.toString());
                preparedStatement.setString(2, displayName);
                preparedStatement.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return this.exists(uuid) && this.getPlayerDisplayName(String.valueOf(uuid)).equals(displayName);
    }

    private boolean updateDisplayName(UUID uuid) {
        if (!this.columnExists("players", "DisplayName")) {
            this.addColumn("players", "DisplayName", "VARCHAR(100)", "undefined", true);
        }
        String displayName = uuid.toString();
        try {
            if (Bukkit.getOfflinePlayer((UUID)uuid).hasPlayedBefore()) {
                displayName = Bukkit.getOfflinePlayer((UUID)uuid).getName();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        if (!this.exists(uuid)) {
            return this.createPlayer(uuid);
        }
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("UPDATE players SET DisplayName=? WHERE UUID=?");){
            preparedStatement.setString(1, displayName);
            preparedStatement.setString(2, uuid.toString());
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String databasePlayerDisplayName = this.getPlayerDisplayName(uuid.toString());
        if (databasePlayerDisplayName.equals(displayName)) {
            return true;
        }
        Bukkit.getLogger().warning("Something went wrong during updating the display name. Please contact the plugin developer.");
        Bukkit.getLogger().warning("displayName: " + displayName);
        Bukkit.getLogger().warning("databasePlayerDisplayName: " + databasePlayerDisplayName);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UUID getPlayerByDisplayName(String displayName) {
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT UUID FROM players WHERE DisplayName=?");){
            preparedStatement.setString(1, displayName);
            ResultSet results = preparedStatement.executeQuery();
            if (!results.next()) return null;
            UUID uUID = UUID.fromString(results.getString("UUID"));
            return uUID;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getPlayerDisplayName(String uuid) {
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT DisplayName FROM players WHERE UUID=?");){
            preparedStatement.setString(1, uuid);
            ResultSet results = preparedStatement.executeQuery();
            if (!results.next()) return "undefined";
            String string = results.getString("DisplayName");
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return "undefined";
    }

    private boolean addColumn(String table, String columnName, String datatype, String defaultValue, boolean setNotNull) {
        String statement = "";
        String parameterSetNotNull = "NOT NULL";
        Object parameterDefaultValue = "DEFAULT \"" + defaultValue + "\"";
        if (!setNotNull) {
            parameterSetNotNull = "";
        }
        if (defaultValue.isBlank()) {
            parameterDefaultValue = "";
        }
        statement = String.format("ALTER TABLE %s ADD COLUMN %s %s %s %s", table, columnName, datatype, parameterSetNotNull, parameterDefaultValue);
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(statement);){
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        ArrayList<String> playerUUIDS = new ArrayList<String>();
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT AwardedToPlayer FROM kudos GROUP BY AwardedToPlayer ORDER BY COUNT(KudoID) DESC LIMIT 10");){
            ResultSet results = preparedStatement.executeQuery();
            while (results.next()) {
                playerUUIDS.add(results.getString("AwardedToPlayer"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        for (String uuid : playerUUIDS) {
            this.updateDisplayName(UUID.fromString(uuid));
        }
        return this.columnExists("players", columnName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean columnExists(String tableName, String columnName) {
        String statement = "";
        if (driverClassName.equals("org.sqlite.JDBC")) {
            statement = String.format("PRAGMA table_info(%s)", tableName);
            try (Connection connection = SQL.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(statement);){
                String resultColumnName;
                ResultSet results = preparedStatement.executeQuery();
                do {
                    if (!results.next()) return false;
                } while (!Objects.equals(resultColumnName = results.getString("name"), columnName));
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }
        statement = String.format("SELECT COUNT(*) FROM information_schema.columns WHERE table_name = '%s' AND column_name = '%s';", tableName, columnName);
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(statement);){
            ResultSet results = preparedStatement.executeQuery();
            if (!results.next()) return false;
            boolean bl = results.getInt("COUNT(*)") == 1;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLastKudoAwardedDateFromPlayer(UUID uuid) {
        if (!this.exists(uuid)) {
            UrbanceDebug.sendInfo("Player with UUID " + String.valueOf(uuid) + " not found in players table");
            return null;
        }
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT Date FROM `kudos` WHERE ReceivedFromPlayer=? ORDER BY Date DESC LIMIT 1;");){
            preparedStatement.setString(1, uuid.toString());
            ResultSet results = preparedStatement.executeQuery();
            if (!results.next()) return null;
            String string = results.getString("Date");
            return string;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean exists(UUID uuid) {
        try (Connection connection = SQL.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM players WHERE UUID=?");
                try {
                    preparedStatement.setString(1, uuid.toString());
                    ResultSet results = preparedStatement.executeQuery();
                    bl = results.next();
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean existsByDisplayName(String displayName) {
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM players WHERE DisplayName=?");){
            preparedStatement.setString(1, displayName);
            ResultSet results = preparedStatement.executeQuery();
            if (results.next()) {
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (!Bukkit.getOfflinePlayer((String)displayName).hasPlayedBefore()) return false;
        UUID uuid = Bukkit.getOfflinePlayer((String)displayName).getUniqueId();
        this.updatePlayer(uuid);
        return this.existsByDisplayName(displayName);
    }

    public boolean addKudos(UUID awardedToPlayer, String receivedFromPlayer, String reason, int amount) {
        int affectedRows = 0;
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO kudos (AwardedToPlayer, ReceivedFromPlayer, Reason, Date) VALUES (?,?,?,?);");){
            for (int counter = 1; counter <= amount; ++counter) {
                preparedStatement.setString(1, String.valueOf(awardedToPlayer));
                preparedStatement.setString(2, receivedFromPlayer);
                preparedStatement.setString(3, reason);
                preparedStatement.setString(4, LocalDateTime.now().toString());
                affectedRows = preparedStatement.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return affectedRows > 0;
    }

    public boolean removeKudo(int kudosID) {
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM kudos WHERE KudoID=?");){
            preparedStatement.setInt(1, kudosID);
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean clearKudos(UUID uuid) {
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM kudos WHERE AwardedToPlayer=?");){
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean clearAssignedKudos(UUID uuid) {
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM kudos WHERE ReceivedFromPlayer=?");){
            preparedStatement.setString(1, uuid.toString());
            preparedStatement.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean clearKudosAndAssignedKudos(UUID uuid) {
        return this.clearAssignedKudos(uuid) && this.clearKudos(uuid);
    }

    public List<String> getAllPlayerKudos(UUID uuid) {
        ArrayList<String> kudos = new ArrayList<String>();
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM `kudos` WHERE AwardedToPlayer=?;");){
            preparedStatement.setString(1, uuid.toString());
            ResultSet results = preparedStatement.executeQuery();
            while (results.next()) {
                String entryNumber = results.getString("KudoID");
                String receivedFromPlayer = this.getPlayerDisplayName(results.getString("ReceivedFromPlayer"));
                String reason = results.getString("Reason");
                String date = results.getString("Date");
                LocalDateTime formattedDate = LocalDateTime.parse(date);
                date = formattedDate.format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"));
                if (reason == null) {
                    reason = this.config.getString("kudo-award.general-settings.no-reason-given");
                }
                if (receivedFromPlayer.equals(consoleCommandSenderPrefix)) {
                    receivedFromPlayer = receivedFromPlayer.replace(consoleCommandSenderPrefix, this.config.getString("general-settings.console-name"));
                }
                kudos.add(String.format("&eID&7: %s | &efrom &7%s | &eat&7 %s \n&eReason: &7%s", entryNumber, receivedFromPlayer, date, reason));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return kudos;
    }

    public HashMap<Integer, String> getPlayerReceivedKudosGUI(UUID uuid) {
        HashMap<Integer, String> receivedKudos = new HashMap<Integer, String>();
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM `kudos` WHERE AwardedToPlayer=? ORDER BY KudoID DESC;");){
            preparedStatement.setString(1, uuid.toString());
            ResultSet results = preparedStatement.executeQuery();
            int entryNumber = 0;
            while (results.next()) {
                String receivedFromPlayer = this.getPlayerDisplayName(results.getString("ReceivedFromPlayer"));
                String reason = results.getString("Reason");
                String date = results.getString("Date");
                if (reason == null) {
                    reason = this.config.getString("kudo-award.general-settings.no-reason-given");
                }
                receivedKudos.put(entryNumber, receivedFromPlayer + "@" + reason + "@" + date);
                ++entryNumber;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return receivedKudos;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getPlayerKudo(int requestedKudosID) {
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT KudoID FROM kudos WHERE KudoID=?;");){
            preparedStatement.setInt(1, requestedKudosID);
            ResultSet results = preparedStatement.executeQuery();
            if (!results.next()) return 0;
            int n = results.getInt("KudoID");
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return 0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int getAmountKudos(UUID uuid) {
        try (Connection connection = SQL.getConnection();){
            int n;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(AwardedToPlayer) FROM kudos WHERE AwardedToPlayer=?");
                try {
                    preparedStatement.setString(1, uuid.toString());
                    ResultSet results = preparedStatement.executeQuery();
                    results.next();
                    n = results.getInt("COUNT(AwardedToPlayer)");
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getTotalAwardedKudos(UUID uuid) {
        if (!this.exists(uuid)) {
            UrbanceDebug.sendInfo("Player with UUID " + String.valueOf(uuid) + " not found in players table");
            return -1;
        }
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(ReceivedFromPlayer) FROM kudos WHERE ReceivedFromPlayer=?");){
            preparedStatement.setString(1, uuid.toString());
            ResultSet results = preparedStatement.executeQuery();
            if (!results.next()) return -1;
            int n = results.getInt("COUNT(ReceivedFromPlayer)");
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return -1;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public int getAssignedKudos(UUID uuid) {
        try (Connection connection = SQL.getConnection();){
            int n;
            block14: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT COUNT(ReceivedFromPlayer) FROM kudos WHERE ReceivedFromPlayer=?");
                try {
                    preparedStatement.setString(1, uuid.toString());
                    ResultSet results = preparedStatement.executeQuery();
                    results.next();
                    n = results.getInt("COUNT(ReceivedFromPlayer)");
                    if (preparedStatement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return n;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public List<String> getTopPlayersKudosTemp() {
        try (Connection connection = SQL.getConnection();){
            List<String> list;
            block16: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT AwardedToPlayer, COUNT(KudoID) FROM kudos GROUP BY AwardedToPlayer ORDER BY COUNT(KudoID) DESC LIMIT 3");
                try {
                    int amountDisplayPlayers = ConfigManagement.getGlobalGuiSettingsConfig().getInt("placeholderapi-settings.items.kudos-leaderboard.display-players");
                    if (amountDisplayPlayers > 15) {
                        amountDisplayPlayers = 15;
                    }
                    int counter = 0;
                    ResultSet results = preparedStatement.executeQuery();
                    List<String> itemLore = this.prepareTopPlayersKudosList(amountDisplayPlayers);
                    while (results.next()) {
                        UUID uuid = UUID.fromString(results.getString("AwardedToPlayer"));
                        String playerName = this.getPlayerDisplayName(String.valueOf(uuid));
                        String kudos = results.getString("COUNT(KudoID)");
                        String loreEntry = itemLore.get(counter);
                        loreEntry = loreEntry.replaceAll("%top_kudos%", kudos);
                        loreEntry = loreEntry.replaceAll("%top_player%", playerName);
                        itemLore.set(counter, loreEntry);
                        ++counter;
                    }
                    list = this.setNotAssignedKudosText(itemLore);
                    if (preparedStatement == null) break block16;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return list;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return Collections.emptyList();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public HashMap<UUID, Integer> getTopPlayersKudos(int amountPlayers) {
        HashMap<UUID, Integer> playerKudos = new HashMap<UUID, Integer>();
        try (Connection connection = SQL.getConnection();){
            HashMap<UUID, Integer> hashMap;
            block15: {
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT AwardedToPlayer, COUNT(KudoID) FROM kudos GROUP BY AwardedToPlayer ORDER BY COUNT(KudoID) DESC LIMIT " + amountPlayers);
                try {
                    ResultSet results = preparedStatement.executeQuery();
                    while (results.next()) {
                        UUID uuid = UUID.fromString(results.getString("AwardedToPlayer"));
                        int kudos = results.getInt("COUNT(KudoID)");
                        playerKudos.put(uuid, kudos);
                    }
                    hashMap = playerKudos;
                    if (preparedStatement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                preparedStatement.close();
            }
            return hashMap;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return playerKudos;
        }
    }

    private List<String> prepareTopPlayersKudosList(int amountDisplayPlayers) {
        ArrayList<String> list = new ArrayList<String>();
        String loreFormat = ConfigManagement.getGlobalGuiSettingsConfig().getString("placeholderapi-settings.items.kudos-leaderboard.item-lore-format");
        for (int entry = 0; entry < amountDisplayPlayers; ++entry) {
            list.add(loreFormat);
        }
        return list;
    }

    private List<String> setNotAssignedKudosText(List<String> lore) {
        for (int entry = 0; entry < lore.size(); ++entry) {
            if (!lore.get(entry).contains("%top_kudos%") && !lore.get(entry).contains("%top_player%")) continue;
            lore.set(entry, ChatColor.translateAlternateColorCodes((char)'&', (String)ConfigManagement.getGlobalGuiSettingsConfig().getString("placeholderapi-settings.items.kudos-leaderboard.item-lore-not-assigned-kudos")));
        }
        return lore;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkIfKudosTableHasOldTableSchematic() {
        String statement = "SELECT COUNT(*) AS ENTRIES FROM pragma_table_info('kudos') WHERE name='Kudos' or name='Assigned'";
        boolean useMySQL = this.config.getBoolean("general-settings.use-MySQL");
        if (this.config.isConfigurationSection("general")) {
            useMySQL = this.config.getBoolean("general.use-SQL");
        }
        if (useMySQL) {
            new ConfigManagement("mysql.yml", this.plugin);
            FileConfiguration mysqlConfig = ConfigManagement.getMySQLConfig();
            String databaseName = mysqlConfig.getString("database");
            statement = "SELECT COUNT(*) AS ENTRIES FROM information_schema.columns\nWHERE TABLE_SCHEMA='%s'\nAND TABLE_NAME='kudos'\nAND COLUMN_NAME='UUID'\nOR TABLE_SCHEMA='%s'\nAND TABLE_NAME='kudos'\nAND COLUMN_NAME='Kudos';".replace("%s", databaseName);
            try (Connection connection = SQL.getConnection();
                 PreparedStatement preparedStatement = connection.prepareStatement(statement);){
                int result;
                ResultSet results = preparedStatement.executeQuery();
                do {
                    if (!results.next()) return false;
                } while ((result = results.getInt("ENTRIES")) <= 0);
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return false;
            }
        }
        try (Connection connection = SQL.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement(statement);){
            int result;
            ResultSet results = preparedStatement.executeQuery();
            do {
                if (!results.next()) return false;
            } while ((result = results.getInt("ENTRIES")) <= 0);
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean migrateOldTableSchemeToNewTableScheme() {
        PreparedStatement preparedStatement;
        Connection connection;
        HashMap<UUID, Integer> oldKudosTablePlayerData = new HashMap<UUID, Integer>();
        try {
            connection = SQL.getConnection();
            try {
                preparedStatement = connection.prepareStatement("SELECT UUID, Kudos FROM kudos;");
                try {
                    ResultSet results = preparedStatement.executeQuery();
                    while (results.next()) {
                        UUID uuid = UUID.fromString(results.getString("UUID"));
                        int totalKudos = results.getInt("Kudos");
                        oldKudosTablePlayerData.put(uuid, totalKudos);
                    }
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        try {
            connection = SQL.getConnection();
            try {
                preparedStatement = connection.prepareStatement("DROP TABLE kudos");
                try {
                    preparedStatement.execute();
                }
                finally {
                    if (preparedStatement != null) {
                        preparedStatement.close();
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
        if (!this.initTables()) {
            return false;
        }
        for (Map.Entry entry : oldKudosTablePlayerData.entrySet()) {
            UUID uuid = (UUID)entry.getKey();
            int totalKudos = (Integer)entry.getValue();
            this.createPlayer(uuid);
            this.addKudos(uuid, consoleCommandSenderPrefix, null, totalKudos);
        }
        return true;
    }

    static {
        consoleCommandSenderPrefix = "%ConsoleCommandSender%";
    }
}

