/*
 * Decompiled with CFR 0.152.
 */
package Utils;

import Utils.ConfigManagement;
import Utils.KudosUtils.KudosMessage;
import Utils.SQL.SQLGetter;
import de.urbance.Main;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class WorkaroundManagement {
    public static boolean isConfigMigrationNeeded = false;
    public static boolean isSQLMigrationNeeded = false;
    public static boolean isLegacyConfig = false;
    private Main plugin = (Main)Main.getPlugin(Main.class);
    private Path guiConfigPath = Path.of(String.valueOf(this.plugin.getDataFolder()) + File.separator + "gui.yml", new String[0]);

    public void performMigrationCheck() {
        if (this.isConfigOlderThanMajorVersion400()) {
            isLegacyConfig = true;
            return;
        }
        if (this.checkSQLMigration()) {
            isSQLMigrationNeeded = true;
        }
        if (this.check430Workaround() || this.check500Workaround()) {
            isConfigMigrationNeeded = true;
        }
    }

    public void performConfigMigration() {
        if (isConfigMigrationNeeded) {
            this.perform430Workaround();
            this.perform500Workaround();
            isConfigMigrationNeeded = false;
        }
    }

    public boolean performSQLMigration() {
        SQLGetter data;
        if (isSQLMigrationNeeded && (data = new SQLGetter(this.plugin)).migrateOldTableSchemeToNewTableScheme()) {
            return !data.checkIfKudosTableHasOldTableSchematic();
        }
        return false;
    }

    private boolean isConfigOlderThanMajorVersion400() {
        if (!Files.exists(this.guiConfigPath, new LinkOption[0])) {
            return false;
        }
        ConfigManagement guiConfigFileManager = new ConfigManagement("gui.yml", this.plugin);
        FileConfiguration guiConfig = guiConfigFileManager.getFileConfiguration();
        guiConfig.options().copyDefaults(true);
        return guiConfig.getString("title") != null && guiConfig.getString("enabled") != null && guiConfig.isConfigurationSection("slot.top3");
    }

    private boolean checkSQLMigration() {
        SQLGetter data = new SQLGetter(this.plugin);
        isSQLMigrationNeeded = data.checkIfKudosTableHasOldTableSchematic();
        return isSQLMigrationNeeded;
    }

    private boolean check500Workaround() {
        if (!Files.exists(this.guiConfigPath, new LinkOption[0])) {
            return false;
        }
        ConfigManagement guiConfigFileManager = new ConfigManagement("gui.yml", this.plugin);
        FileConfiguration guiConfig = guiConfigFileManager.getFileConfiguration();
        guiConfig.options().copyDefaults(true);
        ConfigManagement configFileManager = new ConfigManagement("config.yml", this.plugin);
        FileConfiguration config = configFileManager.getFileConfiguration();
        config.options().copyDefaults(true);
        return guiConfigFileManager.file.exists() || guiConfig.isConfigurationSection("general") || guiConfig.isConfigurationSection("slot") || config.isConfigurationSection("general");
    }

    private void perform500Workaround() {
        if (!this.check500Workaround()) {
            return;
        }
        if (!Files.exists(this.guiConfigPath, new LinkOption[0])) {
            return;
        }
        ConfigManagement configFileManager = new ConfigManagement("config.yml", this.plugin);
        FileConfiguration config = configFileManager.getFileConfiguration();
        config.options().copyDefaults(true);
        ConfigManagement guiConfigFileManager = new ConfigManagement("gui.yml", this.plugin);
        FileConfiguration guiConfig = guiConfigFileManager.getFileConfiguration();
        guiConfig.options().copyDefaults(true);
        ConfigManagement globalGuiSettingsConfigManager = new ConfigManagement("global-gui-settings.yml", this.plugin);
        FileConfiguration globalGuiSettingsConfig = globalGuiSettingsConfigManager.getFileConfiguration();
        globalGuiSettingsConfig.options().copyDefaults(true);
        ConfigManagement leaderboardGuiConfigManager = new ConfigManagement("leaderboard.yml", this.plugin);
        FileConfiguration leaderboardGuiConfig = leaderboardGuiConfigManager.getFileConfiguration();
        leaderboardGuiConfig.options().copyDefaults(true);
        ConfigManagement overviewGuiConfigManager = new ConfigManagement("overview.yml", this.plugin);
        FileConfiguration overviewGuiConfig = overviewGuiConfigManager.getFileConfiguration();
        overviewGuiConfig.options().copyDefaults(true);
        configFileManager.createBackup();
        guiConfigFileManager.createBackup();
        if (!guiConfig.isConfigurationSection("slot.received-kudos")) {
            guiConfig.set("slot.statistics.item-slot", overviewGuiConfig.get("items.statistics.item-slot"));
            guiConfig.set("slot.received-kudos.item-slot", overviewGuiConfig.get("items.received-kudos.item-slot"));
            guiConfig.set("slot.help.item-slot", overviewGuiConfig.get("items.help.item-slot"));
            guiConfig.set("slot.kudos-leaderboard.item-slot", overviewGuiConfig.get("items.kudos-leaderboard.item-slot"));
            guiConfigFileManager.save();
        }
        HashMap<String, String> configGeneralSectionKeyMap = new HashMap<String, String>();
        configGeneralSectionKeyMap.put("general.update-notification", "general-settings.update-notification");
        configGeneralSectionKeyMap.put("general.prefix", "general-settings.prefix");
        configGeneralSectionKeyMap.put("general.use-SQL", "general-settings.use-MySQL");
        configGeneralSectionKeyMap.put("general.console-name", "general-settings.console-name");
        ConfigManagement.copyConfigValuesBetweenTwoConfigs(configGeneralSectionKeyMap, config, config);
        HashMap<String, String> configKudoAwardSectionKeyMap = new HashMap<String, String>();
        configKudoAwardSectionKeyMap.put("kudo-award.cooldown", "kudo-award.general-settings.cooldown");
        configKudoAwardSectionKeyMap.put("kudo-award.enable-reasons", "kudo-award.general-settings.enable-reasons");
        configKudoAwardSectionKeyMap.put("kudo-award.no-reason-given", "kudo-award.general-settings.no-reason-given");
        configKudoAwardSectionKeyMap.put("kudo-award.reason-length", "kudo-award.general-settings.reason-length");
        ConfigManagement.copyConfigValuesBetweenTwoConfigs(configKudoAwardSectionKeyMap, config, config);
        HashMap<String, String> guiConfigGlobalGuiSettingsKeyMap = new HashMap<String, String>();
        guiConfigGlobalGuiSettingsKeyMap.put("general.title", "general-settings.gui-title");
        guiConfigGlobalGuiSettingsKeyMap.put("general.page-switcher.backwards.item-name", "page-switcher.direction.backwards.item-name");
        guiConfigGlobalGuiSettingsKeyMap.put("general.page-switcher.forwards.item-name", "page-switcher.direction.forwards.item-name");
        guiConfigGlobalGuiSettingsKeyMap.put("general.page-switcher.playsound.enabled", "page-switcher.playsound.enabled");
        guiConfigGlobalGuiSettingsKeyMap.put("general.page-switcher.playsound.playsound-type", "page-switcher.playsound.playsound-type");
        ConfigManagement.copyConfigValuesBetweenTwoConfigs(guiConfigGlobalGuiSettingsKeyMap, guiConfig, globalGuiSettingsConfig);
        HashMap<String, String> guiConfigLeaderboardKeyMap = new HashMap<String, String>();
        guiConfigLeaderboardKeyMap.put("leaderboard.player-leaderboard-item.item-name", "items.player-leaderboard-item.item-name");
        guiConfigLeaderboardKeyMap.put("leaderboard.player-leaderboard-item.lore", "items.player-leaderboard-item.item-lore");
        ConfigManagement.copyConfigValuesBetweenTwoConfigs(guiConfigLeaderboardKeyMap, guiConfig, leaderboardGuiConfig);
        HashMap<String, String> guiConfigOverviewKeyMap = new HashMap<String, String>();
        guiConfigOverviewKeyMap.put("general.enabled", "general-settings.enabled");
        guiConfigOverviewKeyMap.put("general.rows", "general-settings.rows");
        ConfigManagement.copyConfigValuesBetweenTwoConfigs(guiConfigOverviewKeyMap, guiConfig, overviewGuiConfig);
        HashMap<String, String> guiConfigStatisticsKeyMap = new HashMap<String, String>();
        guiConfigStatisticsKeyMap.put("slot.statistics.enabled", "items.statistics.enabled");
        guiConfigStatisticsKeyMap.put("slot.statistics.item", "items.statistics.item");
        guiConfigStatisticsKeyMap.put("slot.statistics.item-name", "items.statistics.item-name");
        guiConfigStatisticsKeyMap.put("slot.statistics.item-slot", "items.statistics.item-slot");
        guiConfigStatisticsKeyMap.put("slot.statistics.lore", "items.statistics.item-lore");
        ConfigManagement.copyConfigValuesBetweenTwoConfigs(guiConfigStatisticsKeyMap, guiConfig, overviewGuiConfig);
        HashMap<String, String> guiConfigReceivedKudosKeyMap = new HashMap<String, String>();
        guiConfigReceivedKudosKeyMap.put("slot.received-kudos.enabled", "items.received-kudos.enabled");
        guiConfigReceivedKudosKeyMap.put("slot.received-kudos.item", "items.received-kudos.item");
        guiConfigReceivedKudosKeyMap.put("slot.received-kudos.item-name", "items.received-kudos.item-name");
        guiConfigReceivedKudosKeyMap.put("slot.received-kudos.item-slot", "items.received-kudos.item-slot");
        guiConfigReceivedKudosKeyMap.put("slot.received-kudos.lore", "items.received-kudos.item-lore");
        guiConfigReceivedKudosKeyMap.put("slot.received-kudos.lore-no-received-kudos", "items.received-kudos.item-lore-no-received-kudos");
        ConfigManagement.copyConfigValuesBetweenTwoConfigs(guiConfigReceivedKudosKeyMap, guiConfig, overviewGuiConfig);
        HashMap<String, String> guiConfigHelpKeyMap = new HashMap<String, String>();
        guiConfigHelpKeyMap.put("slot.help.enabled", "items.help.enabled");
        guiConfigHelpKeyMap.put("slot.help.item", "items.help.item");
        guiConfigHelpKeyMap.put("slot.help.item-name", "items.help.item-name");
        guiConfigHelpKeyMap.put("slot.help.item-slot", "items.help.item-slot");
        guiConfigHelpKeyMap.put("slot.help.lore", "items.help.item-lore");
        ConfigManagement.copyConfigValuesBetweenTwoConfigs(guiConfigHelpKeyMap, guiConfig, overviewGuiConfig);
        HashMap<String, String> guiConfigKudosLeaderboardKeyMap = new HashMap<String, String>();
        guiConfigKudosLeaderboardKeyMap.put("slot.kudos-leaderboard.enabled", "items.kudos-leaderboard.enabled");
        guiConfigKudosLeaderboardKeyMap.put("slot.kudos-leaderboard.item", "items.kudos-leaderboard.item");
        guiConfigKudosLeaderboardKeyMap.put("slot.kudos-leaderboard.item-name", "items.kudos-leaderboard.item-name");
        guiConfigKudosLeaderboardKeyMap.put("slot.kudos-leaderboard.item-slot", "items.kudos-leaderboard.item-slot");
        guiConfigKudosLeaderboardKeyMap.put("slot.kudos-leaderboard.lore", "items.kudos-leaderboard.item-lore");
        guiConfigKudosLeaderboardKeyMap.put("slot.kudos-leaderboard.lore-no-kudos-exists", "items.kudos-leaderboard.item-lore-no-kudos-exists");
        ConfigManagement.copyConfigValuesBetweenTwoConfigs(guiConfigKudosLeaderboardKeyMap, guiConfig, overviewGuiConfig);
        HashMap<String, String> configPlaysoundKeyMap = new HashMap<String, String>();
        configPlaysoundKeyMap.put("kudo-award.milestones.enable-playsound", "kudo-award.milestones.playsound.enabled");
        configPlaysoundKeyMap.put("kudo-award.milestones.playsound-type", "kudo-award.milestones.playsound.playsound-type");
        ConfigManagement.copyConfigValuesBetweenTwoConfigs(configPlaysoundKeyMap, config, config);
        config.set("general", null);
        config.set("kudo-award.cooldown", null);
        config.set("kudo-award.enable-reasons", null);
        config.set("kudo-award.reason-length", null);
        config.set("kudo-award.no-reason-given", null);
        config.set("kudo-award.milestones.playsound.playsound-type", null);
        config.set("kudo-award.milestones.enable-playsound", null);
        config.set("kudo-award.milestones.playsound-type", null);
        configFileManager.save();
        globalGuiSettingsConfigManager.save();
        guiConfigFileManager.save();
        leaderboardGuiConfigManager.save();
        overviewGuiConfigManager.save();
        if (!guiConfigFileManager.deleteConfigFile()) {
            Bukkit.getLogger().warning("Can't delete gui.yml. Consider to delete the config file manually.");
        }
    }

    private boolean check430Workaround() {
        if (!Files.exists(this.guiConfigPath, new LinkOption[0])) {
            return false;
        }
        ConfigManagement guiConfigFileManager = new ConfigManagement("gui.yml", this.plugin);
        FileConfiguration guiConfig = guiConfigFileManager.getFileConfiguration();
        return guiConfig.getString("received-kudos.backwards-item.item-name") != null || guiConfig.getString("slot.kudos-leaderboard.not-assigned-kudos") != null;
    }

    private void perform430Workaround() {
        if (!this.check430Workaround()) {
            return;
        }
        ConfigManagement guiConfigFileManager = new ConfigManagement("gui.yml", this.plugin);
        FileConfiguration guiConfig = guiConfigFileManager.getFileConfiguration();
        String receivedKudosBackwardsItemNameKeyPath = "received-kudos.backwards-item.item-name";
        String receivedKudosForwardsItemNameKeyPath = "received-kudos.forwards-item.item-name";
        String generalPageSwitcherBackwardsItemNameKeyPath = "general.page-switcher.backwards.item-name";
        String generalPageSwitcherForwardsItemNameKeyPath = "general.page-switcher.forwards.item-name";
        if (guiConfig.getString(receivedKudosBackwardsItemNameKeyPath) != null) {
            guiConfig.set(generalPageSwitcherBackwardsItemNameKeyPath, (Object)guiConfig.getString(receivedKudosBackwardsItemNameKeyPath));
            guiConfig.set("received-kudos.backwards-item", null);
        }
        if (guiConfig.getString(receivedKudosForwardsItemNameKeyPath) != null) {
            guiConfig.set(generalPageSwitcherForwardsItemNameKeyPath, (Object)guiConfig.getString(receivedKudosForwardsItemNameKeyPath));
            guiConfig.set("received-kudos.forwards-item", null);
        }
        String oldNotAssignedKudosPapiKeyPath = "slot.kudos-leaderboard.not-assigned-kudos";
        String oldLoreFormatPapiKeyPath = "slot.kudos-leaderboard.lore-format";
        if (guiConfig.getString(oldNotAssignedKudosPapiKeyPath) != null) {
            String oldNotAssignedKudosPapiKeyValue = guiConfig.getString(oldNotAssignedKudosPapiKeyPath);
            String newNotAssignedKudosPapiPath = "slot.kudos-leaderboard.papi.not-assigned-kudos";
            guiConfig.set(newNotAssignedKudosPapiPath, (Object)oldNotAssignedKudosPapiKeyValue);
            guiConfig.set(oldNotAssignedKudosPapiKeyPath, null);
        }
        if (guiConfig.getString(oldLoreFormatPapiKeyPath) != null) {
            String oldLoreFormatPapiKeyValue = guiConfig.getString("slot.kudos-leaderboard.lore-format");
            String newLoreFormatPapiKeyPath = "slot.kudos-leaderboard.papi.lore-format";
            guiConfig.set(newLoreFormatPapiKeyPath, (Object)oldLoreFormatPapiKeyValue);
            guiConfig.set(oldLoreFormatPapiKeyPath, null);
        }
        guiConfigFileManager.save();
    }

    private static String getConfigWorkaroundNeededMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&7========= &e&lKudos&r &7=========\n");
        stringBuilder.append("\n&7It seems you already had an older version of Kudos installed.");
        stringBuilder.append("\n ");
        stringBuilder.append("\nThere have been critical changes to the plugin. Please execute the command &e/kudmin migration &7to continue using Kudos.");
        stringBuilder.append("\n ");
        stringBuilder.append("\nData loss may occur. A backup of the database and configuration files is recommended.");
        stringBuilder.append("\n&7========= &e&lKudos&r &7=========\n");
        return stringBuilder.toString();
    }

    private static String getSQLWorkaroundMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&7========= &e&lKudos&r &7=========\n");
        stringBuilder.append("\n&7It seems you already had an older version of Kudos installed.");
        stringBuilder.append("\n ");
        stringBuilder.append("\nThere have been critical changes to the plugin. Please execute the command &e/kudmin migration &7to continue using Kudos.");
        stringBuilder.append("\n ");
        stringBuilder.append("\nThe statistics on the awarded Kudos will be reset after the migration!");
        stringBuilder.append("\n ");
        stringBuilder.append("\n&7Data loss may occur. A backup of the database is recommended to avoid data loss.");
        stringBuilder.append("\n&7========= &e&lKudos&r &7=========\n");
        return stringBuilder.toString();
    }

    private static String getSQLAndConfigWorkaroundMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&7========= &e&lKudos&r &7=========\n");
        stringBuilder.append("\n&7It seems you already had an older version of Kudos installed.");
        stringBuilder.append("\n ");
        stringBuilder.append("\nThere have been critical changes to the plugin. Please execute the command &e/kudmin migration &7to continue using Kudos.");
        stringBuilder.append("\n ");
        stringBuilder.append("\nThe statistics on the awarded Kudos will be reset after the migration!");
        stringBuilder.append("\n ");
        stringBuilder.append("\nData loss may occur. A backup of the database and configuration files is recommended.");
        stringBuilder.append("\n&7========= &e&lKudos&r &7=========\n");
        return stringBuilder.toString();
    }

    private static String getWorkaroundNeededMessage() {
        String message = "";
        if (isConfigMigrationNeeded && isSQLMigrationNeeded) {
            message = WorkaroundManagement.getSQLAndConfigWorkaroundMessage();
        } else if (isConfigMigrationNeeded) {
            message = WorkaroundManagement.getConfigWorkaroundNeededMessage();
        } else if (isSQLMigrationNeeded) {
            message = WorkaroundManagement.getSQLWorkaroundMessage();
        }
        return message;
    }

    private static String getLegacyConfigMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("&7========= &e&lKudos&r &7=========\n");
        stringBuilder.append("\n&7You were using a very old version of Kudos and a lot has changed since then.");
        stringBuilder.append("\n ");
        stringBuilder.append("\nTo continue, stop the server, delete &econfig.yml &7and &egui.yml &7in the Kudos plugins folder and restart the server.");
        stringBuilder.append("\n ");
        stringBuilder.append("\nYou will then be prompted to execute a command to update the database to the correct version.");
        stringBuilder.append("\n&7========= &e&lKudos&r &7=========\n");
        return stringBuilder.toString();
    }

    public static void notifyInstanceAboutWorkaround(CommandSender sender) {
        String message = WorkaroundManagement.getWorkaroundNeededMessage();
        if (message.isBlank()) {
            return;
        }
        if (sender instanceof ConsoleCommandSender) {
            sender.sendMessage(KudosMessage.formatStringForConsole(message));
        }
        if (sender instanceof Player && sender.hasPermission("kudos.admin.*")) {
            if (!sender.hasPermission("kudos.admin.*")) {
                return;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }

    public static void notifyInstanceAboutWorkaroundAtPluginStartup() {
        String message = WorkaroundManagement.getWorkaroundNeededMessage();
        if (message.isBlank()) {
            return;
        }
        Bukkit.getLogger().warning(KudosMessage.formatStringForConsole(message));
        for (Player players : Bukkit.getOnlinePlayers()) {
            if (!players.hasPermission("kudos.admin.*")) continue;
            players.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }

    public static void notifyInstanceAboutLegacyWorkaround(CommandSender sender) {
        String message = WorkaroundManagement.getLegacyConfigMessage();
        if (sender instanceof ConsoleCommandSender) {
            sender.sendMessage(KudosMessage.formatStringForConsole(message));
        }
        if (sender instanceof Player && sender.hasPermission("kudos.admin.*")) {
            if (!sender.hasPermission("kudos.admin.*")) {
                return;
            }
            sender.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }

    public static void notifyInstanceAboutLegacyConfigAtPluginStartup() {
        String message = WorkaroundManagement.getLegacyConfigMessage();
        Bukkit.getLogger().warning(KudosMessage.formatStringForConsole(message));
        for (Player players : Bukkit.getOnlinePlayers()) {
            if (!players.hasPermission("kudos.admin.*")) continue;
            players.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)message));
        }
    }
}

