/*
 * Decompiled with CFR 0.152.
 */
package de.urbance;

import Commands.Kudmin;
import Commands.Kudo;
import Commands.Kudos;
import Events.OnPlayerJoin;
import GUI.OverviewGUI;
import GUI.ReceivedKudosGUI;
import Utils.ConfigManagement;
import Utils.KudosUtils.KudosExpansion;
import Utils.SQL.SQL;
import Utils.SQL.SQLGetter;
import Utils.UpdateChecker;
import Utils.WorkaroundManagement;
import de.urbance.shaded.bstats.bukkit.Metrics;
import java.sql.SQLException;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.util.Consumer;

public class Main
extends JavaPlugin
implements Listener {
    public static boolean oldTableScheme;
    public String prefix;
    public SQL SQL;
    public FileConfiguration config;
    public SQLGetter data;
    public boolean isConnected;

    public void onEnable() {
        boolean dateConversionWorked;
        this.getLogger().info("Successfully launched. Suggestions? Questions? Report a Bug? Visit my discord server! https://discord.gg/hDqPms3MbH");
        this.setupConfigs();
        this.checkNewUpdateAndCurrentVersion();
        this.setupMetrics();
        this.setupSQL();
        WorkaroundManagement workaroundManagement = new WorkaroundManagement();
        workaroundManagement.performMigrationCheck();
        if (WorkaroundManagement.isLegacyConfig) {
            WorkaroundManagement.notifyInstanceAboutLegacyConfigAtPluginStartup();
            return;
        }
        if (WorkaroundManagement.isSQLMigrationNeeded || WorkaroundManagement.isConfigMigrationNeeded) {
            this.registerListenerAndCommands();
            WorkaroundManagement.notifyInstanceAboutWorkaroundAtPluginStartup();
            return;
        }
        if (this.data.oldDateFormatUsed() && !(dateConversionWorked = this.data.convertOldDateFormatToNewDateFormat())) {
            this.getLogger().warning("Date conversion failed. Please contact the plugin developer.");
            return;
        }
        this.registerListenerAndCommands();
    }

    public void onDisable() {
        Utils.SQL.SQL.disconnect();
    }

    public boolean setupSQL() {
        this.SQL = new SQL();
        this.data = new SQLGetter(this);
        try {
            this.SQL.connect();
        }
        catch (Exception exception) {
            this.isConnected = false;
            this.getLogger().info("Database is not connected");
            throw exception;
        }
        try {
            if (!Utils.SQL.SQL.getConnection().isClosed()) {
                this.getLogger().info("Database is connected");
                if (!this.data.initTables()) {
                    return false;
                }
                this.isConnected = true;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public void setupConfigs() {
        ConfigManagement.initConfigFiles(this);
        this.config = ConfigManagement.getConfig();
    }

    public void registerListenerAndCommands() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        pluginManager.registerEvents((Listener)new OnPlayerJoin(), (Plugin)this);
        if (!this.isConnected) {
            return;
        }
        this.getCommand("kudmin").setExecutor((CommandExecutor)new Kudmin());
        this.getCommand("kudmin").setTabCompleter((TabCompleter)new Kudmin());
        pluginManager.registerEvents((Listener)new OverviewGUI(), (Plugin)this);
        pluginManager.registerEvents((Listener)new ReceivedKudosGUI(), (Plugin)this);
        this.getCommand("kudos").setExecutor((CommandExecutor)new Kudos());
        this.getCommand("kudos").setTabCompleter((TabCompleter)new Kudos());
        this.getCommand("kudo").setExecutor((CommandExecutor)new Kudo());
        this.getCommand("kudo").setTabCompleter((TabCompleter)new Kudo());
        if (pluginManager.getPlugin("PlaceholderAPI") != null) {
            new KudosExpansion().register();
        }
    }

    private void setupMetrics() {
        new Metrics(this, 16627);
    }

    public void checkNewUpdateAndCurrentVersion() {
        String pluginVersion = this.getDescription().getVersion();
        if (pluginVersion.contains("PRE")) {
            this.getLogger().info("You're using a 'PRE' version. Please notice that bugs can occur!");
        }
        if (!this.config.getBoolean("general-settings.update-notification")) {
            return;
        }
        new UpdateChecker(this, 106036).getVersion((Consumer<String>)((Consumer)version -> {
            int majorPluginVersion = Integer.parseInt(pluginVersion.substring(0, pluginVersion.indexOf(46)));
            int majorPluginVersionOnSpigot = Integer.parseInt(version.substring(0, version.indexOf(46)));
            if (majorPluginVersion <= 0) {
                this.getLogger().info("An error occurred when checking a new update");
                return;
            }
            if (majorPluginVersion < majorPluginVersionOnSpigot) {
                this.getLogger().info("There is a new major version available. Please check the changelogs for breaking changes!");
                return;
            }
            if (pluginVersion.equals(version)) {
                this.getLogger().info("There is not a new update available.");
            } else {
                this.getLogger().info("There is a new update available.");
            }
        }));
    }
}

