/*
 * Decompiled with CFR 0.152.
 */
package de.urbance.shaded.inventoryframework.pane;

import de.urbance.shaded.inventoryframework.exception.XMLLoadException;
import de.urbance.shaded.inventoryframework.gui.GuiItem;
import de.urbance.shaded.inventoryframework.gui.InventoryComponent;
import de.urbance.shaded.inventoryframework.gui.type.util.Gui;
import de.urbance.shaded.inventoryframework.pane.Flippable;
import de.urbance.shaded.inventoryframework.pane.Orientable;
import de.urbance.shaded.inventoryframework.pane.Pane;
import de.urbance.shaded.inventoryframework.pane.Rotatable;
import de.urbance.shaded.inventoryframework.pane.util.Mask;
import de.urbance.shaded.inventoryframework.pane.util.Slot;
import de.urbance.shaded.inventoryframework.util.GeometryUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OutlinePane
extends Pane
implements Flippable,
Orientable,
Rotatable {
    @NotNull
    private final List<GuiItem> items;
    @NotNull
    private Orientable.Orientation orientation;
    private int rotation;
    private int gap;
    private boolean repeat;
    private boolean flipHorizontally;
    private boolean flipVertically;
    @NotNull
    private Alignment alignment = Alignment.BEGIN;
    @NotNull
    private Mask mask;

    public OutlinePane(@NotNull Slot slot, int length, int height, @NotNull Pane.Priority priority) {
        super(slot, length, height, priority);
        this.items = new ArrayList<GuiItem>(length * height);
        this.orientation = Orientable.Orientation.HORIZONTAL;
        Object[] mask = new String[height];
        StringBuilder maskString = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            maskString.append('1');
        }
        Arrays.fill(mask, maskString.toString());
        this.mask = new Mask((String[])mask);
    }

    public OutlinePane(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        this(Slot.fromXY(x, y), length, height, priority);
    }

    public OutlinePane(@NotNull Slot slot, int length, int height) {
        this(slot, length, height, Pane.Priority.NORMAL);
    }

    public OutlinePane(int x, int y, int length, int height) {
        this(x, y, length, height, Pane.Priority.NORMAL);
    }

    public OutlinePane(int length, int height) {
        this(0, 0, length, height);
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int size;
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        int itemIndex = 0;
        int gapCount = 0;
        if (this.getOrientation() == Orientable.Orientation.HORIZONTAL) {
            size = height;
        } else if (this.getOrientation() == Orientable.Orientation.VERTICAL) {
            size = length;
        } else {
            throw new IllegalStateException("Unknown orientation '" + (Object)((Object)this.getOrientation()) + "'");
        }
        for (int vectorIndex = 0; vectorIndex < size && this.getItems().size() > itemIndex; ++vectorIndex) {
            int index;
            GuiItem[] items;
            boolean[] maskLine;
            if (this.getOrientation() == Orientable.Orientation.HORIZONTAL) {
                maskLine = this.mask.getRow(vectorIndex);
            } else if (this.getOrientation() == Orientable.Orientation.VERTICAL) {
                maskLine = this.mask.getColumn(vectorIndex);
            } else {
                throw new IllegalStateException("Unknown orientation '" + (Object)((Object)this.getOrientation()) + "'");
            }
            int enabled = 0;
            for (boolean bool : maskLine) {
                if (!bool) continue;
                ++enabled;
            }
            if (this.doesRepeat()) {
                items = new GuiItem[enabled];
            } else {
                int remainingPositions = gapCount + (this.getItems().size() - itemIndex - 1) * (this.getGap() + 1) + 1;
                items = new GuiItem[Math.min(enabled, remainingPositions)];
            }
            for (index = 0; index < items.length; ++index) {
                if (gapCount == 0) {
                    items[index] = (GuiItem)this.getItems().get(itemIndex);
                    if (this.doesRepeat() && ++itemIndex >= this.getItems().size()) {
                        itemIndex = 0;
                    }
                    gapCount = this.getGap();
                    continue;
                }
                items[index] = null;
                --gapCount;
            }
            if (this.getAlignment() == Alignment.BEGIN) {
                index = 0;
            } else if (this.getAlignment() == Alignment.CENTER) {
                index = -((enabled - items.length) / 2);
            } else {
                throw new IllegalStateException("Unknown alignment '" + (Object)((Object)this.getAlignment()) + "'");
            }
            for (int opposingVectorIndex = 0; opposingVectorIndex < maskLine.length; ++opposingVectorIndex) {
                if (!maskLine[opposingVectorIndex]) continue;
                if (index >= 0 && index < items.length && items[index] != null) {
                    int y;
                    int x;
                    if (this.getOrientation() == Orientable.Orientation.HORIZONTAL) {
                        x = opposingVectorIndex;
                        y = vectorIndex;
                    } else if (this.getOrientation() == Orientable.Orientation.VERTICAL) {
                        x = vectorIndex;
                        y = opposingVectorIndex;
                    } else {
                        throw new IllegalStateException("Unknown orientation '" + (Object)((Object)this.getOrientation()) + "'");
                    }
                    if (this.flipHorizontally) {
                        x = length - x - 1;
                    }
                    if (this.flipVertically) {
                        y = height - y - 1;
                    }
                    Map.Entry<Integer, Integer> coordinates = GeometryUtil.processClockwiseRotation(x, y, length, height, this.rotation);
                    x = coordinates.getKey();
                    y = coordinates.getValue();
                    if (x >= 0 && x < length && y >= 0 && y < height) {
                        Slot slot = this.getSlot();
                        int finalRow = slot.getY(maxLength) + y + paneOffsetY;
                        int finalColumn = slot.getX(maxLength) + x + paneOffsetX;
                        GuiItem item = items[index];
                        if (item.isVisible()) {
                            inventoryComponent.setItem(item, finalColumn, finalRow);
                        }
                    }
                }
                ++index;
            }
        }
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        Slot paneSlot = this.getSlot();
        int xPosition = paneSlot.getX(maxLength);
        int yPosition = paneSlot.getY(maxLength);
        int totalLength = inventoryComponent.getLength();
        int adjustedSlot = slot - (xPosition + paneOffsetX) - totalLength * (yPosition + paneOffsetY);
        int x = adjustedSlot % totalLength;
        int y = adjustedSlot / totalLength;
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        this.callOnClick(event);
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return false;
        }
        GuiItem item = OutlinePane.findMatchingItem(this.items, itemStack);
        if (item == null) {
            return false;
        }
        item.callAction(event);
        return true;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public OutlinePane copy() {
        OutlinePane outlinePane = new OutlinePane(this.getSlot(), this.length, this.height, this.getPriority());
        for (GuiItem item : this.items) {
            outlinePane.addItem(item.copy());
        }
        outlinePane.setVisible(this.isVisible());
        outlinePane.onClick = this.onClick;
        outlinePane.uuid = this.uuid;
        outlinePane.orientation = this.orientation;
        outlinePane.rotation = this.rotation;
        outlinePane.gap = this.gap;
        outlinePane.repeat = this.repeat;
        outlinePane.flipHorizontally = this.flipHorizontally;
        outlinePane.flipVertically = this.flipVertically;
        outlinePane.mask = this.mask;
        outlinePane.alignment = this.alignment;
        return outlinePane;
    }

    @Override
    public void setRotation(int rotation) {
        if (this.length != this.height) {
            throw new UnsupportedOperationException("length and height are different");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation isn't divisible by 90");
        }
        this.rotation = rotation % 360;
    }

    public void insertItem(@NotNull GuiItem item, int index) {
        this.items.add(index, item);
    }

    public void addItem(@NotNull GuiItem item) {
        this.items.add(item);
    }

    public void removeItem(@NotNull GuiItem item) {
        this.items.remove(item);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    public void applyMask(@NotNull Mask mask) {
        if (this.length != mask.getLength() || this.height != mask.getHeight()) {
            throw new IllegalArgumentException("Mask's dimension must be the same as the pane's dimension");
        }
        this.mask = mask;
    }

    @Override
    public void setLength(int length) {
        super.setLength(length);
        this.applyMask(this.getMask().setLength(length));
    }

    @Override
    public void setHeight(int height) {
        super.setHeight(height);
        this.applyMask(this.getMask().setHeight(height));
    }

    public void align(@NotNull Alignment alignment) {
        this.alignment = alignment;
    }

    @Override
    public void flipHorizontally(boolean flipHorizontally) {
        this.flipHorizontally = flipHorizontally;
    }

    @Override
    public void flipVertically(boolean flipVertically) {
        this.flipVertically = flipVertically;
    }

    public void setGap(int gap) {
        this.gap = gap;
    }

    @Override
    public void setOrientation(@NotNull Orientable.Orientation orientation) {
        this.orientation = orientation;
    }

    public void setRepeat(boolean repeat) {
        this.repeat = repeat;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Collection<Pane> getPanes() {
        return new HashSet<Pane>();
    }

    @NotNull
    @Contract(pure=true)
    public Alignment getAlignment() {
        return this.alignment;
    }

    @Contract(pure=true)
    public boolean doesRepeat() {
        return this.repeat;
    }

    @Contract(pure=true)
    public int getGap() {
        return this.gap;
    }

    @NotNull
    public List<GuiItem> getItems() {
        return this.items;
    }

    @NotNull
    @Contract(pure=true)
    public Mask getMask() {
        return this.mask;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Orientable.Orientation getOrientation() {
        return this.orientation;
    }

    @Override
    @Contract(pure=true)
    public int getRotation() {
        return this.rotation;
    }

    @Override
    @Contract(pure=true)
    public boolean isFlippedHorizontally() {
        return this.flipHorizontally;
    }

    @Override
    @Contract(pure=true)
    public boolean isFlippedVertically() {
        return this.flipVertically;
    }

    @NotNull
    public static OutlinePane load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        try {
            OutlinePane outlinePane = new OutlinePane(Integer.parseInt(element.getAttribute("length")), Integer.parseInt(element.getAttribute("height")));
            if (element.hasAttribute("gap")) {
                outlinePane.setGap(Integer.parseInt(element.getAttribute("gap")));
            }
            if (element.hasAttribute("repeat")) {
                outlinePane.setRepeat(Boolean.parseBoolean(element.getAttribute("repeat")));
            }
            if (element.hasAttribute("alignment")) {
                outlinePane.align(Alignment.valueOf(element.getAttribute("alignment").toUpperCase()));
            }
            Pane.load(outlinePane, instance, element);
            Flippable.load(outlinePane, element);
            Orientable.load(outlinePane, element);
            Rotatable.load(outlinePane, element);
            if (element.hasAttribute("populate")) {
                return outlinePane;
            }
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (item.getNodeType() != 1) continue;
                if (item.getNodeName().equals("empty")) {
                    outlinePane.addItem(new GuiItem(new ItemStack(Material.AIR), plugin));
                    continue;
                }
                outlinePane.addItem(Pane.loadItem(instance, (Element)item, plugin));
            }
            return outlinePane;
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
    }

    @Deprecated
    @NotNull
    public static OutlinePane load(@NotNull Object instance, @NotNull Element element) {
        return OutlinePane.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(OutlinePane.class));
    }

    public static enum Alignment {
        BEGIN,
        CENTER;

    }
}

