/*
 * Decompiled with CFR 0.152.
 */
package de.urbance.shaded.inventoryframework.pane;

import de.urbance.shaded.inventoryframework.exception.XMLLoadException;
import de.urbance.shaded.inventoryframework.gui.GuiItem;
import de.urbance.shaded.inventoryframework.gui.InventoryComponent;
import de.urbance.shaded.inventoryframework.gui.type.util.Gui;
import de.urbance.shaded.inventoryframework.pane.Flippable;
import de.urbance.shaded.inventoryframework.pane.Pane;
import de.urbance.shaded.inventoryframework.pane.Rotatable;
import de.urbance.shaded.inventoryframework.pane.util.Slot;
import de.urbance.shaded.inventoryframework.util.GeometryUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StaticPane
extends Pane
implements Flippable,
Rotatable {
    @NotNull
    private final Map<Slot, GuiItem> items;
    private int rotation;
    private boolean flipHorizontally;
    private boolean flipVertically;

    public StaticPane(Slot slot, int length, int height, @NotNull Pane.Priority priority) {
        super(slot, length, height, priority);
        this.items = new HashMap<Slot, GuiItem>(length * height);
    }

    public StaticPane(int x, int y, int length, int height, @NotNull Pane.Priority priority) {
        this(Slot.fromXY(x, y), length, height, priority);
    }

    public StaticPane(Slot slot, int length, int height) {
        this(slot, length, height, Pane.Priority.NORMAL);
    }

    public StaticPane(int x, int y, int length, int height) {
        this(x, y, length, height, Pane.Priority.NORMAL);
    }

    public StaticPane(int length, int height) {
        this(0, 0, length, height);
    }

    @Override
    public void display(@NotNull InventoryComponent inventoryComponent, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        this.items.entrySet().stream().filter(entry -> ((GuiItem)entry.getValue()).isVisible()).forEach(entry -> {
            Slot location = (Slot)entry.getKey();
            int x = location.getX(this.getLength());
            int y = location.getY(this.getLength());
            if (this.flipHorizontally) {
                x = length - x - 1;
            }
            if (this.flipVertically) {
                y = height - y - 1;
            }
            Map.Entry<Integer, Integer> coordinates = GeometryUtil.processClockwiseRotation(x, y, length, height, this.rotation);
            x = coordinates.getKey();
            y = coordinates.getValue();
            if (x < 0 || x >= length || y < 0 || y >= height) {
                return;
            }
            GuiItem item = (GuiItem)entry.getValue();
            Slot slot = this.getSlot();
            int finalRow = slot.getY(maxLength) + y + paneOffsetY;
            int finalColumn = slot.getX(maxLength) + x + paneOffsetX;
            inventoryComponent.setItem(item, finalColumn, finalRow);
        });
    }

    public void addItem(@NotNull GuiItem item, int x, int y) {
        this.addItem(item, Slot.fromXY(x, y));
    }

    public void addItem(@NotNull GuiItem item, Slot slot) {
        this.items.put(slot, item);
    }

    public void removeItem(@NotNull GuiItem item) {
        this.items.values().removeIf(guiItem -> guiItem.equals(item));
    }

    public void removeItem(int x, int y) {
        this.items.remove(Slot.fromXY(x, y));
    }

    public void removeItem(@NotNull Slot slot) {
        this.items.remove(slot);
    }

    @Override
    public boolean click(@NotNull Gui gui, @NotNull InventoryComponent inventoryComponent, @NotNull InventoryClickEvent event, int slot, int paneOffsetX, int paneOffsetY, int maxLength, int maxHeight) {
        int length = Math.min(this.length, maxLength);
        int height = Math.min(this.height, maxHeight);
        Slot paneSlot = this.getSlot();
        int xPosition = paneSlot.getX(maxLength);
        int yPosition = paneSlot.getY(maxLength);
        int totalLength = inventoryComponent.getLength();
        int adjustedSlot = slot - (xPosition + paneOffsetX) - totalLength * (yPosition + paneOffsetY);
        int x = adjustedSlot % totalLength;
        int y = adjustedSlot / totalLength;
        if (x < 0 || x >= length || y < 0 || y >= height) {
            return false;
        }
        this.callOnClick(event);
        ItemStack itemStack = event.getCurrentItem();
        if (itemStack == null) {
            return false;
        }
        GuiItem clickedItem = StaticPane.findMatchingItem(this.items.values(), itemStack);
        if (clickedItem == null) {
            return false;
        }
        clickedItem.callAction(event);
        return true;
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public StaticPane copy() {
        StaticPane staticPane = new StaticPane(this.getSlot(), this.length, this.height, this.getPriority());
        for (Map.Entry<Slot, GuiItem> entry : this.items.entrySet()) {
            staticPane.addItem(entry.getValue().copy(), entry.getKey());
        }
        staticPane.setVisible(this.isVisible());
        staticPane.onClick = this.onClick;
        staticPane.uuid = this.uuid;
        staticPane.rotation = this.rotation;
        staticPane.flipHorizontally = this.flipHorizontally;
        staticPane.flipVertically = this.flipVertically;
        return staticPane;
    }

    @Override
    public void setRotation(int rotation) {
        if (this.length != this.height) {
            throw new UnsupportedOperationException("length and height are different");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation isn't divisible by 90");
        }
        this.rotation = rotation % 360;
    }

    public void fillWith(@NotNull ItemStack itemStack, @Nullable Consumer<InventoryClickEvent> action, @NotNull Plugin plugin) {
        Set<Slot> locations = this.items.keySet();
        for (int y = 0; y < this.getHeight(); ++y) {
            for (int x = 0; x < this.getLength(); ++x) {
                boolean found = false;
                for (Slot location : locations) {
                    if (location.getX(this.getLength()) != x || location.getY(this.getLength()) != y) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                this.addItem(new GuiItem(itemStack, action, plugin), x, y);
            }
        }
    }

    public void fillWith(@NotNull ItemStack itemStack, @Nullable Consumer<InventoryClickEvent> action) {
        this.fillWith(itemStack, action, (Plugin)JavaPlugin.getProvidingPlugin(StaticPane.class));
    }

    @Contract(value="null -> fail")
    public void fillWith(@NotNull ItemStack itemStack) {
        this.fillWith(itemStack, null);
    }

    @Nullable
    @Contract(pure=true)
    public GuiItem getItem(@NotNull Slot slot) {
        int x = slot.getX(this.getLength());
        int y = slot.getY(this.getLength());
        for (Map.Entry<Slot, GuiItem> entry : this.items.entrySet()) {
            Slot key = entry.getKey();
            if (key.getX(this.getLength()) != x || key.getY(this.getLength()) != y) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    @NotNull
    public Collection<GuiItem> getItems() {
        return this.items.values();
    }

    @NotNull
    @Contract(pure=true)
    public @NotNull Map<@NotNull Slot, @NotNull GuiItem> getSlottedItems() {
        return Collections.unmodifiableMap(this.items);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    @NotNull
    @Contract(pure=true)
    public Collection<Pane> getPanes() {
        return new HashSet<Pane>();
    }

    @Override
    public void flipHorizontally(boolean flipHorizontally) {
        this.flipHorizontally = flipHorizontally;
    }

    @Override
    public void flipVertically(boolean flipVertically) {
        this.flipVertically = flipVertically;
    }

    @Override
    @Contract(pure=true)
    public int getRotation() {
        return this.rotation;
    }

    @Override
    @Contract(pure=true)
    public boolean isFlippedHorizontally() {
        return this.flipHorizontally;
    }

    @Override
    @Contract(pure=true)
    public boolean isFlippedVertically() {
        return this.flipVertically;
    }

    @NotNull
    public static StaticPane load(@NotNull Object instance, @NotNull Element element, @NotNull Plugin plugin) {
        try {
            StaticPane staticPane = new StaticPane(Integer.parseInt(element.getAttribute("length")), Integer.parseInt(element.getAttribute("height")));
            Pane.load(staticPane, instance, element);
            Flippable.load(staticPane, element);
            Rotatable.load(staticPane, element);
            if (element.hasAttribute("populate")) {
                return staticPane;
            }
            NodeList childNodes = element.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node item = childNodes.item(i);
                if (item.getNodeType() != 1) continue;
                Element child = (Element)item;
                staticPane.addItem(Pane.loadItem(instance, child, plugin), Slot.deserialize(child));
            }
            return staticPane;
        }
        catch (NumberFormatException exception) {
            throw new XMLLoadException(exception);
        }
    }

    @Deprecated
    @NotNull
    public static StaticPane load(@NotNull Object instance, @NotNull Element element) {
        return StaticPane.load(instance, element, (Plugin)JavaPlugin.getProvidingPlugin(StaticPane.class));
    }
}

