/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.structuredcrafting.craft.provider;

import java.util.Iterator;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import org.cyclops.structuredcrafting.block.BlockStructuredCrafterConfig;
import org.cyclops.structuredcrafting.craft.provider.IItemStackProvider;

public class InventoryItemStackProviderFabric
implements IItemStackProvider {
    @Override
    public boolean canProvideInput() {
        return BlockStructuredCrafterConfig.canTakeInputsFromInventory;
    }

    @Override
    public boolean canHandleOutput() {
        return BlockStructuredCrafterConfig.canPlaceOutputsIntoInventory;
    }

    @Override
    public boolean isValidForResults(class_1937 world, class_2338 pos, class_2350 side) {
        return ItemStorage.SIDED.find(world, pos, (Object)side) != null;
    }

    @Override
    public boolean hasItemStack(class_1937 world, class_2338 pos, class_2350 side) {
        return ItemStorage.SIDED.find(world, pos, (Object)side) != null;
    }

    @Override
    public class_1799 getItemStack(class_1937 world, class_2338 pos, class_2350 side) {
        Iterator it;
        Storage storage = (Storage)ItemStorage.SIDED.find(world, pos, (Object)side);
        if (storage != null && (it = storage.nonEmptyIterator()).hasNext()) {
            return ((ItemVariant)((StorageView)it.next()).getResource()).toStack();
        }
        return class_1799.field_8037;
    }

    @Override
    public boolean reduceItemStack(class_1937 world, class_2338 pos, class_2350 side, boolean simulate) {
        Iterator it;
        Storage storage = (Storage)ItemStorage.SIDED.find(world, pos, (Object)side);
        if (storage != null && (it = storage.nonEmptyIterator()).hasNext()) {
            class_1799 firstStack = ((ItemVariant)((StorageView)it.next()).getResource()).toStack();
            try (Transaction tx = Transaction.openOuter();){
                long extracted = storage.extract((Object)ItemVariant.of((class_1799)firstStack), 1L, (TransactionContext)tx);
                if (simulate) {
                    tx.abort();
                } else {
                    tx.commit();
                }
                boolean bl = extracted > 0L;
                return bl;
            }
        }
        return false;
    }

    @Override
    public boolean addItemStack(class_1937 world, class_2338 pos, class_2350 side, class_1799 itemStack, boolean simulate) {
        Storage storage = (Storage)ItemStorage.SIDED.find(world, pos, (Object)side);
        if (storage != null) {
            try (Transaction tx = Transaction.openOuter();){
                long inserted = storage.insert((Object)ItemVariant.of((class_1799)itemStack), (long)itemStack.method_7947(), (TransactionContext)tx);
                if (simulate) {
                    tx.abort();
                } else {
                    tx.commit();
                }
                boolean bl = inserted > 0L;
                return bl;
            }
        }
        return false;
    }

    @Override
    public boolean setItemStack(class_1937 world, class_2338 pos, class_2350 side, class_1799 itemStack, boolean simulate) {
        return this.addItemStack(world, pos, side, itemStack, simulate);
    }
}

