/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.structuredcrafting.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.cyclops.cyclopscore.blockentity.BlockEntityTickerDelayed;
import org.cyclops.cyclopscore.blockentity.CyclopsBlockEntity;
import org.cyclops.structuredcrafting.RegistryEntries;
import org.cyclops.structuredcrafting.craft.WorldCraftingMatrix;

public class BlockEntityStructuredCrafter
extends CyclopsBlockEntity {
    private static final int SPEED = 20;
    protected WorldCraftingMatrix matrix = null;
    private int tickOffset = (int)(Math.random() * 20.0);

    public BlockEntityStructuredCrafter(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)RegistryEntries.BLOCK_ENTITY_STRUCTURED_CRAFTER.value(), blockPos, blockState);
    }

    public WorldCraftingMatrix getMatrix() {
        if (this.matrix == null) {
            this.matrix = WorldCraftingMatrix.deriveMatrix(this.level, this.worldPosition);
        }
        return this.matrix;
    }

    public void setMatrix(WorldCraftingMatrix matrix) {
        this.matrix = matrix;
    }

    public int getTickOffset() {
        return this.tickOffset;
    }

    public void setTickOffset(int tickOffset) {
        this.tickOffset = tickOffset;
    }

    public static class Ticker
    extends BlockEntityTickerDelayed<BlockEntityStructuredCrafter> {
        protected void update(Level level, BlockPos pos, BlockState blockState, BlockEntityStructuredCrafter blockEntity) {
            super.update(level, pos, blockState, (BlockEntity)blockEntity);
            blockEntity.setTickOffset((blockEntity.getTickOffset() + 1) % 20);
            if (!level.isClientSide() && blockEntity.getTickOffset() == 0) {
                if (level.hasNeighborSignal(pos)) {
                    blockEntity.getMatrix().craft(false);
                } else {
                    blockEntity.setMatrix(null);
                }
            }
        }
    }
}

