/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.structuredcrafting.craft.provider;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.cyclops.cyclopscore.helper.IModHelpersForge;
import org.cyclops.structuredcrafting.craft.provider.WorldItemStackProviderBase;

public class WorldItemStackProviderForge
extends WorldItemStackProviderBase {
    private final IModHelpersForge modHelpers;

    public WorldItemStackProviderForge(IModHelpersForge modHelpers) {
        this.modHelpers = modHelpers;
    }

    @Override
    protected boolean hasEmptyItemHandler(Level world, BlockPos pos, Direction side) {
        IItemHandler itemHandler = (IItemHandler)this.modHelpers.getCapabilityHelpers().getCapability((BlockGetter)world, pos, side, ForgeCapabilities.ITEM_HANDLER).orElse(null);
        boolean emptyItemHandler = true;
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                if (itemHandler.extractItem(i, 1, true).isEmpty()) continue;
                emptyItemHandler = false;
                break;
            }
        }
        return emptyItemHandler;
    }

    @Override
    public ItemStack getItemStack(Level world, BlockPos pos, Direction side) {
        BlockState blockState = world.getBlockState(pos);
        if (blockState != null && this.hasEmptyItemHandler(world, pos, side)) {
            return blockState.getBlock().getCloneItemStack((LevelReader)world, pos, blockState);
        }
        return ItemStack.EMPTY;
    }
}

