/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.structuredcrafting.gametest;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.cyclops.structuredcrafting.RegistryEntries;
import org.cyclops.structuredcrafting.block.BlockStructuredCrafter;

public class GameTestsCommon {
    public static final String TEMPLATE_EMPTY = "structuredcrafting:empty10";
    public static final BlockPos POS = BlockPos.ZERO;

    @GameTest(template="structuredcrafting:empty10")
    public void testPlacementDirection(GameTestHelper helper) {
        Player player = helper.makeMockPlayer(GameType.SURVIVAL);
        ItemStack itemStack = new ItemStack((ItemLike)RegistryEntries.ITEM_STRUCTURED_CRAFTER.value());
        player.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
        helper.placeAt(player, itemStack, POS, Direction.SOUTH);
        helper.succeedIf(() -> {
            helper.assertBlockPresent((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value(), POS.south());
            helper.assertBlockProperty(POS.south(), (Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH);
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromWorldToWorldStairs(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(3, 1, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(2, 1, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(1, 1, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(3, 2, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(2, 2, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(3, 3, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            helper.assertBlockPresent(Blocks.OAK_STAIRS, POS.offset(2, 2, 1));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(3, 1, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(2, 1, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(1, 1, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(3, 2, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(2, 2, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(3, 3, 3));
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromWorldToWorldChest(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(3, 1, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(2, 1, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(1, 1, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(3, 2, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(1, 2, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(3, 3, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(2, 3, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(1, 3, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            helper.assertBlockPresent(Blocks.CHEST, POS.offset(2, 2, 1));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(3, 1, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(2, 1, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(1, 1, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(3, 2, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(1, 2, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(3, 3, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(2, 3, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(1, 3, 3));
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromWorldToWorldChestTags(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(3, 1, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(2, 1, 3), Blocks.BIRCH_PLANKS);
        helper.setBlock(POS.offset(1, 1, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(3, 2, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(1, 2, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(3, 3, 3), Blocks.BAMBOO_PLANKS);
        helper.setBlock(POS.offset(2, 3, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(1, 3, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            helper.assertBlockPresent(Blocks.CHEST, POS.offset(2, 2, 1));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(3, 1, 3));
            helper.assertBlockNotPresent(Blocks.BIRCH_PLANKS, POS.offset(2, 1, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(1, 1, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(3, 2, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(1, 2, 3));
            helper.assertBlockNotPresent(Blocks.BAMBOO_PLANKS, POS.offset(3, 3, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(2, 3, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(1, 3, 3));
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromChestsToWorldStairs(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        this.setChestWithItem(helper, POS.offset(3, 1, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        this.setChestWithItem(helper, POS.offset(2, 1, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        this.setChestWithItem(helper, POS.offset(1, 1, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        this.setChestWithItem(helper, POS.offset(3, 2, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        this.setChestWithItem(helper, POS.offset(2, 2, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        this.setChestWithItem(helper, POS.offset(3, 3, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            helper.assertBlockPresent(Blocks.OAK_STAIRS, POS.offset(2, 2, 1));
            this.assertChestEmpty(helper, POS.offset(3, 1, 3));
            this.assertChestEmpty(helper, POS.offset(2, 1, 3));
            this.assertChestEmpty(helper, POS.offset(1, 1, 3));
            this.assertChestEmpty(helper, POS.offset(3, 2, 3));
            this.assertChestEmpty(helper, POS.offset(2, 2, 3));
            this.assertChestEmpty(helper, POS.offset(3, 3, 3));
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromWorldToChestStairs(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        helper.setBlock(POS.offset(3, 1, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(2, 1, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(1, 1, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(3, 2, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(2, 2, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(3, 3, 3), Blocks.OAK_PLANKS);
        helper.setBlock(POS.offset(2, 2, 1), Blocks.CHEST);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            this.assertChestContains(helper, POS.offset(2, 2, 1), new ItemStack((ItemLike)Blocks.OAK_STAIRS, 4));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(3, 1, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(2, 1, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(1, 1, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(3, 2, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(2, 2, 3));
            helper.assertBlockNotPresent(Blocks.OAK_PLANKS, POS.offset(3, 3, 3));
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromChestsToChestStairs(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        this.setChestWithItem(helper, POS.offset(3, 1, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        this.setChestWithItem(helper, POS.offset(2, 1, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        this.setChestWithItem(helper, POS.offset(1, 1, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        this.setChestWithItem(helper, POS.offset(3, 2, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        this.setChestWithItem(helper, POS.offset(2, 2, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        this.setChestWithItem(helper, POS.offset(3, 3, 3), new ItemStack((ItemLike)Blocks.OAK_PLANKS));
        helper.setBlock(POS.offset(2, 2, 1), Blocks.CHEST);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            this.assertChestContains(helper, POS.offset(2, 2, 1), new ItemStack((ItemLike)Blocks.OAK_STAIRS, 4));
            this.assertChestEmpty(helper, POS.offset(3, 1, 3));
            this.assertChestEmpty(helper, POS.offset(2, 1, 3));
            this.assertChestEmpty(helper, POS.offset(1, 1, 3));
            this.assertChestEmpty(helper, POS.offset(3, 2, 3));
            this.assertChestEmpty(helper, POS.offset(2, 2, 3));
            this.assertChestEmpty(helper, POS.offset(3, 3, 3));
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromChestsToChestCakeReusable(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        this.setChestWithItem(helper, POS.offset(3, 3, 3), new ItemStack((ItemLike)Items.MILK_BUCKET));
        this.setChestWithItem(helper, POS.offset(2, 3, 3), new ItemStack((ItemLike)Items.MILK_BUCKET));
        this.setChestWithItem(helper, POS.offset(1, 3, 3), new ItemStack((ItemLike)Items.MILK_BUCKET));
        this.setChestWithItem(helper, POS.offset(3, 2, 3), new ItemStack((ItemLike)Items.SUGAR));
        this.setChestWithItem(helper, POS.offset(2, 2, 3), new ItemStack((ItemLike)Items.EGG));
        this.setChestWithItem(helper, POS.offset(1, 2, 3), new ItemStack((ItemLike)Items.SUGAR));
        this.setChestWithItem(helper, POS.offset(3, 1, 3), new ItemStack((ItemLike)Items.WHEAT));
        this.setChestWithItem(helper, POS.offset(2, 1, 3), new ItemStack((ItemLike)Items.WHEAT));
        this.setChestWithItem(helper, POS.offset(1, 1, 3), new ItemStack((ItemLike)Items.WHEAT));
        helper.setBlock(POS.offset(2, 2, 1), Blocks.CHEST);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            this.assertChestContains(helper, POS.offset(2, 2, 1), new ItemStack((ItemLike)Blocks.CAKE));
            this.assertChestContains(helper, POS.offset(3, 3, 3), new ItemStack((ItemLike)Items.BUCKET));
            this.assertChestContains(helper, POS.offset(2, 3, 3), new ItemStack((ItemLike)Items.BUCKET));
            this.assertChestContains(helper, POS.offset(1, 3, 3), new ItemStack((ItemLike)Items.BUCKET));
            this.assertChestEmpty(helper, POS.offset(3, 2, 3));
            this.assertChestEmpty(helper, POS.offset(2, 2, 3));
            this.assertChestEmpty(helper, POS.offset(1, 2, 3));
            this.assertChestEmpty(helper, POS.offset(3, 1, 3));
            this.assertChestEmpty(helper, POS.offset(2, 1, 3));
            this.assertChestEmpty(helper, POS.offset(1, 1, 3));
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromChestsToChestBannerCopy1(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        ItemStack patternBanner = new ItemStack((ItemLike)Items.WHITE_BANNER);
        patternBanner.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers.Builder().add((Holder)helper.getLevel().registryAccess().asGetterLookup().get(Registries.BANNER_PATTERN, BannerPatterns.FLOWER).get(), DyeColor.YELLOW).build());
        this.setChestWithItem(helper, POS.offset(3, 3, 3), new ItemStack((ItemLike)Items.WHITE_BANNER));
        this.setChestWithItem(helper, POS.offset(2, 3, 3), patternBanner.copy());
        this.setChestWithItem(helper, POS.offset(1, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(1, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 1, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 1, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(1, 1, 3), ItemStack.EMPTY);
        helper.setBlock(POS.offset(2, 2, 1), Blocks.CHEST);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            this.assertChestContains(helper, POS.offset(2, 2, 1), patternBanner);
            this.assertChestEmpty(helper, POS.offset(3, 3, 3));
            this.assertChestContains(helper, POS.offset(2, 3, 3), patternBanner);
            this.assertChestEmpty(helper, POS.offset(1, 3, 3));
            this.assertChestEmpty(helper, POS.offset(3, 2, 3));
            this.assertChestEmpty(helper, POS.offset(2, 2, 3));
            this.assertChestEmpty(helper, POS.offset(1, 2, 3));
            this.assertChestEmpty(helper, POS.offset(3, 1, 3));
            this.assertChestEmpty(helper, POS.offset(2, 1, 3));
            this.assertChestEmpty(helper, POS.offset(1, 1, 3));
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromChestsToChestBannerCopy2(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        ItemStack patternBanner = new ItemStack((ItemLike)Items.WHITE_BANNER);
        patternBanner.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers.Builder().add((Holder)helper.getLevel().registryAccess().asGetterLookup().get(Registries.BANNER_PATTERN, BannerPatterns.FLOWER).get(), DyeColor.YELLOW).build());
        this.setChestWithItem(helper, POS.offset(3, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(1, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 2, 3), new ItemStack((ItemLike)Items.WHITE_BANNER));
        this.setChestWithItem(helper, POS.offset(2, 2, 3), patternBanner.copy());
        this.setChestWithItem(helper, POS.offset(1, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 1, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 1, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(1, 1, 3), ItemStack.EMPTY);
        helper.setBlock(POS.offset(2, 2, 1), Blocks.CHEST);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            this.assertChestContains(helper, POS.offset(2, 2, 1), patternBanner);
            this.assertChestEmpty(helper, POS.offset(3, 3, 3));
            this.assertChestEmpty(helper, POS.offset(2, 3, 3));
            this.assertChestEmpty(helper, POS.offset(1, 3, 3));
            this.assertChestEmpty(helper, POS.offset(3, 2, 3));
            this.assertChestContains(helper, POS.offset(2, 2, 3), patternBanner);
            this.assertChestEmpty(helper, POS.offset(1, 2, 3));
            this.assertChestEmpty(helper, POS.offset(3, 1, 3));
            this.assertChestEmpty(helper, POS.offset(2, 1, 3));
            this.assertChestEmpty(helper, POS.offset(1, 1, 3));
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromChestsToChestBannerCopy3(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        ItemStack patternBanner = new ItemStack((ItemLike)Items.WHITE_BANNER);
        patternBanner.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers.Builder().add((Holder)helper.getLevel().registryAccess().asGetterLookup().get(Registries.BANNER_PATTERN, BannerPatterns.FLOWER).get(), DyeColor.YELLOW).build());
        this.setChestWithItem(helper, POS.offset(3, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(1, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(1, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 1, 3), new ItemStack((ItemLike)Items.WHITE_BANNER));
        this.setChestWithItem(helper, POS.offset(2, 1, 3), patternBanner.copy());
        this.setChestWithItem(helper, POS.offset(1, 1, 3), ItemStack.EMPTY);
        helper.setBlock(POS.offset(2, 2, 1), Blocks.CHEST);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            this.assertChestContains(helper, POS.offset(2, 2, 1), patternBanner);
            this.assertChestEmpty(helper, POS.offset(3, 3, 3));
            this.assertChestEmpty(helper, POS.offset(2, 3, 3));
            this.assertChestEmpty(helper, POS.offset(1, 3, 3));
            this.assertChestEmpty(helper, POS.offset(3, 2, 3));
            this.assertChestEmpty(helper, POS.offset(2, 2, 3));
            this.assertChestEmpty(helper, POS.offset(1, 2, 3));
            this.assertChestEmpty(helper, POS.offset(3, 1, 3));
            this.assertChestContains(helper, POS.offset(2, 1, 3), patternBanner);
            this.assertChestEmpty(helper, POS.offset(1, 1, 3));
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromChestsToChestBannerCopy4(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        ItemStack patternBanner = new ItemStack((ItemLike)Items.WHITE_BANNER);
        patternBanner.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers.Builder().add((Holder)helper.getLevel().registryAccess().asGetterLookup().get(Registries.BANNER_PATTERN, BannerPatterns.FLOWER).get(), DyeColor.YELLOW).build());
        this.setChestWithItem(helper, POS.offset(3, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(1, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(1, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 1, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 1, 3), new ItemStack((ItemLike)Items.WHITE_BANNER));
        this.setChestWithItem(helper, POS.offset(1, 1, 3), patternBanner.copy());
        helper.setBlock(POS.offset(2, 2, 1), Blocks.CHEST);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            this.assertChestContains(helper, POS.offset(2, 2, 1), patternBanner);
            this.assertChestEmpty(helper, POS.offset(3, 3, 3));
            this.assertChestEmpty(helper, POS.offset(2, 3, 3));
            this.assertChestEmpty(helper, POS.offset(1, 3, 3));
            this.assertChestEmpty(helper, POS.offset(3, 2, 3));
            this.assertChestEmpty(helper, POS.offset(2, 2, 3));
            this.assertChestEmpty(helper, POS.offset(1, 2, 3));
            this.assertChestEmpty(helper, POS.offset(3, 1, 3));
            this.assertChestEmpty(helper, POS.offset(2, 1, 3));
            this.assertChestContains(helper, POS.offset(1, 1, 3), patternBanner);
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromChestsToChestBannerCopy5(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        ItemStack patternBanner = new ItemStack((ItemLike)Items.WHITE_BANNER);
        patternBanner.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers.Builder().add((Holder)helper.getLevel().registryAccess().asGetterLookup().get(Registries.BANNER_PATTERN, BannerPatterns.FLOWER).get(), DyeColor.YELLOW).build());
        this.setChestWithItem(helper, POS.offset(3, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 3, 3), new ItemStack((ItemLike)Items.WHITE_BANNER));
        this.setChestWithItem(helper, POS.offset(1, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(1, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 1, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 1, 3), patternBanner.copy());
        this.setChestWithItem(helper, POS.offset(1, 1, 3), ItemStack.EMPTY);
        helper.setBlock(POS.offset(2, 2, 1), Blocks.CHEST);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            this.assertChestContains(helper, POS.offset(2, 2, 1), patternBanner);
            this.assertChestEmpty(helper, POS.offset(3, 3, 3));
            this.assertChestEmpty(helper, POS.offset(2, 3, 3));
            this.assertChestEmpty(helper, POS.offset(1, 3, 3));
            this.assertChestEmpty(helper, POS.offset(3, 2, 3));
            this.assertChestEmpty(helper, POS.offset(2, 2, 3));
            this.assertChestEmpty(helper, POS.offset(1, 2, 3));
            this.assertChestEmpty(helper, POS.offset(3, 1, 3));
            this.assertChestContains(helper, POS.offset(2, 1, 3), patternBanner);
            this.assertChestEmpty(helper, POS.offset(1, 1, 3));
        });
    }

    @GameTest(template="structuredcrafting:empty10")
    public void testCraftFromChestsToChestBannerCopy6(GameTestHelper helper) {
        helper.setBlock(POS.offset(2, 2, 2), (BlockState)((Block)RegistryEntries.BLOCK_STRUCTURED_CRAFTER.value()).defaultBlockState().setValue((Property)BlockStructuredCrafter.FACING, (Comparable)Direction.NORTH));
        ItemStack patternBanner = new ItemStack((ItemLike)Items.WHITE_BANNER);
        patternBanner.set(DataComponents.BANNER_PATTERNS, (Object)new BannerPatternLayers.Builder().add((Holder)helper.getLevel().registryAccess().asGetterLookup().get(Registries.BANNER_PATTERN, BannerPatterns.FLOWER).get(), DyeColor.YELLOW).build());
        this.setChestWithItem(helper, POS.offset(3, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 3, 3), patternBanner.copy());
        this.setChestWithItem(helper, POS.offset(1, 3, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(1, 2, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(3, 1, 3), ItemStack.EMPTY);
        this.setChestWithItem(helper, POS.offset(2, 1, 3), new ItemStack((ItemLike)Items.WHITE_BANNER));
        this.setChestWithItem(helper, POS.offset(1, 1, 3), ItemStack.EMPTY);
        helper.setBlock(POS.offset(2, 2, 1), Blocks.CHEST);
        helper.setBlock(POS.offset(1, 2, 2), Blocks.REDSTONE_BLOCK);
        helper.succeedWhen(() -> {
            this.assertChestContains(helper, POS.offset(2, 2, 1), patternBanner);
            this.assertChestEmpty(helper, POS.offset(3, 3, 3));
            this.assertChestContains(helper, POS.offset(2, 3, 3), patternBanner);
            this.assertChestEmpty(helper, POS.offset(1, 3, 3));
            this.assertChestEmpty(helper, POS.offset(3, 2, 3));
            this.assertChestEmpty(helper, POS.offset(2, 2, 3));
            this.assertChestEmpty(helper, POS.offset(1, 2, 3));
            this.assertChestEmpty(helper, POS.offset(3, 1, 3));
            this.assertChestEmpty(helper, POS.offset(2, 1, 3));
            this.assertChestEmpty(helper, POS.offset(1, 1, 3));
        });
    }

    protected void setChestWithItem(GameTestHelper helper, BlockPos pos, ItemStack itemStack) {
        helper.setBlock(pos, Blocks.CHEST);
        ChestBlockEntity chest = (ChestBlockEntity)helper.getBlockEntity(pos);
        chest.setItem(0, itemStack);
    }

    protected void assertChestEmpty(GameTestHelper helper, BlockPos pos) {
        helper.assertBlockEntityData(pos, chest -> chest.isEmpty(), () -> "Chest is not empty");
    }

    protected void assertChestContains(GameTestHelper helper, BlockPos pos, ItemStack itemStack) {
        helper.assertBlockEntityData(pos, chest -> ItemStack.matches((ItemStack)chest.getItem(0), (ItemStack)itemStack), () -> "Chest is not empty");
    }
}

