/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.structuredcrafting;

import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.cyclops.cyclopscore.config.ConfigHandlerCommon;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfigCommon;
import org.cyclops.cyclopscore.helper.ModBaseCommon;
import org.cyclops.cyclopscore.init.IRegistry;
import org.cyclops.cyclopscore.init.ModBaseForge;
import org.cyclops.cyclopscore.proxy.IClientProxyCommon;
import org.cyclops.cyclopscore.proxy.ICommonProxyCommon;
import org.cyclops.structuredcrafting.GeneralConfig;
import org.cyclops.structuredcrafting.IStructuredCraftingMod;
import org.cyclops.structuredcrafting.RegistryEntries;
import org.cyclops.structuredcrafting.block.BlockStructuredCrafterConfig;
import org.cyclops.structuredcrafting.blockentity.BlockEntityStructuredCrafterConfig;
import org.cyclops.structuredcrafting.craft.provider.IItemStackProviderRegistry;
import org.cyclops.structuredcrafting.craft.provider.InventoryItemStackProviderForge;
import org.cyclops.structuredcrafting.craft.provider.ItemStackProviderRegistry;
import org.cyclops.structuredcrafting.craft.provider.WorldItemStackProviderForge;
import org.cyclops.structuredcrafting.gametest.GameTestsCommon;
import org.cyclops.structuredcrafting.proxy.ClientProxyForge;
import org.cyclops.structuredcrafting.proxy.CommonProxyForge;

@Mod(value="structuredcrafting")
public class StructuredCraftingForge
extends ModBaseForge<StructuredCraftingForge>
implements IStructuredCraftingMod {
    public static StructuredCraftingForge _instance;

    public StructuredCraftingForge(FMLJavaModLoadingContext context) {
        super("structuredcrafting", instance -> {
            _instance = instance;
            IStructuredCraftingMod.MOD.set(instance);
        }, context);
    }

    protected void setup(FMLCommonSetupEvent event) {
        this.getRegistryManager().addRegistry(IItemStackProviderRegistry.class, (IRegistry)new ItemStackProviderRegistry());
        super.setup(event);
        IItemStackProviderRegistry registry = (IItemStackProviderRegistry)this.getRegistryManager().getRegistry(IItemStackProviderRegistry.class);
        registry.registerProvider(new InventoryItemStackProviderForge(this.getModHelpers()));
        registry.registerProvider(new WorldItemStackProviderForge(this.getModHelpers()));
    }

    protected IClientProxyCommon constructClientProxy() {
        return new ClientProxyForge();
    }

    protected ICommonProxyCommon constructCommonProxy() {
        return new CommonProxyForge();
    }

    protected boolean hasDefaultCreativeModeTab() {
        return true;
    }

    protected CreativeModeTab.Builder constructDefaultCreativeModeTab(CreativeModeTab.Builder builder) {
        return super.constructDefaultCreativeModeTab(builder).icon(() -> new ItemStack(RegistryEntries.ITEM_STRUCTURED_CRAFTER));
    }

    protected void onConfigsRegister(ConfigHandlerCommon configHandler) {
        super.onConfigsRegister(configHandler);
        configHandler.addConfigurable((ExtendedConfigCommon)new GeneralConfig((ModBaseCommon<?>)this));
        configHandler.addConfigurable(new BlockStructuredCrafterConfig<StructuredCraftingForge>(this));
        configHandler.addConfigurable(new BlockEntityStructuredCrafterConfig<StructuredCraftingForge>(this));
    }

    public Class<?>[] getGameTestClasses() {
        return new Class[]{GameTestsCommon.class};
    }
}

