/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.structuredcrafting.craft;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.structuredcrafting.IStructuredCraftingMod;
import org.cyclops.structuredcrafting.block.BlockStructuredCrafter;
import org.cyclops.structuredcrafting.craft.WorldInventoryCrafting;
import org.cyclops.structuredcrafting.craft.provider.IItemStackProvider;
import org.cyclops.structuredcrafting.craft.provider.IItemStackProviderRegistry;

public class WorldCraftingMatrix {
    private final Level level;
    private final BlockPos centerPos;
    private final Direction.Axis axis;
    private final BlockPos targetPos;
    private final Direction targetSide;
    private final Direction inputSide;

    public WorldCraftingMatrix(Level level, BlockPos centerPos, Direction.Axis axis, BlockPos targetPos, Direction inputSide) {
        this.level = level;
        this.centerPos = centerPos;
        this.axis = axis;
        this.targetPos = targetPos;
        this.targetSide = inputSide.getOpposite();
        this.inputSide = inputSide;
    }

    protected BlockPos addInAxis(BlockPos pos, Direction.Axis axis, int i, int j) {
        if (axis == Direction.Axis.X) {
            return pos.offset(0, j, i);
        }
        if (axis == Direction.Axis.Y) {
            return pos.offset(i, 0, j);
        }
        if (axis == Direction.Axis.Z) {
            return pos.offset(i, j, 0);
        }
        return null;
    }

    protected List<IItemStackProvider> getItemStackProviders() {
        return ((IItemStackProviderRegistry)((IStructuredCraftingMod)IStructuredCraftingMod.MOD.get()).getRegistryManager().getRegistry(IItemStackProviderRegistry.class)).getProviders();
    }

    protected Map<ItemStack, IItemStackProvider> determineItemStackProviderForInput(Level level, BlockPos pos, Direction side) {
        HashMap providers = Maps.newHashMap();
        for (IItemStackProvider provider : this.getItemStackProviders()) {
            if (!provider.canProvideInput() || !provider.hasItemStack(level, pos, side)) continue;
            providers.put(provider.getItemStack(level, pos, side), provider);
        }
        return providers;
    }

    protected boolean addItemStackForOutput(Level level, BlockPos pos, Direction side, List<IItemStackProvider> outputProviders, ItemStack itemStack, boolean simulate) {
        for (IItemStackProvider provider : outputProviders) {
            if (!provider.canHandleOutput() || !provider.addItemStack(level, pos, side, itemStack, simulate)) continue;
            return true;
        }
        return false;
    }

    public boolean craft(boolean simulate) {
        LinkedList outputProviders = Lists.newLinkedList();
        for (IItemStackProvider provider : this.getItemStackProviders()) {
            if (!provider.isValidForResults(this.level, this.targetPos, this.targetSide)) continue;
            outputProviders.add(provider);
        }
        if (outputProviders.isEmpty()) {
            return false;
        }
        CraftingPossibility chosenPossibility = null;
        ItemStack itemStack = null;
        block1: for (int k = 0; k < 3; ++k) {
            if (chosenPossibility != null) continue;
            ArrayList possibilities = Lists.newArrayList((Object[])new CraftingPossibility[]{new CraftingPossibility()});
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    BlockPos pos = this.addInAxis(this.centerPos, this.axis, i, j);
                    Map<ItemStack, IItemStackProvider> results = this.determineItemStackProviderForInput(this.level, pos, this.inputSide);
                    boolean processedSingleResult = false;
                    ArrayList possibilitiesAtStart = Lists.newArrayList((Iterable)possibilities);
                    for (Map.Entry<ItemStack, IItemStackProvider> result : results.entrySet()) {
                        ItemStack itemStackInput = result.getKey();
                        if (!itemStackInput.isEmpty()) {
                            itemStackInput = itemStackInput.copy();
                            itemStackInput.setCount(1);
                        }
                        if (!processedSingleResult) {
                            for (CraftingPossibility possibility : possibilities) {
                                possibility.setPosition(i, j, k, pos, result.getValue(), result.getKey());
                            }
                            processedSingleResult = true;
                            continue;
                        }
                        for (CraftingPossibility possibility : possibilitiesAtStart) {
                            possibility = possibility.clone();
                            possibility.setPosition(i, j, k, pos, result.getValue(), result.getKey());
                            possibilities.add(possibility);
                        }
                    }
                    if (processedSingleResult) continue;
                    for (CraftingPossibility possibility : possibilities) {
                        possibility.setPosition(i, j, k, pos, null, ItemStack.EMPTY);
                    }
                }
            }
            for (CraftingPossibility possibility : possibilities) {
                itemStack = possibility.getOutput(this.level);
                if (itemStack.isEmpty()) continue;
                chosenPossibility = possibility;
                continue block1;
            }
        }
        if (chosenPossibility != null && !itemStack.isEmpty() && this.addItemStackForOutput(this.level, this.targetPos, this.targetSide, outputProviders, itemStack, true) && chosenPossibility.handleRemainingItems(this.level, this.inputSide, simulate)) {
            if (!simulate) {
                this.addItemStackForOutput(this.level, this.targetPos, this.targetSide, outputProviders, itemStack, simulate);
            }
            return true;
        }
        return false;
    }

    public static WorldCraftingMatrix deriveMatrix(Level level, BlockPos centerPos) {
        Direction side = ((Direction)level.getBlockState(centerPos).getValue(BlockStructuredCrafter.FACING)).getOpposite();
        return new WorldCraftingMatrix(level, centerPos.relative(side), side.getAxis(), centerPos.relative(side.getOpposite()), side.getOpposite());
    }

    public static class CraftingPossibility {
        private final WorldInventoryCrafting inventoryCrafting = new WorldInventoryCrafting();
        private final BlockPos[] positions = new BlockPos[9];
        private final IItemStackProvider[] providers = new IItemStackProvider[9];

        public void setPosition(int i, int j, int rotation, BlockPos pos, IItemStackProvider itemStackProvider, ItemStack itemStack) {
            int col;
            int row;
            if (rotation == 0) {
                row = i + 1;
                col = j + 1;
            } else if (rotation == 1) {
                row = j + 1;
                col = i + 1;
            } else if (rotation == 2) {
                row = i + 1;
                col = 2 - (j + 1);
            } else {
                throw new IllegalStateException("Invalid rotation: " + rotation);
            }
            this.inventoryCrafting.setItemStack(row, col, itemStack);
            int arrayIndex = col * 3 + row;
            this.positions[arrayIndex] = pos;
            this.providers[arrayIndex] = itemStackProvider;
        }

        @Nullable
        protected CraftingRecipe getRecipe(Level level) {
            return IModHelpers.get().getCraftingHelpers().findRecipeCached(RecipeType.CRAFTING, (RecipeInput)this.inventoryCrafting.asCraftInput(), level, true).map(RecipeHolder::value).orElse(null);
        }

        public ItemStack getOutput(Level level) {
            CraftingRecipe recipe = this.getRecipe(level);
            if (recipe != null) {
                return recipe.assemble((RecipeInput)this.inventoryCrafting.asCraftInput(), (HolderLookup.Provider)level.registryAccess());
            }
            return ItemStack.EMPTY;
        }

        public boolean handleRemainingItems(Level level, Direction inputSide, boolean simulate) {
            CraftingRecipe recipe = this.getRecipe(level);
            CraftingInput.Positioned craftInputPositioned = this.inventoryCrafting.asPositionedCraftInput();
            CraftingInput craftInput = craftInputPositioned.input();
            int left = craftInputPositioned.left();
            int top = craftInputPositioned.top();
            NonNullList remainingStacks = recipe.getRemainingItems(craftInput);
            for (int r = 0; r < 3; ++r) {
                for (int c = 0; c < 3; ++c) {
                    ItemStack remainingStack;
                    int i = r * 3 + c;
                    ItemStack originalStack = this.inventoryCrafting.getItem(i);
                    ItemStack itemStack = remainingStack = r >= top && r - top < craftInput.height() && c >= left && c - left < craftInput.width() ? (ItemStack)remainingStacks.get((r - top) * craftInput.width() + c - left) : ItemStack.EMPTY;
                    if (originalStack == null || originalStack.isEmpty()) continue;
                    if (this.providers[i] != null) {
                        boolean success = this.providers[i].reduceItemStack(level, this.positions[i], inputSide, simulate);
                        if (!success) {
                            if (!simulate) {
                                for (int j = 0; j < i; ++j) {
                                    ItemStack stackToRestore = this.inventoryCrafting.getItem(j);
                                    if (stackToRestore == null || stackToRestore.isEmpty() || this.providers[j] == null) continue;
                                    this.providers[j].addItemStack(level, this.positions[j], inputSide, stackToRestore, false);
                                }
                            }
                            return false;
                        }
                        if (remainingStack.isEmpty() || remainingStack.getCount() <= 0) continue;
                        this.providers[i].addItemStack(level, this.positions[i], inputSide, remainingStack, simulate);
                        continue;
                    }
                    ((IStructuredCraftingMod)IStructuredCraftingMod.MOD.get()).getLoggerHelper().log(org.apache.logging.log4j.Level.WARN, "The structured crafting provider for position " + i + " did not exist for stack " + String.valueOf(originalStack));
                }
            }
            return true;
        }

        public CraftingPossibility clone() {
            CraftingPossibility craftingPossibility = new CraftingPossibility();
            for (int i = 0; i < this.inventoryCrafting.getContainerSize(); ++i) {
                craftingPossibility.inventoryCrafting.setItem(i, this.inventoryCrafting.getItem(i));
            }
            System.arraycopy(this.positions, 0, craftingPossibility.positions, 0, this.positions.length);
            System.arraycopy(this.providers, 0, craftingPossibility.providers, 0, this.providers.length);
            return craftingPossibility;
        }

        public String toString() {
            return "CraftingPossibility{inventoryCrafting=" + String.valueOf((Object)this.inventoryCrafting) + ", positions=" + Arrays.toString(this.positions) + ", providers=" + Arrays.toString(this.providers) + "}";
        }
    }
}

