/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.structuredcrafting.craft;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.structuredcrafting.IStructuredCraftingMod;
import org.cyclops.structuredcrafting.block.BlockStructuredCrafter;
import org.cyclops.structuredcrafting.craft.WorldInventoryCrafting;
import org.cyclops.structuredcrafting.craft.provider.IItemStackProvider;
import org.cyclops.structuredcrafting.craft.provider.IItemStackProviderRegistry;

public class WorldCraftingMatrix {
    private final class_1937 level;
    private final class_2338 centerPos;
    private final class_2350.class_2351 axis;
    private final class_2338 targetPos;
    private final class_2350 targetSide;
    private final class_2350 inputSide;

    public WorldCraftingMatrix(class_1937 level, class_2338 centerPos, class_2350.class_2351 axis, class_2338 targetPos, class_2350 inputSide) {
        this.level = level;
        this.centerPos = centerPos;
        this.axis = axis;
        this.targetPos = targetPos;
        this.targetSide = inputSide.method_10153();
        this.inputSide = inputSide;
    }

    protected class_2338 addInAxis(class_2338 pos, class_2350.class_2351 axis, int i, int j) {
        if (axis == class_2350.class_2351.field_11048) {
            return pos.method_10069(0, j, i);
        }
        if (axis == class_2350.class_2351.field_11052) {
            return pos.method_10069(i, 0, j);
        }
        if (axis == class_2350.class_2351.field_11051) {
            return pos.method_10069(i, j, 0);
        }
        return null;
    }

    protected List<IItemStackProvider> getItemStackProviders() {
        return ((IItemStackProviderRegistry)((IStructuredCraftingMod)IStructuredCraftingMod.MOD.get()).getRegistryManager().getRegistry(IItemStackProviderRegistry.class)).getProviders();
    }

    protected Map<class_1799, IItemStackProvider> determineItemStackProviderForInput(class_1937 level, class_2338 pos, class_2350 side) {
        HashMap providers = Maps.newHashMap();
        for (IItemStackProvider provider : this.getItemStackProviders()) {
            if (!provider.canProvideInput() || !provider.hasItemStack(level, pos, side)) continue;
            providers.put(provider.getItemStack(level, pos, side), provider);
        }
        return providers;
    }

    protected boolean addItemStackForOutput(class_1937 level, class_2338 pos, class_2350 side, List<IItemStackProvider> outputProviders, class_1799 itemStack, boolean simulate) {
        for (IItemStackProvider provider : outputProviders) {
            if (!provider.canHandleOutput() || !provider.addItemStack(level, pos, side, itemStack, simulate)) continue;
            return true;
        }
        return false;
    }

    public boolean craft(boolean simulate) {
        LinkedList outputProviders = Lists.newLinkedList();
        for (IItemStackProvider provider : this.getItemStackProviders()) {
            if (!provider.isValidForResults(this.level, this.targetPos, this.targetSide)) continue;
            outputProviders.add(provider);
        }
        if (outputProviders.isEmpty()) {
            return false;
        }
        CraftingPossibility chosenPossibility = null;
        class_1799 itemStack = null;
        block1: for (int k = 0; k < 3; ++k) {
            if (chosenPossibility != null) continue;
            ArrayList possibilities = Lists.newArrayList((Object[])new CraftingPossibility[]{new CraftingPossibility()});
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    class_2338 pos = this.addInAxis(this.centerPos, this.axis, i, j);
                    Map<class_1799, IItemStackProvider> results = this.determineItemStackProviderForInput(this.level, pos, this.inputSide);
                    boolean processedSingleResult = false;
                    ArrayList possibilitiesAtStart = Lists.newArrayList((Iterable)possibilities);
                    for (Map.Entry<class_1799, IItemStackProvider> result : results.entrySet()) {
                        class_1799 itemStackInput = result.getKey();
                        if (!itemStackInput.method_7960()) {
                            itemStackInput = itemStackInput.method_7972();
                            itemStackInput.method_7939(1);
                        }
                        if (!processedSingleResult) {
                            for (CraftingPossibility possibility : possibilities) {
                                possibility.setPosition(i, j, k, pos, result.getValue(), result.getKey());
                            }
                            processedSingleResult = true;
                            continue;
                        }
                        for (CraftingPossibility possibility : possibilitiesAtStart) {
                            possibility = possibility.clone();
                            possibility.setPosition(i, j, k, pos, result.getValue(), result.getKey());
                            possibilities.add(possibility);
                        }
                    }
                    if (processedSingleResult) continue;
                    for (CraftingPossibility possibility : possibilities) {
                        possibility.setPosition(i, j, k, pos, null, class_1799.field_8037);
                    }
                }
            }
            for (CraftingPossibility possibility : possibilities) {
                itemStack = possibility.getOutput(this.level);
                if (itemStack.method_7960()) continue;
                chosenPossibility = possibility;
                continue block1;
            }
        }
        if (chosenPossibility != null && !itemStack.method_7960() && this.addItemStackForOutput(this.level, this.targetPos, this.targetSide, outputProviders, itemStack, true) && chosenPossibility.handleRemainingItems(this.level, this.inputSide, simulate)) {
            if (!simulate) {
                this.addItemStackForOutput(this.level, this.targetPos, this.targetSide, outputProviders, itemStack, simulate);
            }
            return true;
        }
        return false;
    }

    public static WorldCraftingMatrix deriveMatrix(class_1937 level, class_2338 centerPos) {
        class_2350 side = ((class_2350)level.method_8320(centerPos).method_11654(BlockStructuredCrafter.FACING)).method_10153();
        return new WorldCraftingMatrix(level, centerPos.method_10093(side), side.method_10166(), centerPos.method_10093(side.method_10153()), side.method_10153());
    }

    public static class CraftingPossibility {
        private final WorldInventoryCrafting inventoryCrafting = new WorldInventoryCrafting();
        private final class_2338[] positions = new class_2338[9];
        private final IItemStackProvider[] providers = new IItemStackProvider[9];

        public void setPosition(int i, int j, int rotation, class_2338 pos, IItemStackProvider itemStackProvider, class_1799 itemStack) {
            int col;
            int row;
            if (rotation == 0) {
                row = i + 1;
                col = j + 1;
            } else if (rotation == 1) {
                row = j + 1;
                col = i + 1;
            } else if (rotation == 2) {
                row = i + 1;
                col = 2 - (j + 1);
            } else {
                throw new IllegalStateException("Invalid rotation: " + rotation);
            }
            this.inventoryCrafting.setItemStack(row, col, itemStack);
            int arrayIndex = col * 3 + row;
            this.positions[arrayIndex] = pos;
            this.providers[arrayIndex] = itemStackProvider;
        }

        @Nullable
        protected class_3955 getRecipe(class_1937 level) {
            return IModHelpers.get().getCraftingHelpers().findRecipeCached(class_3956.field_17545, (class_9695)this.inventoryCrafting.method_59961(), level, true).map(class_8786::comp_1933).orElse(null);
        }

        public class_1799 getOutput(class_1937 level) {
            class_3955 recipe = this.getRecipe(level);
            if (recipe != null) {
                return recipe.method_8116((class_9695)this.inventoryCrafting.method_59961(), (class_7225.class_7874)level.method_30349());
            }
            return class_1799.field_8037;
        }

        public boolean handleRemainingItems(class_1937 level, class_2350 inputSide, boolean simulate) {
            class_3955 recipe = this.getRecipe(level);
            class_9694.class_9765 craftInputPositioned = this.inventoryCrafting.method_60501();
            class_9694 craftInput = craftInputPositioned.comp_2795();
            int left = craftInputPositioned.comp_2796();
            int top = craftInputPositioned.comp_2797();
            class_2371 remainingStacks = recipe.method_17704(craftInput);
            for (int r = 0; r < 3; ++r) {
                for (int c = 0; c < 3; ++c) {
                    class_1799 remainingStack;
                    int i = r * 3 + c;
                    class_1799 originalStack = this.inventoryCrafting.method_5438(i);
                    class_1799 class_17992 = remainingStack = r >= top && r - top < craftInput.method_59992() && c >= left && c - left < craftInput.method_59991() ? (class_1799)remainingStacks.get((r - top) * craftInput.method_59991() + c - left) : class_1799.field_8037;
                    if (originalStack == null || originalStack.method_7960()) continue;
                    if (this.providers[i] != null) {
                        boolean success = this.providers[i].reduceItemStack(level, this.positions[i], inputSide, simulate);
                        if (!success) {
                            if (!simulate) {
                                for (int j = 0; j < i; ++j) {
                                    class_1799 stackToRestore = this.inventoryCrafting.method_5438(j);
                                    if (stackToRestore == null || stackToRestore.method_7960() || this.providers[j] == null) continue;
                                    this.providers[j].addItemStack(level, this.positions[j], inputSide, stackToRestore, false);
                                }
                            }
                            return false;
                        }
                        if (remainingStack.method_7960() || remainingStack.method_7947() <= 0) continue;
                        this.providers[i].addItemStack(level, this.positions[i], inputSide, remainingStack, simulate);
                        continue;
                    }
                    ((IStructuredCraftingMod)IStructuredCraftingMod.MOD.get()).getLoggerHelper().log(Level.WARN, "The structured crafting provider for position " + i + " did not exist for stack " + String.valueOf(originalStack));
                }
            }
            return true;
        }

        public CraftingPossibility clone() {
            CraftingPossibility craftingPossibility = new CraftingPossibility();
            for (int i = 0; i < this.inventoryCrafting.method_5439(); ++i) {
                craftingPossibility.inventoryCrafting.method_5447(i, this.inventoryCrafting.method_5438(i));
            }
            System.arraycopy(this.positions, 0, craftingPossibility.positions, 0, this.positions.length);
            System.arraycopy(this.providers, 0, craftingPossibility.providers, 0, this.providers.length);
            return craftingPossibility;
        }

        public String toString() {
            return "CraftingPossibility{inventoryCrafting=" + String.valueOf((Object)this.inventoryCrafting) + ", positions=" + Arrays.toString(this.positions) + ", providers=" + Arrays.toString(this.providers) + "}";
        }
    }
}

