/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.structuredcrafting.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.cyclops.cyclopscore.block.BlockWithEntity;
import org.cyclops.structuredcrafting.RegistryEntries;
import org.cyclops.structuredcrafting.blockentity.BlockEntityStructuredCrafter;

public class BlockStructuredCrafter
extends BlockWithEntity {
    public static final MapCodec<BlockStructuredCrafter> CODEC = BlockBehaviour.simpleCodec(BlockStructuredCrafter::new);
    public static final EnumProperty<Direction> FACING = BlockStateProperties.FACING;

    public BlockStructuredCrafter(BlockBehaviour.Properties properties) {
        super(properties, BlockEntityStructuredCrafter::new);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.DOWN));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return level.isClientSide() ? null : BaseEntityBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)RegistryEntries.BLOCK_ENTITY_STRUCTURED_CRAFTER.value()), (BlockEntityTicker)new BlockEntityStructuredCrafter.Ticker());
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getClickedFace().getOpposite());
    }

    protected InteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack heldItem = player.getItemInHand(hand);
        if (player != null && heldItem.getItem() == Items.STICK) {
            level.setBlockAndUpdate(pos, (BlockState)blockState.setValue(FACING, (Comparable)hit.getDirection().getOpposite()));
            return InteractionResult.SUCCESS;
        }
        return super.useItemOn(itemStack, blockState, level, pos, player, hand, hit);
    }
}

