/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.structuredcrafting.craft;

import com.google.common.base.Objects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class WorldInventoryCrafting
extends TransientCraftingContainer {
    public WorldInventoryCrafting() {
        super(new AbstractContainerMenu(MenuType.CRAFTING, 0){

            public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player playerIn) {
                return false;
            }
        }, 3, 3);
    }

    public void setItemStack(int row, int col, ItemStack itemStack) {
        this.setItem(col * 3 + row, itemStack.copy());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WorldInventoryCrafting)) {
            return false;
        }
        for (int i = 0; i < this.getContainerSize(); ++i) {
            if (ItemStack.matches((ItemStack)this.getItem(i), (ItemStack)((WorldInventoryCrafting)((Object)obj)).getItem(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 11 + this.getContainerSize();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            hash <<= 1;
            hash |= WorldInventoryCrafting.getItemStackHashCode(this.getItem(i));
        }
        return hash;
    }

    public static int getItemStackHashCode(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        return Objects.hashCode((Object[])new Object[]{itemStack.getCount(), Item.getId((Item)itemStack.getItem()), itemStack.getComponents().isEmpty() ? itemStack.getComponents().hashCode() : 0});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.getContainerSize(); ++i) {
            sb.append(this.getItem(i));
            sb.append(",");
        }
        return sb.toString();
    }
}

