/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.structuredcrafting.craft.provider;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.extensions.ILevelExtension;
import net.neoforged.neoforge.transfer.ResourceHandler;
import net.neoforged.neoforge.transfer.item.ItemResource;
import net.neoforged.neoforge.transfer.resource.Resource;
import net.neoforged.neoforge.transfer.transaction.Transaction;
import net.neoforged.neoforge.transfer.transaction.TransactionContext;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.IModHelpers;
import org.cyclops.cyclopscore.helper.IModHelpersNeoForge;
import org.cyclops.structuredcrafting.block.BlockStructuredCrafterConfig;
import org.cyclops.structuredcrafting.craft.provider.IItemStackProvider;

public class InventoryItemStackProviderNeoForge
implements IItemStackProvider {
    protected Pair<Integer, ItemStack> getFirstItem(Container inventory, Direction side) {
        for (int slot = 0; slot < inventory.getContainerSize(); ++slot) {
            ItemStack itemStack = inventory.getItem(slot);
            if (itemStack.isEmpty()) continue;
            return Pair.of((Object)slot, (Object)itemStack);
        }
        return null;
    }

    protected Pair<Integer, ItemStack> getFirstItem(ResourceHandler<ItemResource> itemHandler, Direction side) {
        for (int slot = 0; slot < itemHandler.size(); ++slot) {
            try (Transaction tx = Transaction.openRoot();){
                int extracted;
                ItemResource resource = (ItemResource)itemHandler.getResource(slot);
                if (resource.isEmpty() || (extracted = itemHandler.extract(slot, (Resource)resource, 1, (TransactionContext)tx)) <= 0) continue;
                Pair pair = Pair.of((Object)slot, (Object)resource.toStack(extracted));
                return pair;
            }
        }
        return null;
    }

    @Override
    public boolean canProvideInput() {
        return BlockStructuredCrafterConfig.canTakeInputsFromInventory;
    }

    @Override
    public boolean canHandleOutput() {
        return BlockStructuredCrafterConfig.canPlaceOutputsIntoInventory;
    }

    @Override
    public boolean isValidForResults(Level world, BlockPos pos, Direction side) {
        ResourceHandler itemHandler = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, (Object)side, Capabilities.Item.BLOCK).orElse(null);
        Container inventory = IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, pos, Container.class).orElse(null);
        return itemHandler != null || inventory != null;
    }

    @Override
    public boolean hasItemStack(Level world, BlockPos pos, Direction side) {
        Container inventory = IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, pos, Container.class).orElse(null);
        ResourceHandler itemHandler = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, (Object)side, Capabilities.Item.BLOCK).orElse(null);
        return itemHandler != null || inventory != null;
    }

    @Override
    public ItemStack getItemStack(Level world, BlockPos pos, Direction side) {
        Pair<Integer, ItemStack> result;
        ResourceHandler itemHandler = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, (Object)side, Capabilities.Item.BLOCK).orElse(null);
        Container inventory = IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, pos, Container.class).orElse(null);
        Pair<Integer, ItemStack> pair = result = itemHandler != null ? this.getFirstItem((ResourceHandler<ItemResource>)itemHandler, side) : this.getFirstItem(inventory, side);
        if (result != null) {
            return (ItemStack)result.getRight();
        }
        return ItemStack.EMPTY;
    }

    @Override
    public boolean reduceItemStack(Level world, BlockPos pos, Direction side, boolean simulate) {
        ResourceHandler itemHandler = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, (Object)side, Capabilities.Item.BLOCK).orElse(null);
        if (itemHandler != null) {
            boolean extracted = false;
            for (int slot = 0; slot < itemHandler.size(); ++slot) {
                ItemResource resource = (ItemResource)itemHandler.getResource(slot);
                if (resource.isEmpty()) continue;
                try (Transaction tx = Transaction.openRoot();){
                    int extractedCount = itemHandler.extract(slot, (Resource)resource, 1, (TransactionContext)tx);
                    if (!simulate) {
                        tx.commit();
                    }
                    if (extractedCount <= 0) continue;
                    extracted = true;
                    break;
                }
            }
            return extracted;
        }
        Container inventory = IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, pos, Container.class).orElse(null);
        Pair<Integer, ItemStack> result = this.getFirstItem(inventory, side);
        ItemStack newItemStack = ((ItemStack)result.getRight()).copy();
        newItemStack.shrink(1);
        if (newItemStack.getCount() <= 0) {
            newItemStack = ItemStack.EMPTY;
        }
        if (!simulate) {
            inventory.setItem(((Integer)result.getLeft()).intValue(), newItemStack);
        }
        return true;
    }

    @Override
    public boolean addItemStack(Level world, BlockPos pos, Direction side, ItemStack itemStack, boolean simulate) {
        ResourceHandler itemHandler = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, (Object)side, Capabilities.Item.BLOCK).orElse(null);
        if (itemHandler != null) {
            for (int slot = 0; slot < itemHandler.size(); ++slot) {
                try (Transaction tx = Transaction.openRoot();){
                    int inserted = itemHandler.insert(slot, (Resource)ItemResource.of((ItemStack)itemStack), itemStack.getCount(), (TransactionContext)tx);
                    if (!simulate) {
                        tx.commit();
                    }
                    if (inserted <= 0) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        } else {
            Container inventory = IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, pos, Container.class).orElse(null);
            for (int slot = 0; slot < inventory.getContainerSize(); ++slot) {
                if (!IModHelpers.get().getInventoryHelpers().addToSlot(inventory, slot, itemStack, simulate)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setItemStack(Level world, BlockPos pos, Direction side, ItemStack itemStack, boolean simulate) {
        ResourceHandler itemHandler = IModHelpersNeoForge.get().getCapabilityHelpers().getCapability((ILevelExtension)world, pos, (Object)side, Capabilities.Item.BLOCK).orElse(null);
        if (itemHandler != null) {
            for (int slot = 0; slot < itemHandler.size(); ++slot) {
                try (Transaction tx = Transaction.openRoot();){
                    int inserted = itemHandler.insert(slot, (Resource)ItemResource.of((ItemStack)itemStack), itemStack.getCount(), (TransactionContext)tx);
                    if (!simulate) {
                        tx.commit();
                    }
                    if (inserted <= 0) continue;
                    boolean bl = true;
                    return bl;
                }
            }
        } else {
            Container inventory = IModHelpers.get().getBlockEntityHelpers().get((BlockGetter)world, pos, Container.class).orElse(null);
            Pair<Integer, ItemStack> result = this.getFirstItem(inventory, side);
            if (result != null) {
                if (!simulate) {
                    inventory.setItem(((Integer)result.getLeft()).intValue(), itemStack);
                }
                return true;
            }
        }
        return false;
    }
}

