/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.nomoon.entity;

import javax.annotation.Nullable;
import net.mcreator.nomoon.init.NoMoonModEntities;
import net.mcreator.nomoon.procedures.AloneAttackConditionsProcedure;
import net.mcreator.nomoon.procedures.AloneConditionProcedure;
import net.mcreator.nomoon.procedures.AloneHardNoAttackProcedure;
import net.mcreator.nomoon.procedures.AloneNewBoundingBoxScaleProcedure;
import net.mcreator.nomoon.procedures.AloneNewOnEntityTickUpdateProcedure;
import net.mcreator.nomoon.procedures.AloneNewOnInitialEntitySpawnProcedure;
import net.mcreator.nomoon.procedures.AloneNewPlayerCollidesWithThisEntityProcedure;
import net.mcreator.nomoon.procedures.AloneNoAgrConditionProcedure;
import net.mcreator.nomoon.procedures.AloneNoAttackConditionProcedure;
import net.mcreator.nomoon.procedures.AloneNoAttackSurfaceConditionProcedure;
import net.mcreator.nomoon.procedures.AloneSurface2ConditionProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class AloneNewEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(AloneNewEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(AloneNewEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(AloneNewEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public AloneNewEntity(EntityType<AloneNewEntity> type, Level world) {
        super(type, world);
        this.xpReward = 0;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"alone_void");
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.goalSelector.addGoal(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.4, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canUse() && AloneNoAttackSurfaceConditionProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canContinueToUse() && AloneNoAttackSurfaceConditionProcedure.execute((LevelAccessor)world);
            }
        });
        this.goalSelector.addGoal(3, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.5, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canUse() && AloneNoAttackConditionProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canContinueToUse() && AloneNoAttackConditionProcedure.execute((LevelAccessor)world);
            }
        });
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.6, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canUse() && AloneHardNoAttackProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canContinueToUse() && AloneHardNoAttackProcedure.execute((LevelAccessor)world);
            }
        });
        this.goalSelector.addGoal(5, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.5, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canUse() && AloneAttackConditionsProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canContinueToUse() && AloneAttackConditionsProcedure.execute((LevelAccessor)world);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.0, true){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < (double)(this.mob.getBbWidth() * this.mob.getBbWidth() + entity.getBbWidth()) && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canUse() && AloneSurface2ConditionProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canContinueToUse() && AloneSurface2ConditionProcedure.execute((LevelAccessor)world);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean canUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canUse() && AloneNoAgrConditionProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canContinueToUse() && AloneNoAgrConditionProcedure.execute((LevelAccessor)world);
            }
        });
        this.goalSelector.addGoal(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.4){

            public boolean canUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canUse() && AloneNoAgrConditionProcedure.execute((LevelAccessor)world);
            }

            public boolean canContinueToUse() {
                double x = AloneNewEntity.this.getX();
                double y = AloneNewEntity.this.getY();
                double z = AloneNewEntity.this.getZ();
                AloneNewEntity entity = AloneNewEntity.this;
                Level world = AloneNewEntity.this.level();
                return super.canContinueToUse() && AloneNoAgrConditionProcedure.execute((LevelAccessor)world);
            }
        });
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.hurt"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"entity.generic.death"));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (source.getDirectEntity() instanceof AbstractArrow) {
            return false;
        }
        if (source.getDirectEntity() instanceof Player) {
            return false;
        }
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud || source.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.is(DamageTypes.LIGHTNING_BOLT)) {
            return false;
        }
        if (source.is(DamageTypes.EXPLOSION) || source.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (source.is(DamageTypes.TRIDENT)) {
            return false;
        }
        if (source.is(DamageTypes.FALLING_ANVIL)) {
            return false;
        }
        if (source.is(DamageTypes.DRAGON_BREATH)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER) || source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        AloneNewPlayerCollidesWithThisEntityProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public SpawnGroupData finalizeSpawn(ServerLevelAccessor world, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData livingdata) {
        SpawnGroupData retval = super.finalizeSpawn(world, difficulty, reason, livingdata);
        AloneNewOnInitialEntitySpawnProcedure.execute((LevelAccessor)world, this.getX(), this.getY(), this.getZ(), (Entity)this);
        return retval;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
    }

    public void baseTick() {
        super.baseTick();
        AloneNewOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        AloneNewEntity entity = this;
        Level world = this.level();
        double x = this.getX();
        double y = entity.getY();
        double z = entity.getZ();
        return super.getDefaultDimensions(pose).scale((float)AloneNewBoundingBoxScaleProcedure.execute((LevelAccessor)world, x, y, z));
    }

    public void playerTouch(Player sourceentity) {
        super.playerTouch(sourceentity);
        AloneNewPlayerCollidesWithThisEntityProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
        event.register((EntityType)NoMoonModEntities.ALONE_NEW.get(), SpawnPlacementTypes.ON_GROUND, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
            int x = pos.getX();
            int y = pos.getY();
            int z = pos.getZ();
            return AloneConditionProcedure.execute((LevelAccessor)world, x, y, z);
        }, RegisterSpawnPlacementsEvent.Operation.REPLACE);
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.35);
        builder = builder.add(Attributes.MAX_HEALTH, 1000.0);
        builder = builder.add(Attributes.ARMOR, 0.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 100.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 200.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 8.0);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 10.0);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.isSprinting())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("Walk_Form_1"));
            }
            if (this.isSprinting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("Run_Form_1"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("Still_Form_1"));
        }
        return PlayState.STOP;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 5) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 4, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 4, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

