/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.mixin;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2170;
import net.minecraft.class_2960;
import net.minecraft.class_3302;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5350;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7780;
import net.minecraft.class_8786;
import net.sssubtlety.recipe_reshaper.mixin.accessor.RecipeManagerAccessor;
import net.sssubtlety.recipe_reshaper.mixin.accessor.RecipeMapAccessor;
import net.sssubtlety.recipe_reshaper.reshaper.Reshaper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_5350.class}, priority=250)
abstract class ServerReloadableResourcesMixin {
    @Unique
    private Reshaper.Data.Manager reshaperManager;
    @Shadow
    @Final
    private class_1863 field_25337;

    ServerReloadableResourcesMixin() {
    }

    @Unique
    private static class_8786<?> withTypeSuffixedId(class_8786<?> recipe) {
        class_5321 oldKey = recipe.comp_1932();
        class_2960 newId = oldKey.method_29177().method_48331("_" + String.valueOf(recipe.comp_1933().method_17716()));
        return new class_8786(class_5321.method_29179((class_5321)oldKey.method_58273(), (class_2960)newId), recipe.comp_1933());
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void initFields(class_7780<?> layeredRegistryManager, class_7225.class_7874 lookupProvider, class_7699 featureFlags, class_2170.class_5364 environment, List<?> list, int level, CallbackInfo ci) {
        this.reshaperManager = new Reshaper.Data.Manager(lookupProvider, Reshaper.Data.CODEC, "recipe_reshapers");
    }

    @ModifyReturnValue(method={"getReloaders"}, at={@At(value="RETURN")})
    private List<class_3302> addReshaperManagerPreRecipes(List<class_3302> reloaders) {
        ArrayList<class_3302> mutableReloaders = new ArrayList<class_3302>(reloaders);
        if (reloaders.get(2) == this.field_25337) {
            mutableReloaders.add(2, (class_3302)this.reshaperManager);
            return List.copyOf(mutableReloaders);
        }
        for (int i = 0; i < mutableReloaders.size(); ++i) {
            if (mutableReloaders.get(i) != this.field_25337) continue;
            mutableReloaders.add(i, (class_3302)this.reshaperManager);
            return List.copyOf(mutableReloaders);
        }
        throw new IllegalStateException("Could not find recipe manager!");
    }

    @Inject(method={"method_61248"}, at={@At(value="TAIL")})
    private void postTagUpdate(CallbackInfo ci) {
        RecipeMapAccessor accessibleRecipeMap = (RecipeMapAccessor)((RecipeManagerAccessor)this.field_25337).recipe_reshaper$getRecipes();
        accessibleRecipeMap.recipe_reshaper$getByKey().forEach((key, recipeHolder) -> this.reshaperManager.checkRecipe((class_8786<? extends class_1860<?>>)recipeHolder));
        Multimap<class_3956<?>, class_8786<?>> recipesByType = accessibleRecipeMap.recipe_reshaper$getByType();
        HashMap<class_5321, Object> recipesById = new HashMap<class_5321, Object>((int)((double)recipesByType.size() * 1.5));
        for (Map.Entry entry : recipesByType.asMap().entrySet()) {
            class_3956 type = (class_3956)entry.getKey();
            Collection recipes = (Collection)entry.getValue();
            Iterable<class_8786<?>> newRecipes = this.reshaperManager.generateAndRemoveRecipes(type, recipes);
            for (class_8786<?> newRecipe : newRecipes) {
                class_5321 recipeKey = newRecipe.comp_1932();
                if (recipesById.containsKey(recipeKey)) {
                    class_8786 conflict = (class_8786)recipesById.remove(recipeKey);
                    class_8786<?> uniqueConflictRecipe = ServerReloadableResourcesMixin.withTypeSuffixedId(conflict);
                    recipesById.put(uniqueConflictRecipe.comp_1932(), uniqueConflictRecipe);
                    class_8786<?> uniqueNewRecipe = ServerReloadableResourcesMixin.withTypeSuffixedId(newRecipe);
                    recipesById.put(uniqueNewRecipe.comp_1932(), uniqueNewRecipe);
                    continue;
                }
                recipesById.put(recipeKey, newRecipe);
            }
        }
        ImmutableMultimap.Builder recipesByTypeBuilder = ImmutableMultimap.builder();
        recipesById.forEach((id, recipe) -> recipesByTypeBuilder.put((Object)recipe.comp_1933().method_17716(), recipe));
        accessibleRecipeMap.recipe_reshaper$setByType((Multimap<class_3956<?>, class_8786<?>>)recipesByTypeBuilder.build());
        accessibleRecipeMap.recipe_reshaper$setByKey((Map<class_5321<class_1860<?>>, class_8786<?>>)ImmutableMap.copyOf(recipesById));
    }
}

