/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_3956;
import net.minecraft.class_4309;
import net.minecraft.class_5699;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import net.minecraft.class_8786;
import net.sssubtlety.recipe_reshaper.RecipeReshaper;
import net.sssubtlety.recipe_reshaper.reshaper.ResultFamily;
import net.sssubtlety.recipe_reshaper.reshaper.SourceFamily;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.IngredientMapping;
import net.sssubtlety.recipe_reshaper.util.CodecUtil;
import net.sssubtlety.recipe_reshaper.util.StringUtil;
import org.jetbrains.annotations.Nullable;

public final class Reshaper {
    public static final char EMPTY_TOKEN = ' ';
    public static final String EMPTY_TOKEN_STRING = String.valueOf(' ');
    public final class_2960 id;
    private final SourceFamily sourceFamily;
    @Nullable
    private final ResultFamily resultFamily;

    private Reshaper(class_2960 id, SourceFamily sourceFamily, @Nullable ResultFamily resultFamily) {
        this.id = id;
        this.sourceFamily = sourceFamily;
        this.resultFamily = resultFamily;
    }

    void check(class_8786<? extends class_1860<?>> recipe) {
        this.sourceFamily.check(recipe);
    }

    public Pair<Map<class_2960, class_8786<?>>, List<class_2960>> generateRecipesAndRemovals() {
        List<IngredientMapping<?>> ingredientMaps = this.sourceFamily.getMergedMappings();
        HashMap recipesById = new HashMap();
        List idsToRemove = this.sourceFamily.streamIdsToAlwaysRemove().collect(Collectors.toCollection(LinkedList::new));
        if (this.resultFamily != null) {
            Pair<Map<class_2960, class_8786<?>>, List<class_2960>> recipesAndRemovals = this.resultFamily.generateRecipesAndRemovals(ingredientMaps, this.id);
            recipesById.putAll((Map)recipesAndRemovals.getFirst());
            idsToRemove.addAll((Collection)recipesAndRemovals.getSecond());
        }
        this.sourceFamily.clearMappings();
        return new Pair(recipesById, (Object)idsToRemove);
    }

    public class_3956<?> getType() {
        return class_3956.field_17545;
    }

    public static interface Keys {
        public static final String ID_SUBSTRINGS = "id_substrings";
        public static final String COMMON_INGREDIENTS = "common_ingredients";
        public static final String SOURCE_FAMILY = "source_family";
        public static final String RESULT_FAMILY = "result_family";
    }

    public record Data(ImmutableMap<Character, class_1856> commonIngredients, ImmutableMap<Character, String> idSubstrings, SourceFamily.Data sourceFamilyData, Optional<ResultFamily.Data> resultFamilyData) {
        private static final Codec<ImmutableMap<Character, class_1856>> COMMON_INGREDIENTS_CODEC = class_5699.method_53703(CodecUtil.TOKEN_CODEC, (Codec)class_1856.field_46095).xmap(ImmutableMap::copyOf, Function.identity());
        private static final Codec<ImmutableMap<Character, String>> ID_SUBSTRINGS_CODEC = class_5699.method_53703(CodecUtil.TOKEN_CODEC, (Codec)class_5699.field_41759).xmap(ImmutableMap::copyOf, Function.identity());
        public static final Codec<Data> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)COMMON_INGREDIENTS_CODEC.optionalFieldOf("common_ingredients", (Object)ImmutableMap.of()).forGetter(Data::commonIngredients), (App)ID_SUBSTRINGS_CODEC.optionalFieldOf("id_substrings", (Object)ImmutableMap.of()).forGetter(Data::idSubstrings), (App)SourceFamily.Data.CODEC.fieldOf("source_family").forGetter(Data::sourceFamilyData), (App)ResultFamily.Data.CODEC.optionalFieldOf("result_family").forGetter(Data::resultFamilyData)).apply((Applicative)instance, Data::new)).codec();

        public DataResult<Reshaper> assemble(class_2960 id) {
            return this.sourceFamilyData.assemble(this.commonIngredients, this.idSubstrings).flatMap(sourceFamily -> this.resultFamilyData.map(data -> data.assemble(sourceFamily.tokens, this.commonIngredients).map(resultFamily -> new Reshaper(id, (SourceFamily)sourceFamily, (ResultFamily)resultFamily))).orElseGet(() -> DataResult.success((Object)new Reshaper(id, (SourceFamily)sourceFamily, null))));
        }

        public static final class Manager
        extends class_4309<Data> {
            public static final String TYPE = "recipe_reshapers";
            private ImmutableMultimap<class_3956<?>, Reshaper> reshapersByType;

            public Manager(class_7225.class_7874 provider, Codec<Data> codec, String dataType) {
                super((DynamicOps)provider.method_57093((DynamicOps)JsonOps.INSTANCE), codec, class_7654.method_45114((String)dataType));
            }

            protected void apply(Map<class_2960, Data> cache, class_3300 manager, class_3695 profiler) {
                ImmutableMultimap.Builder reshapersByTypeBuilder = ImmutableMultimap.builder();
                cache.entrySet().stream().flatMap(entry -> {
                    class_2960 id = (class_2960)entry.getKey();
                    return ((Data)entry.getValue()).assemble(id).ifError(error -> RecipeReshaper.LOGGER.error("Error(s) in reshaper \"{}\":\n{}", (Object)id, (Object)StringUtil.tabIndent(error.message()))).resultOrPartial().stream();
                }).forEach(reshaper -> reshapersByTypeBuilder.put(reshaper.getType(), reshaper));
                this.reshapersByType = reshapersByTypeBuilder.build();
            }

            public void checkRecipe(class_8786<? extends class_1860<?>> recipe) {
                this.reshapersByType.get((Object)recipe.comp_1933().method_17716()).forEach(reshaper -> reshaper.check(recipe));
            }

            public Iterable<class_8786<?>> generateAndRemoveRecipes(class_3956<?> type, Collection<class_8786<?>> recipes) {
                Map recipesById = recipes.stream().collect(Collectors.toMap(recipe -> recipe.comp_1932().method_29177(), Function.identity(), (left, right) -> {
                    throw new IllegalStateException("Recipe holders have same id:\n\t%s\n\t%s".formatted(left, right));
                }, HashMap::new));
                LinkedList idsToRemove = new LinkedList();
                this.reshapersByType.get(type).stream().map(Reshaper::generateRecipesAndRemovals).forEach(recipeMapAndIds2Remove -> {
                    recipesById.putAll((Map)recipeMapAndIds2Remove.getFirst());
                    idsToRemove.addAll((Collection)recipeMapAndIds2Remove.getSecond());
                });
                idsToRemove.forEach(recipesById::remove);
                return recipesById.values();
            }
        }
    }
}

