/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.IngredientMapping;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.result.ResultPattern;
import net.sssubtlety.recipe_reshaper.util.StringUtil;

public final class ResultFamily {
    private final ImmutableList<ResultPattern<?>> patterns;

    private ResultFamily(ImmutableList<ResultPattern<?>> patterns) {
        this.patterns = patterns;
    }

    public Pair<Map<class_2960, class_8786<?>>, List<class_2960>> generateRecipesAndRemovals(List<IngredientMapping<?>> ingredientMaps, class_2960 reshaperId) {
        HashMap recipesById = new HashMap();
        LinkedList idsToRemove = new LinkedList();
        for (ResultPattern pattern : this.patterns) {
            Pair<Map<class_2960, class_8786<?>>, List<class_2960>> recipesAndRemovals = pattern.generateRecipesAndRemovals(ingredientMaps, reshaperId);
            recipesById.putAll((Map)recipesAndRemovals.getFirst());
            idsToRemove.addAll((Collection)recipesAndRemovals.getSecond());
        }
        return new Pair(recipesById, idsToRemove);
    }

    public record Data(ImmutableList<ResultPattern.Assembler> assemblers) {
        public static final Codec<Data> CODEC = ResultPattern.Assembler.CODEC.codec().listOf().xmap(ImmutableList::copyOf, Function.identity()).xmap(Data::new, Data::assemblers);

        public DataResult<ResultFamily> assemble(ImmutableSet<Character> tokens, ImmutableMap<Character, class_1856> commonIngredients) {
            ImmutableList.Builder patterns = ImmutableList.builder();
            LinkedList errors = new LinkedList();
            for (ResultPattern.Assembler assembler : this.assemblers) {
                assembler.assemble((Set<Character>)tokens, commonIngredients).ifError(error -> errors.add(error.message())).resultOrPartial().ifPresent(arg_0 -> ((ImmutableList.Builder)patterns).add(arg_0));
            }
            if (errors.isEmpty()) {
                return DataResult.success((Object)new ResultFamily(patterns.build()));
            }
            return DataResult.error(() -> StringUtil.lineJoin(errors));
        }
    }
}

