/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.IngredientMapping;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.source.SourcePattern;
import net.sssubtlety.recipe_reshaper.util.StringUtil;

public final class SourceFamily {
    public final ImmutableList<SourcePattern> sourcePatterns;
    public final ImmutableSet<Character> tokens;
    private List<IngredientMapping<?>> ingredientMappings = new LinkedList();

    private SourceFamily(ImmutableList<SourcePattern> sourcePatterns, ImmutableSet<Character> tokens) {
        this.sourcePatterns = sourcePatterns;
        this.tokens = tokens;
    }

    private static ImmutableMap<Character, Pair<String, Boolean>> makeSubstringMapWithNegations(Map<Character, String> tokenIdSubstringMap) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        tokenIdSubstringMap.forEach((key, string) -> {
            boolean negated = string.startsWith("!");
            if (negated) {
                string = string.substring(1);
            }
            mapBuilder.put(key, (Object)new Pair(string, (Object)negated));
        });
        return mapBuilder.build();
    }

    public void check(class_8786<? extends class_1860<?>> recipe) {
        for (SourcePattern pattern : this.sourcePatterns) {
            pattern.generateIngredientMapping(recipe, this.tokens).ifPresent(this.ingredientMappings::add);
        }
    }

    public List<IngredientMapping<?>> getMergedMappings() {
        this.ingredientMappings = IngredientMapping.mergeMappings(this.ingredientMappings);
        return this.ingredientMappings;
    }

    public Stream<class_2960> streamIdsToAlwaysRemove() {
        return this.sourcePatterns.stream().flatMap(SourcePattern::streamIdsToAlwaysRemove);
    }

    void clearMappings() {
        this.ingredientMappings.clear();
    }

    public record Data(ImmutableList<SourcePattern.Assembler> assemblers) {
        public static final Codec<Data> CODEC = SourcePattern.Assembler.CODEC.codec().listOf().xmap(ImmutableList::copyOf, Function.identity()).xmap(Data::new, Data::assemblers);

        public DataResult<SourceFamily> assemble(ImmutableMap<Character, class_1856> commonIngredients, ImmutableMap<Character, String> idSubstringMap) {
            ImmutableList.Builder patterns = ImmutableList.builder();
            HashSet<Character> tokens = new HashSet<Character>();
            LinkedList errors = new LinkedList();
            for (SourcePattern.Assembler assembler : this.assemblers) {
                assembler.assemble(tokens, commonIngredients, idSubstringMap == null ? ImmutableMap.of() : SourceFamily.makeSubstringMapWithNegations(idSubstringMap)).ifError(error -> errors.add(error.message())).resultOrPartial().ifPresent(arg_0 -> ((ImmutableList.Builder)patterns).add(arg_0));
            }
            if (errors.isEmpty()) {
                return DataResult.success((Object)new SourceFamily((ImmutableList<SourcePattern>)patterns.build(), (ImmutableSet<Character>)ImmutableSet.copyOf(tokens)));
            }
            return DataResult.error(() -> StringUtil.lineJoin(errors));
        }
    }
}

