/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper.mapping;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.class_2960;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.OrderedMapping;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.UnorderedMapping;
import net.sssubtlety.recipe_reshaper.util.Emptyable;
import net.sssubtlety.recipe_reshaper.util.IngredientConvertible;
import org.apache.commons.lang3.mutable.MutableObject;

public abstract sealed class IngredientMapping<I extends IngredientConvertible>
permits OrderedMapping, UnorderedMapping {
    protected final TokenMap<I> ingredientPossibilities;
    protected final Set<class_2960> sourcesToRemove;

    public IngredientMapping(ImmutableSet<Character> tokens) {
        if (tokens.contains((Object)Character.valueOf(' '))) {
            throw new IllegalArgumentException("IngredientMapping received empty token ' ' (space)");
        }
        this.ingredientPossibilities = new TokenMap(tokens);
        this.sourcesToRemove = new LinkedHashSet<class_2960>();
    }

    public IngredientMapping(ImmutableSet<Character> tokens, Collection<class_2960> sourcesToRemove) {
        this(tokens);
        this.sourcesToRemove.addAll(sourcesToRemove);
    }

    public IngredientMapping(ImmutableSet<Character> tokens, class_2960 sourceToRemove) {
        this(tokens);
        this.sourcesToRemove.add(sourceToRemove);
    }

    public IngredientMapping(IngredientMapping<I> ingredientMapping) {
        this.ingredientPossibilities = TokenMap.copyOf(ingredientMapping.ingredientPossibilities);
        this.sourcesToRemove = new LinkedHashSet<class_2960>(ingredientMapping.sourcesToRemove);
    }

    public Stream<class_2960> streamSourcesToRemove() {
        return this.sourcesToRemove.stream();
    }

    public static List<IngredientMapping<?>> mergeMappings(List<IngredientMapping<?>> mappings) {
        LinkedList mergedMappings = new LinkedList();
        int mappingsSize = mappings.size();
        for (int i = 0; i < mappingsSize; ++i) {
            IngredientMapping<?> iMapping = mappings.get(i);
            if (iMapping == null) continue;
            for (int j = i + 1; j < mappingsSize; ++j) {
                Optional<IngredientMapping<?>> mergedMapping;
                IngredientMapping<?> jMapping = mappings.get(j);
                if (jMapping == null || !(mergedMapping = iMapping.tryMerge(jMapping)).isPresent()) continue;
                iMapping = mergedMapping.get();
                mappings.set(j, null);
            }
            mergedMappings.add(iMapping);
        }
        return mergedMappings;
    }

    protected abstract Optional<? extends IngredientMapping<?>> tryMerge(IngredientMapping<?> var1);

    public final Optional<Emptyable<I>> get(char token) {
        if (token == ' ') {
            return Optional.of(Emptyable.empty());
        }
        Optional<I> ingredient = this.getImpl(token);
        if (ingredient.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Emptyable.of(ingredient));
    }

    protected abstract Optional<I> getImpl(char var1);

    protected abstract IngredientMapping<I> copy();

    protected final Optional<IngredientMapping<I>> tryMergeImpl(IngredientMapping<I> other) {
        IngredientMapping<IngredientConvertible> thisCopy = this.copy();
        for (Character token : this.ingredientPossibilities.getTokens()) {
            Optional<I> ours = thisCopy.ingredientPossibilities.get(token.charValue());
            boolean thisMapped = ours.isPresent();
            Optional<I> theirs = other.ingredientPossibilities.get(token.charValue());
            boolean otherMapped = theirs.isPresent();
            if (thisMapped && otherMapped) {
                Optional<IngredientConvertible> merged = this.mergeIngredients((IngredientConvertible)ours.orElseThrow(), (IngredientConvertible)theirs.orElseThrow());
                if (merged.isPresent()) {
                    thisCopy.put(token.charValue(), merged.get(), other.sourcesToRemove);
                    continue;
                }
                return Optional.empty();
            }
            if (!otherMapped) continue;
            thisCopy.put(token.charValue(), (IngredientConvertible)theirs.orElseThrow(), other.sourcesToRemove);
        }
        return Optional.of(thisCopy);
    }

    private void put(char token, I ingredient, Collection<class_2960> sourcesToRemove) {
        this.ingredientPossibilities.put(token, ingredient);
        this.sourcesToRemove.addAll(sourcesToRemove);
    }

    protected abstract Optional<I> mergeIngredients(I var1, I var2);

    public final boolean put(Character token, I ingredient) {
        Optional<I> current = this.ingredientPossibilities.get(token.charValue());
        if (current.isPresent()) {
            Optional<IngredientConvertible> merged = this.mergeIngredients((IngredientConvertible)current.orElseThrow(), ingredient);
            if (merged.isPresent()) {
                this.ingredientPossibilities.put(token.charValue(), merged.orElseThrow());
                return true;
            }
            return false;
        }
        this.ingredientPossibilities.put(token.charValue(), ingredient);
        return true;
    }

    protected static final class TokenMap<I> {
        private final ImmutableMap<Character, MutableObject<I>> delegate;

        public static <I> TokenMap<I> copyOf(TokenMap<I> map) {
            return new TokenMap<I>((ImmutableMap)map.delegate.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> new MutableObject(((MutableObject)entry.getValue()).getValue()))));
        }

        public TokenMap(ImmutableSet<Character> tokens) {
            this((ImmutableMap)tokens.stream().collect(ImmutableMap.toImmutableMap(Function.identity(), unused -> new MutableObject())));
        }

        private TokenMap(ImmutableMap<Character, MutableObject<I>> delegate) {
            this.delegate = delegate;
        }

        public ImmutableSet<Character> getTokens() {
            return this.delegate.keySet();
        }

        public Optional<I> get(char token) {
            return Optional.ofNullable(this.getMutable(token).getValue());
        }

        public void put(char token, I i) {
            MutableObject<I> value = this.getMutable(token);
            value.setValue(i);
        }

        private MutableObject<I> getMutable(char token) {
            MutableObject value = (MutableObject)this.delegate.get((Object)Character.valueOf(token));
            if (value == null) {
                throw new IllegalArgumentException("Received unrecognized token: " + token);
            }
            return value;
        }
    }
}

