/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper.mapping;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2960;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.IngredientMapping;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.OrderedMapping;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.source.SourcePattern;
import net.sssubtlety.recipe_reshaper.util.IngredientSet;
import net.sssubtlety.recipe_reshaper.util.IngredientWrapper;

public final class UnorderedMapping
extends IngredientMapping<IngredientSet> {
    public UnorderedMapping(ImmutableSet<Character> tokens) {
        super(tokens);
    }

    public UnorderedMapping(ImmutableSet<Character> tokens, class_2960 sourceId) {
        super(tokens, sourceId);
    }

    public UnorderedMapping(ImmutableSet<Character> tokens, Set<class_2960> sourcesToRemove) {
        super(tokens, sourcesToRemove);
    }

    private UnorderedMapping(OrderedMapping orderedMapping) {
        this(orderedMapping.ingredientPossibilities.getTokens(), orderedMapping.sourcesToRemove);
        for (Character token : orderedMapping.ingredientPossibilities.getTokens()) {
            Optional ingredient = orderedMapping.ingredientPossibilities.get(token.charValue());
            if (!ingredient.isPresent()) continue;
            this.ingredientPossibilities.put(token.charValue(), new IngredientSet(((IngredientWrapper)ingredient.orElseThrow()).asIngredient()));
        }
    }

    private UnorderedMapping(UnorderedMapping unorderedMapping) {
        super(unorderedMapping);
    }

    @Override
    protected Optional<? extends IngredientMapping<?>> tryMerge(IngredientMapping<?> other) {
        IngredientMapping<?> ingredientMapping = other;
        Objects.requireNonNull(ingredientMapping);
        IngredientMapping<?> ingredientMapping2 = ingredientMapping;
        int n = 0;
        return this.tryMergeImpl(switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UnorderedMapping.class, OrderedMapping.class}, ingredientMapping2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                UnorderedMapping unordered;
                yield unordered = (UnorderedMapping)ingredientMapping2;
            }
            case 1 -> {
                OrderedMapping ordered = (OrderedMapping)ingredientMapping2;
                yield new UnorderedMapping(ordered);
            }
        });
    }

    @Override
    protected Optional<IngredientSet> getImpl(char token) {
        return this.ingredientPossibilities.get(token);
    }

    protected UnorderedMapping copy() {
        return new UnorderedMapping(this);
    }

    @Override
    protected Optional<IngredientSet> mergeIngredients(IngredientSet ourPossibilities, IngredientSet theirPossibilities) {
        IngredientSet intersection = ourPossibilities.getIntersection(theirPossibilities);
        return intersection.isEmpty() ? Optional.empty() : Optional.of(intersection);
    }

    public boolean reduce(ImmutableMap<Character, Pair<String, Boolean>> idSubstrings) {
        for (Character token : this.ingredientPossibilities.getTokens()) {
            Pair substringAndNegate = (Pair)idSubstrings.get((Object)token);
            if (substringAndNegate == null) continue;
            String substring = (String)substringAndNegate.getFirst();
            boolean negate = (Boolean)substringAndNegate.getSecond();
            IngredientSet possibleIngredients = this.ingredientPossibilities.get(token.charValue()).orElse(null);
            if (possibleIngredients == null) continue;
            possibleIngredients.removeIf(ingredient -> SourcePattern.ingredientContainsSubstring(ingredient.asIngredient(), substring) == negate);
            if (possibleIngredients.isEmpty()) {
                return false;
            }
            boolean propagationEliminatedAnIngredient = possibleIngredients.getSingleIngredient().map(singleIngredient -> this.propagateElimination(token, (IngredientWrapper)singleIngredient)).orElse(true) == false;
            if (!propagationEliminatedAnIngredient) continue;
            return false;
        }
        return true;
    }

    private boolean propagateElimination(Character determinedToken, IngredientWrapper determinedIngredient) {
        LinkedList<DeterminedIngredient> determinations = new LinkedList<DeterminedIngredient>();
        determinations.add(new DeterminedIngredient(determinedToken.charValue(), determinedIngredient));
        while (!determinations.isEmpty()) {
            DeterminedIngredient determined = (DeterminedIngredient)determinations.remove();
            for (Character token : this.ingredientPossibilities.getTokens()) {
                IngredientSet possibleIngredients;
                if (token.charValue() == determined.token || (possibleIngredients = (IngredientSet)this.ingredientPossibilities.get(token.charValue()).orElse(null)) == null || !possibleIngredients.remove(determined.ingredient)) continue;
                if (possibleIngredients.isEmpty()) {
                    return false;
                }
                possibleIngredients.getSingleIngredient().ifPresent(singleIngredient -> determinations.add(new DeterminedIngredient(token.charValue(), (IngredientWrapper)singleIngredient)));
            }
        }
        return true;
    }

    private record DeterminedIngredient(char token, IngredientWrapper ingredient) {
    }
}

