/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper.pattern;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1856;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.RecipePattern;
import net.sssubtlety.recipe_reshaper.util.CodecUtil;

public abstract class AbstractRecipePattern
implements RecipePattern {
    public final Character outputToken;
    public final int outputCount;
    public final ImmutableMap<Character, class_1856> commonIngredients;

    public AbstractRecipePattern(Character outputToken, int outputCount, ImmutableMap<Character, class_1856> commonIngredients) {
        if (outputToken.charValue() == ' ') {
            throw new IllegalArgumentException("Cannot use empty token ' ' (space) as output token");
        }
        if (outputCount < 1) {
            throw new IllegalArgumentException("Invalid output count: " + outputCount + ", must be at least 1");
        }
        this.outputToken = outputToken;
        this.outputCount = outputCount;
        this.commonIngredients = commonIngredients == null ? ImmutableMap.of() : commonIngredients;
    }

    @Override
    public Character getOutputToken() {
        return this.outputToken;
    }

    @Override
    public ImmutableMap<Character, class_1856> getCommonIngredients() {
        return this.commonIngredients;
    }

    public static interface Keys {
        public static final String OUTPUT_TOKEN = "output_token";
        public static final String OUTPUT_COUNT = "output_count";
        public static final String PATTERN = "pattern";
    }

    public record CommonData(char outputToken, Integer outputCount) {
        private static final MapCodec<Character> OUTPUT_TOKEN_CODEC = CodecUtil.TOKEN_CODEC.fieldOf("output_token");

        public static MapCodec<CommonData> codecOf(Codec<Integer> outputCountBaseCodec) {
            return RecordCodecBuilder.mapCodec(instance -> instance.group((App)OUTPUT_TOKEN_CODEC.forGetter(CommonData::outputToken), (App)outputCountBaseCodec.fieldOf("output_count").forGetter(CommonData::outputCount)).apply((Applicative)instance, CommonData::new));
        }

        public static Optional<String> crossReferenceTokenSet(Set<Character> tokenSet, boolean expandSet, char token) {
            if (expandSet) {
                tokenSet.add(Character.valueOf(token));
            } else if (!tokenSet.contains(Character.valueOf(token))) {
                return Optional.of("Result pattern contains token not in source patterns.");
            }
            return Optional.empty();
        }
    }
}

