/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper.pattern;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.LinkedList;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1856;
import net.sssubtlety.recipe_reshaper.mixin.accessor.ShapedRecipePatterDataAccessor;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.AbstractRecipePattern;
import net.sssubtlety.recipe_reshaper.util.StringUtil;

public abstract class ShapedPattern
extends AbstractRecipePattern {
    protected final Character[] pattern;
    public final int width;
    public final int height;

    public ShapedPattern(Character[] pattern, Character outputToken, int outputCount, int width, int height, ImmutableMap<Character, class_1856> commonIngredients) {
        super(outputToken, outputCount, commonIngredients);
        this.height = height;
        this.width = width;
        this.pattern = pattern;
    }

    public static final class Data {
        private static final MapCodec<ImmutableList<String>> PATTERN_CODEC = ShapedRecipePatterDataAccessor.recipe_reshaper$getPATTERN_CODEC().xmap(ImmutableList::copyOf, Function.identity()).fieldOf("pattern");
        private final AbstractRecipePattern.CommonData common;
        private final ImmutableList<String> pattern;
        private final int width;
        private final int height;

        public static MapCodec<Data> codecOf(MapCodec<AbstractRecipePattern.CommonData> commonCodec) {
            return Codec.mapPair(commonCodec, PATTERN_CODEC).xmap(commonAndPattern -> new Data((AbstractRecipePattern.CommonData)commonAndPattern.getFirst(), (ImmutableList<String>)((ImmutableList)commonAndPattern.getSecond())), shaped -> new Pair((Object)shaped.common, shaped.pattern));
        }

        private Data(AbstractRecipePattern.CommonData common, ImmutableList<String> pattern) {
            this.common = common;
            this.pattern = pattern;
            this.width = ((String)pattern.getFirst()).length();
            this.height = pattern.size();
        }

        public AbstractRecipePattern.CommonData common() {
            return this.common;
        }

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public DataResult<Character[]> createFlatPattern(Set<Character> tokenSet, boolean expandSet) {
            int numIngredients = this.width * this.height;
            Character[] flatPattern = new Character[numIngredients];
            LinkedList errors = new LinkedList();
            for (int col = 0; col < this.height; ++col) {
                for (int row = 0; row < this.width; ++row) {
                    char token = ((String)this.pattern.get(col)).charAt(row);
                    if (token != ' ') {
                        AbstractRecipePattern.CommonData.crossReferenceTokenSet(tokenSet, expandSet, token).ifPresent(errors::add);
                    }
                    flatPattern[col * this.width + row] = Character.valueOf(token);
                }
            }
            AbstractRecipePattern.CommonData.crossReferenceTokenSet(tokenSet, expandSet, this.common.outputToken()).ifPresent(errors::add);
            if (errors.isEmpty()) {
                return DataResult.success((Object)flatPattern);
            }
            return DataResult.error(() -> StringUtil.lineJoin(errors));
        }
    }
}

