/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper.pattern;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.class_1856;
import net.minecraft.class_5699;
import net.sssubtlety.recipe_reshaper.reshaper.Reshaper;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.AbstractRecipePattern;
import net.sssubtlety.recipe_reshaper.util.StringUtil;

public abstract class ShapelessPattern
extends AbstractRecipePattern {
    protected final ImmutableMultimap<Integer, Character> countPattern;

    public ShapelessPattern(ImmutableMultimap<Integer, Character> countPattern, Character outputToken, int outputCount, ImmutableMap<Character, class_1856> commonIngredients) {
        super(outputToken, outputCount, commonIngredients);
        this.countPattern = countPattern;
    }

    public record Data(AbstractRecipePattern.CommonData common, String pattern) {
        public static final int MAX_PATTERN_ENTRIES = 9;
        private static final MapCodec<String> PATTERN_CODEC = class_5699.field_41759.validate(string -> {
            if (string.contains(Reshaper.EMPTY_TOKEN_STRING)) {
                return DataResult.error(() -> "Invalid pattern entry: '" + Reshaper.EMPTY_TOKEN_STRING + "' (space) is the reserved symbol for empty ingredients; shapeless recipes can't accept empty ingredients");
            }
            int patternLen = string.length();
            if (patternLen > 9) {
                return DataResult.error(() -> "Invalid pattern: too many entries (" + patternLen + "), 9 is maximum");
            }
            return DataResult.success((Object)string);
        }).fieldOf("pattern");

        public static MapCodec<Data> codecOf(MapCodec<AbstractRecipePattern.CommonData> commonCodec) {
            return Codec.mapPair(commonCodec, PATTERN_CODEC).xmap(commonAndPattern -> new Data((AbstractRecipePattern.CommonData)commonAndPattern.getFirst(), (String)commonAndPattern.getSecond()), shapeless -> new Pair((Object)shapeless.common, (Object)shapeless.pattern));
        }

        public DataResult<ImmutableMultimap<Integer, Character>> createCountPattern(Set<Character> tokenSet, boolean expandSet) {
            LinkedHashMultiset tokens = LinkedHashMultiset.create();
            LinkedList errors = new LinkedList();
            for (char token : this.pattern.toCharArray()) {
                if (token != ' ') {
                    AbstractRecipePattern.CommonData.crossReferenceTokenSet(tokenSet, expandSet, token).ifPresent(errors::add);
                }
                tokens.add((Object)Character.valueOf(token));
            }
            Set charEntries = tokens.entrySet();
            ImmutableMultimap.Builder tokenCounts = ImmutableMultimap.builder();
            for (Multiset.Entry entry : charEntries) {
                tokenCounts.put((Object)entry.getCount(), (Object)((Character)entry.getElement()));
            }
            AbstractRecipePattern.CommonData.crossReferenceTokenSet(tokenSet, expandSet, this.common.outputToken()).ifPresent(errors::add);
            if (errors.isEmpty()) {
                return DataResult.success((Object)tokenCounts.build());
            }
            return DataResult.error(() -> StringUtil.lineJoin(errors));
        }
    }
}

