/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper.pattern.result;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3955;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_7710;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.sssubtlety.recipe_reshaper.RecipeReshaper;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.IngredientMapping;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.AbstractRecipePattern;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.RecipePattern;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.result.ShapedResultPattern;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.result.ShapelessResultPattern;
import net.sssubtlety.recipe_reshaper.util.Emptyable;
import net.sssubtlety.recipe_reshaper.util.IngredientConvertible;
import net.sssubtlety.recipe_reshaper.util.IngredientUtil;
import net.sssubtlety.recipe_reshaper.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import oshi.util.Memoizer;

public sealed interface ResultPattern<R extends class_3955>
extends RecipePattern
permits ShapedResultPattern, ShapelessResultPattern {
    public static final ImmutableList<ToIntFunction<class_2960>> HEURISTICS = ImmutableList.of(id -> id.method_12836().equals("minecraft") ? 0 : 1, id -> StringUtils.countMatches((CharSequence)id.method_12832(), (CharSequence)"_"), id -> id.method_12832().endsWith("_block") ? 0 : 1, id -> id.method_12832().startsWith("block_of_") ? 0 : 1);
    public static final String PRIMARY_ITEM_MESSAGE = "primary item for ingredient that became output";

    private static DataResult<class_1792> chooseOutputImpl(class_1856 ingredient) {
        List<class_1792> matchingItems = IngredientUtil.streamItems(ingredient).toList();
        if (matchingItems.size() == 1) {
            return DataResult.success((Object)matchingItems.getFirst());
        }
        ImmutableMap candidates = (ImmutableMap)matchingItems.stream().distinct().collect(ImmutableMap.toImmutableMap(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0), Function.identity()));
        LinkedList<Map.Entry> selectedCandidates = new LinkedList<Map.Entry>();
        for (ToIntFunction heuristic : HEURISTICS) {
            int min = Integer.MAX_VALUE;
            for (Map.Entry candidate : candidates.entrySet()) {
                int result = heuristic.applyAsInt((class_2960)candidate.getKey());
                if (result > min) continue;
                if (result < min) {
                    min = result;
                    selectedCandidates.clear();
                }
                selectedCandidates.add(candidate);
            }
            if (selectedCandidates.isEmpty()) continue;
            if (selectedCandidates.size() == 1) {
                class_1792 outputItem = (class_1792)((Map.Entry)selectedCandidates.getFirst()).getValue();
                RecipeReshaper.LOGGER.info("Chose {} as {}", (Object)class_7923.field_41178.method_10221((Object)outputItem), (Object)PRIMARY_ITEM_MESSAGE);
                return DataResult.success((Object)outputItem);
            }
            candidates = ImmutableMap.copyOf(selectedCandidates);
            selectedCandidates.clear();
        }
        return DataResult.error(() -> {
            Object[] objectArray = new Object[2];
            objectArray[0] = PRIMARY_ITEM_MESSAGE;
            objectArray[1] = matchingItems.stream().map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).toList();
            return "could not infer %s; possibilities were:\n%s".formatted(objectArray);
        });
    }

    private static <I extends IngredientConvertible> Optional<Emptyable<class_1856>> getIngredient(IngredientMapping<I> ingredientMapping, ImmutableMap<Character, class_1856> commonIngredients, char key) {
        class_1856 commonIngredient = (class_1856)commonIngredients.get((Object)Character.valueOf(key));
        if (commonIngredient == null) {
            Optional<Emptyable<I>> mappedIngredient = ingredientMapping.get(key);
            if (mappedIngredient.isEmpty()) {
                return Optional.empty();
            }
            Optional<I> emptyableIngredient = mappedIngredient.orElseThrow().get();
            if (emptyableIngredient.isEmpty()) {
                return Optional.of(Emptyable.empty());
            }
            Optional<class_1856> resolvedIngredient = ((IngredientConvertible)emptyableIngredient.orElseThrow()).tryAsIngredient();
            if (resolvedIngredient.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(Emptyable.of(resolvedIngredient));
        }
        return Optional.of(Emptyable.of(commonIngredient));
    }

    public static String toDescriptiveIdSuffix(class_1799 output) {
        return "to_%s_%s".formatted(output.method_7947(), StringUtil.idPathOf(class_7923.field_41178.method_10221((Object)output.method_7909())));
    }

    default public class_2960 reshapeId(class_2960 oldId) {
        return class_2960.method_60655((String)"recipe_reshaper", (String)(oldId.method_12836() + "/" + oldId.method_12832() + this.getIdSuffix()));
    }

    public String getIdSuffix();

    public Optional<String> getGroup();

    public class_7710 getCategory();

    public int getOutputCount();

    public class_2960 getDescriptiveId(R var1);

    public Optional<class_8786<R>> tryGenerateRecipe(IngredientMapping<?> var1, class_2960 var2);

    default public Optional<class_8786<R>> tryGenerateRecipe(IngredientMapping<?> ingredientMapping, class_2960 reshaperId, RecipeFactory<R> recipeFactory, Supplier<CharSequence> representInput) {
        return this.chooseOutput(ingredientMapping, representInput, reshaperId).map(outputItem -> {
            class_1799 outputStack = new class_1799((class_1935)outputItem, this.getOutputCount());
            class_2960 outputId = class_7923.field_41178.method_10221(outputItem);
            class_2960 recipeId = this.reshapeId(outputId);
            String group = this.getGroup().orElse(outputId.method_12832());
            return new class_8786(class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)recipeId), recipeFactory.create(group, this.getCategory(), outputStack));
        });
    }

    default public Pair<Map<class_2960, class_8786<?>>, List<class_2960>> generateRecipesAndRemovals(List<? extends IngredientMapping<?>> ingredientMappings, class_2960 reshaperId) {
        HashMap recipesById = new HashMap();
        LinkedList idsToRemove = new LinkedList();
        for (IngredientMapping<?> ingredientMapping : ingredientMappings) {
            this.tryGenerateRecipe(ingredientMapping, reshaperId).ifPresent(recipeHolder -> {
                class_3955 recipe = (class_3955)recipeHolder.comp_1933();
                class_2960 id = recipeHolder.comp_1932().method_29177();
                idsToRemove.addAll(ingredientMapping.streamSourcesToRemove().toList());
                Predicate<class_2960> notDuplicate = ((Predicate<class_2960>)recipesById::containsKey).negate();
                Optional.of(id).filter(notDuplicate).or(() -> Optional.of(this.getDescriptiveId(recipe))).filter(notDuplicate).ifPresent(uniqueId -> recipesById.put(uniqueId, new class_8786(class_5321.method_29179((class_5321)class_7924.field_52178, (class_2960)uniqueId), (class_1860)recipe)));
            });
        }
        return new Pair(recipesById, idsToRemove);
    }

    default public Optional<Emptyable<class_1856>> resolveIngredient(IngredientMapping<?> ingredientMapping, char token) {
        return ResultPattern.getIngredient(ingredientMapping, this.getCommonIngredients(), token);
    }

    private Optional<class_1792> chooseOutput(IngredientMapping<?> ingredientMapping, Supplier<CharSequence> representInput, class_2960 reshaperId) {
        Supplier representIndentedInput = Memoizer.memoize(() -> StringUtil.tabIndent((CharSequence)representInput.get()));
        return ResultPattern.getIngredient(ingredientMapping, this.getCommonIngredients(), this.getOutputToken().charValue()).map(Emptyable::get).flatMap(arg_0 -> ResultPattern.lambda$chooseOutput$10(reshaperId, (Supplier)representIndentedInput, arg_0)).map(ResultPattern::chooseOutputImpl).flatMap(arg_0 -> ResultPattern.lambda$chooseOutput$12(reshaperId, (Supplier)representIndentedInput, arg_0));
    }

    private static /* synthetic */ Optional lambda$chooseOutput$12(class_2960 reshaperId, Supplier representIndentedInput, DataResult dataResult) {
        return dataResult.ifError(arg_0 -> ResultPattern.lambda$chooseOutput$11(reshaperId, (Supplier)representIndentedInput, arg_0)).resultOrPartial();
    }

    private static /* synthetic */ void lambda$chooseOutput$11(class_2960 reshaperId, Supplier representIndentedInput, DataResult.Error error) {
        RecipeReshaper.LOGGER.error("Reshaper \"{}\" failed to generate recipe for input:\n{}\n{}", new Object[]{reshaperId, representIndentedInput.get(), StringUtil.tabIndent("Cause: " + error.message())});
    }

    private static /* synthetic */ Optional lambda$chooseOutput$10(class_2960 reshaperId, Supplier representIndentedInput, Optional ingredient) {
        if (ingredient.isEmpty()) {
            RecipeReshaper.LOGGER.error("Reshaper \"{}\" generated empty output ingredient for input:\n{}", (Object)reshaperId, representIndentedInput.get());
        }
        return ingredient;
    }

    @FunctionalInterface
    public static interface RecipeFactory<R extends class_3955> {
        public R create(String var1, class_7710 var2, class_1799 var3);
    }

    public record Data(String idSuffix, Optional<String> group, class_7710 category) {
        public static final class_7710 DEFAULT_CATEGORY = class_7710.field_40251;
        private static final Codec<String> ID_SUFFIX_CODEC = class_5699.field_41759.validate(string -> class_2960.method_20208((String)string) ? DataResult.success((Object)string) : DataResult.error(() -> "Non [a-z0-9/._-] character in id_suffix"));
        public static final MapCodec<Data> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ID_SUFFIX_CODEC.fieldOf("id_suffix").forGetter(Data::idSuffix), (App)Codec.STRING.optionalFieldOf("group").forGetter(Data::group), (App)class_7710.field_40252.optionalFieldOf("category", (Object)DEFAULT_CATEGORY).forGetter(Data::category)).apply((Applicative)instance, Data::new));
        private static final Codec<Integer> OUTPUT_COUNT_CODEC = class_5699.method_48766((int)1, (int)99);
        public static final MapCodec<AbstractRecipePattern.CommonData> COMMON_CODEC = AbstractRecipePattern.CommonData.codecOf(OUTPUT_COUNT_CODEC);

        public static interface Keys {
            public static final String ID_SUFFIX = "id_suffix";
            public static final String GROUP = "group";
            public static final String CATEGORY = "category";
        }
    }

    public static sealed interface Assembler
    permits ShapedResultPattern.Data, ShapelessResultPattern.Data {
        public static final MapCodec<Assembler> CODEC = Codec.mapEither(ShapedResultPattern.Data.CODEC, ShapelessResultPattern.Data.CODEC).xmap(Either::unwrap, assembler -> {
            Assembler assembler2 = assembler;
            Objects.requireNonNull(assembler2);
            Assembler selector0$temp = assembler2;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedResultPattern.Data.class, ShapelessResultPattern.Data.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ShapedResultPattern.Data shaped = (ShapedResultPattern.Data)selector0$temp;
                    yield Either.left((Object)shaped);
                }
                case 1 -> {
                    ShapelessResultPattern.Data shapeless = (ShapelessResultPattern.Data)selector0$temp;
                    yield Either.right((Object)shapeless);
                }
            };
        });

        public DataResult<? extends ResultPattern<?>> assemble(Set<Character> var1, ImmutableMap<Character, class_1856> var2);
    }
}

