/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper.pattern.result;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1856;
import net.minecraft.class_1869;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_8786;
import net.minecraft.class_8957;
import net.sssubtlety.recipe_reshaper.mixin.accessor.ShapedRecipeAccessor;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.IngredientMapping;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.ShapedPattern;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.result.ResultPattern;
import net.sssubtlety.recipe_reshaper.util.Emptyable;
import net.sssubtlety.recipe_reshaper.util.StringUtil;
import org.jetbrains.annotations.Nullable;

public final class ShapedResultPattern
extends ShapedPattern
implements ResultPattern<class_1869> {
    private final String idSuffix;
    @Nullable
    private final String group;
    private final class_7710 category;

    private ShapedResultPattern(Character[] flatPattern, int width, int height, Character outputToken, int outputCount, ImmutableMap<Character, class_1856> commonIngredients, String idSuffix, @Nullable String group, class_7710 category) {
        super(flatPattern, outputToken, outputCount, width, height, commonIngredients);
        this.idSuffix = idSuffix;
        this.group = group;
        this.category = category;
    }

    @Override
    public String getIdSuffix() {
        return this.idSuffix;
    }

    @Override
    public Optional<String> getGroup() {
        return Optional.ofNullable(this.group);
    }

    @Override
    public class_7710 getCategory() {
        return this.category;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    @Override
    public class_2960 getDescriptiveId(class_1869 recipe) {
        return class_2960.method_60655((String)"recipe_reshaper", (String)"shaped_%sx%s_%s_%s".formatted(recipe.method_8150(), recipe.method_8158(), StringUtil.idPathOf(recipe.method_61693().stream()), ResultPattern.toDescriptiveIdSuffix(((ShapedRecipeAccessor)recipe).recipe_reshaper$getResult())));
    }

    @Override
    public Optional<class_8786<class_1869>> tryGenerateRecipe(IngredientMapping<?> ingredientMapping, class_2960 reshaperId) {
        int numIngredients = this.pattern.length;
        ArrayList<Optional<class_1856>> ingredients = new ArrayList<Optional<class_1856>>(numIngredients);
        HashMap<Character, Optional<class_1856>> resolvedPattern = new HashMap<Character, Optional<class_1856>>();
        Character[] characterArray = this.pattern;
        int n = characterArray.length;
        for (int i = 0; i < n; ++i) {
            char token = characterArray[i].charValue();
            Optional<Emptyable<class_1856>> resolvedIngredient = this.resolveIngredient(ingredientMapping, token);
            if (!resolvedIngredient.isPresent()) {
                return Optional.empty();
            }
            Optional<class_1856> ingredient = resolvedIngredient.get().get();
            ingredients.add(ingredient);
            resolvedPattern.put(Character.valueOf(token), ingredient);
        }
        return this.tryGenerateRecipe(ingredientMapping, reshaperId, (group, category, output) -> {
            class_8957 recipePattern = new class_8957(this.width, this.height, ingredients, Optional.empty());
            return new class_1869(group, category, recipePattern, output);
        }, () -> this.representInput(resolvedPattern));
    }

    private CharSequence representInput(Map<Character, Optional<class_1856>> resolvedPattern) {
        StringBuilder representation = new StringBuilder("pattern: [");
        for (int row = 0; row < this.height; ++row) {
            representation.append(StringUtil.LINE_TAB);
            for (int col = 0; col < this.width; ++col) {
                representation.append(this.pattern[row * this.width + col]);
            }
        }
        representation.append(System.lineSeparator()).append(']').append(System.lineSeparator()).append("key: {");
        resolvedPattern.forEach((token, optIngredient) -> optIngredient.ifPresent(ingredient -> representation.append(StringUtil.LINE_TAB).append('\"').append(token).append("\": ").append(StringUtil.toPrintableString(ingredient))));
        representation.append(System.lineSeparator()).append("}");
        return representation;
    }

    public record Data(ShapedPattern.Data shaped, ResultPattern.Data result) implements ResultPattern.Assembler
    {
        public static final MapCodec<Data> CODEC = Codec.mapPair(ShapedPattern.Data.codecOf(ResultPattern.Data.COMMON_CODEC), ResultPattern.Data.CODEC).xmap(shapedAndResults -> new Data((ShapedPattern.Data)shapedAndResults.getFirst(), (ResultPattern.Data)shapedAndResults.getSecond()), shapedResult -> new Pair((Object)shapedResult.shaped, (Object)shapedResult.result));

        public DataResult<ShapedResultPattern> assemble(Set<Character> tokenSet, ImmutableMap<Character, class_1856> commonIngredients) {
            return this.shaped.createFlatPattern(tokenSet, false).map(pattern -> new ShapedResultPattern((Character[])pattern, this.shaped.width(), this.shaped.height(), Character.valueOf(this.shaped.common().outputToken()), this.shaped.common().outputCount(), commonIngredients, this.result.idSuffix(), this.result.group().orElse(null), this.result.category()));
        }
    }
}

