/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper.pattern.result;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1856;
import net.minecraft.class_1867;
import net.minecraft.class_2960;
import net.minecraft.class_7710;
import net.minecraft.class_8786;
import net.sssubtlety.recipe_reshaper.mixin.accessor.ShapelessRecipeAccessor;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.IngredientMapping;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.ShapelessPattern;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.result.ResultPattern;
import net.sssubtlety.recipe_reshaper.util.Emptyable;
import net.sssubtlety.recipe_reshaper.util.StringUtil;
import org.jetbrains.annotations.Nullable;

public final class ShapelessResultPattern
extends ShapelessPattern
implements ResultPattern<class_1867> {
    private final String idSuffix;
    @Nullable
    private final String group;
    private final class_7710 category;

    private static CharSequence representInput(List<Pair<class_1856, Integer>> ingredientCounts) {
        return ingredientCounts.stream().map(ingredientCount -> "%sx %s".formatted(ingredientCount.getSecond(), StringUtil.toPrintableString((class_1856)ingredientCount.getFirst()))).collect(Collectors.joining(System.lineSeparator()));
    }

    private static Stream<Optional<class_1856>> streamIngredients(class_1867 recipe) {
        return ((ShapelessRecipeAccessor)recipe).recipe_reshaper$getIngredients().stream().map(Optional::of);
    }

    public ShapelessResultPattern(ImmutableMultimap<Integer, Character> countPattern, Character outputToken, int outputCount, ImmutableMap<Character, class_1856> commonIngredients, String idSuffix, @Nullable String group, class_7710 category) {
        super(countPattern, outputToken, outputCount, commonIngredients);
        this.idSuffix = idSuffix;
        this.group = group;
        this.category = category;
    }

    @Override
    public String getIdSuffix() {
        return this.idSuffix;
    }

    @Override
    public class_2960 getDescriptiveId(class_1867 recipe) {
        return class_2960.method_60655((String)"recipe_reshaper", (String)"shapeless_%s_%s".formatted(StringUtil.idPathOf(ShapelessResultPattern.streamIngredients(recipe)), ResultPattern.toDescriptiveIdSuffix(((ShapelessRecipeAccessor)recipe).recipe_reshaper$getResult())));
    }

    @Override
    public Optional<String> getGroup() {
        return Optional.ofNullable(this.group);
    }

    @Override
    public class_7710 getCategory() {
        return this.category;
    }

    @Override
    public int getOutputCount() {
        return this.outputCount;
    }

    @Override
    public Optional<class_8786<class_1867>> tryGenerateRecipe(IngredientMapping<?> ingredientMapping, class_2960 reshaperId) {
        ArrayList<Pair> ingredientCounts = new ArrayList<Pair>();
        for (Map.Entry entry2 : this.countPattern.entries()) {
            int count = (Integer)entry2.getKey();
            char token = ((Character)entry2.getValue()).charValue();
            Optional resolvedIngredient = this.resolveIngredient(ingredientMapping, token).map(Emptyable::get).flatMap(Function.identity());
            if (resolvedIngredient.isPresent()) {
                ingredientCounts.add(new Pair((Object)((class_1856)resolvedIngredient.get()), (Object)count));
                continue;
            }
            return Optional.empty();
        }
        List ingredients = ingredientCounts.stream().flatMap(entry -> {
            class_1856 ingredient = (class_1856)entry.getFirst();
            int count = (Integer)entry.getSecond();
            return Stream.generate(() -> ingredient).limit(count);
        }).toList();
        return this.tryGenerateRecipe(ingredientMapping, reshaperId, (group, category, output) -> new class_1867(group, category, output, ingredients), () -> ShapelessResultPattern.representInput(ingredientCounts));
    }

    public record Data(ShapelessPattern.Data shapeless, ResultPattern.Data result) implements ResultPattern.Assembler
    {
        public static final MapCodec<Data> CODEC = Codec.mapPair(ShapelessPattern.Data.codecOf(ResultPattern.Data.COMMON_CODEC), ResultPattern.Data.CODEC).xmap(shapelessAndResult -> new Data((ShapelessPattern.Data)shapelessAndResult.getFirst(), (ResultPattern.Data)shapelessAndResult.getSecond()), shapelessResult -> new Pair((Object)shapelessResult.shapeless, (Object)shapelessResult.result));

        public DataResult<ShapelessResultPattern> assemble(Set<Character> tokenSet, ImmutableMap<Character, class_1856> commonIngredients) {
            return this.shapeless.createCountPattern(tokenSet, false).map(flatPattern -> new ShapelessResultPattern((ImmutableMultimap<Integer, Character>)flatPattern, Character.valueOf(this.shapeless.common().outputToken()), this.shapeless.common().outputCount(), commonIngredients, this.result.idSuffix(), this.result.group().orElse(null), this.result.category()));
        }
    }
}

