/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper.pattern.source;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.sssubtlety.recipe_reshaper.mixin.accessor.ShapedRecipeAccessor;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.OrderedMapping;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.ShapedPattern;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.source.SourcePattern;
import net.sssubtlety.recipe_reshaper.util.IngredientUtil;
import net.sssubtlety.recipe_reshaper.util.IngredientWrapper;

public final class ShapedSourcePattern
extends ShapedPattern
implements SourcePattern {
    private final SourcePattern.RemovalBehavior removalBehavior;
    private final List<class_2960> idsToAlwaysRemove;
    private final ImmutableMap<Character, Pair<String, Boolean>> idSubstrings;

    private ShapedSourcePattern(Character[] pattern, Character outputToken, int outputCount, int width, int height, SourcePattern.RemovalBehavior removalBehavior, ImmutableMap<Character, class_1856> commonIngredients, ImmutableMap<Character, Pair<String, Boolean>> idSubstrings) {
        super(pattern, outputToken, outputCount, width, height, commonIngredients);
        this.removalBehavior = removalBehavior;
        this.idSubstrings = idSubstrings;
        this.idsToAlwaysRemove = new LinkedList<class_2960>();
    }

    @Override
    public ImmutableMap<Character, Pair<String, Boolean>> getIdSubstrings() {
        return this.idSubstrings;
    }

    public Optional<OrderedMapping> generateIngredientMapping(class_8786<? extends class_1860<?>> recipe, ImmutableSet<Character> tokens) {
        class_1860 class_18602 = recipe.comp_1933();
        if (!(class_18602 instanceof class_1869)) {
            return Optional.empty();
        }
        class_1869 shapedRecipe = (class_1869)class_18602;
        class_1799 result = ((ShapedRecipeAccessor)shapedRecipe).recipe_reshaper$getResult();
        if (this.outputCount > 0 && result.method_7947() != this.outputCount) {
            return Optional.empty();
        }
        if (shapedRecipe.method_8150() != this.width || shapedRecipe.method_8158() != this.height) {
            return Optional.empty();
        }
        class_2960 recipeId = recipe.comp_1932().method_29177();
        OrderedMapping ingredientMapping = this.removalBehavior() == SourcePattern.RemovalBehavior.NORMAL ? new OrderedMapping(tokens, recipeId) : new OrderedMapping(tokens);
        List ingredients = shapedRecipe.method_61693();
        for (int i = 0; i < this.pattern.length; ++i) {
            boolean emptyToken;
            Optional optIngredient = (Optional)ingredients.get(i);
            char token = this.pattern[i].charValue();
            boolean emptyIngredient = optIngredient.isEmpty();
            boolean bl = emptyToken = token == ' ';
            if (emptyIngredient == emptyToken) {
                if (emptyIngredient) continue;
                class_1856 ingredient = (class_1856)optIngredient.orElseThrow();
                if (this.commonIngredients.containsKey((Object)Character.valueOf(token))) {
                    if (IngredientUtil.areEquivalent(ingredient, (class_1856)this.commonIngredients.get((Object)Character.valueOf(token)))) continue;
                    return Optional.empty();
                }
                if (!this.substringsAllow(token, ingredient)) {
                    return Optional.empty();
                }
                if (ingredientMapping.put(Character.valueOf(token), new IngredientWrapper(ingredient))) continue;
                return Optional.empty();
            }
            return Optional.empty();
        }
        if (!ingredientMapping.put(this.outputToken, new IngredientWrapper(class_1856.method_8101((class_1935)result.method_7909())))) {
            return Optional.empty();
        }
        if (this.removalBehavior() == SourcePattern.RemovalBehavior.ALWAYS) {
            this.idsToAlwaysRemove.add(recipeId);
        }
        return Optional.of(ingredientMapping);
    }

    @Override
    public Stream<class_2960> streamIdsToAlwaysRemove() {
        return this.idsToAlwaysRemove.stream();
    }

    @Override
    public SourcePattern.RemovalBehavior removalBehavior() {
        return this.removalBehavior;
    }

    public record Data(ShapedPattern.Data shaped, SourcePattern.Data source) implements SourcePattern.Assembler
    {
        public static final MapCodec<Data> CODEC = Codec.mapPair(ShapedPattern.Data.codecOf(SourcePattern.Data.COMMON_CODEC), SourcePattern.Data.CODEC).xmap(shapedAndSource -> new Data((ShapedPattern.Data)shapedAndSource.getFirst(), (SourcePattern.Data)shapedAndSource.getSecond()), shapedSource -> new Pair((Object)shapedSource.shaped, (Object)shapedSource.source));

        public DataResult<SourcePattern> assemble(Set<Character> tokenSet, ImmutableMap<Character, class_1856> commonIngredients, ImmutableMap<Character, Pair<String, Boolean>> idSubstringsByToken) {
            return this.shaped.createFlatPattern(tokenSet, true).map(flatPattern -> new ShapedSourcePattern((Character[])flatPattern, Character.valueOf(this.shaped.common().outputToken()), this.shaped.common().outputCount(), this.shaped.width(), this.shaped.height(), this.source.removalBehavior(), commonIngredients, idSubstringsByToken));
        }
    }
}

