/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper.pattern.source;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1867;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import net.sssubtlety.recipe_reshaper.mixin.accessor.ShapelessRecipeAccessor;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.UnorderedMapping;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.ShapelessPattern;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.source.SourcePattern;
import net.sssubtlety.recipe_reshaper.util.IngredientSet;
import net.sssubtlety.recipe_reshaper.util.IngredientUtil;

public final class ShapelessSourcePattern
extends ShapelessPattern
implements SourcePattern {
    private final Multiset<Integer> countOccurrences;
    private final ImmutableMap<Character, Pair<String, Boolean>> idSubstrings;
    private final SourcePattern.RemovalBehavior removalBehavior;
    private final List<class_2960> idsToAlwaysRemove;

    private ShapelessSourcePattern(ImmutableMultimap<Integer, Character> countPattern, Character outputToken, int outputCount, SourcePattern.RemovalBehavior removalBehavior, ImmutableMap<Character, class_1856> commonIngredients, ImmutableMap<Character, Pair<String, Boolean>> idSubstrings) {
        super(countPattern, outputToken, outputCount, commonIngredients);
        this.countOccurrences = this.countOccurrences((Collection<Integer>)countPattern.keys());
        this.idSubstrings = idSubstrings;
        this.removalBehavior = removalBehavior;
        this.idsToAlwaysRemove = new LinkedList<class_2960>();
    }

    private Multiset<Integer> countOccurrences(Collection<Integer> integers) {
        HashMultiset countOccurrences = HashMultiset.create();
        for (Integer integer : integers) {
            countOccurrences.add((Object)integer, 1);
        }
        return countOccurrences;
    }

    @Override
    public ImmutableMap<Character, Pair<String, Boolean>> getIdSubstrings() {
        return this.idSubstrings;
    }

    public Optional<UnorderedMapping> generateIngredientMapping(class_8786<? extends class_1860<?>> recipe, ImmutableSet<Character> tokens) {
        class_1860 class_18602 = recipe.comp_1933();
        if (!(class_18602 instanceof class_1867)) {
            return Optional.empty();
        }
        class_1867 shapelessRecipe = (class_1867)class_18602;
        if (this.outputCount > 0 && ((ShapelessRecipeAccessor)shapelessRecipe).recipe_reshaper$getResult().method_7947() != this.outputCount) {
            return Optional.empty();
        }
        List<class_1856> ingredients = ((ShapelessRecipeAccessor)shapelessRecipe).recipe_reshaper$getIngredients();
        if (this.countOccurrences.size() != ingredients.size()) {
            return Optional.empty();
        }
        HashMultiset ingredientCounts = HashMultiset.create(ingredients);
        Multiset<Integer> ingredientCountOccurrences = this.countOccurrences(ingredientCounts.entrySet().stream().map(Multiset.Entry::getCount).toList());
        if (!ingredientCountOccurrences.equals(this.countOccurrences)) {
            return Optional.empty();
        }
        HashMultimap ingredientsByCount = HashMultimap.create();
        for (Multiset.Entry entry : ingredientCounts.entrySet()) {
            ingredientsByCount.put((Object)entry.getCount(), (Object)((class_1856)entry.getElement()));
        }
        class_2960 recipeId = recipe.comp_1932().method_29177();
        UnorderedMapping unorderedMapping = this.removalBehavior() == SourcePattern.RemovalBehavior.NORMAL ? new UnorderedMapping(tokens, recipeId) : new UnorderedMapping(tokens);
        for (Integer count : this.countPattern.keySet()) {
            ImmutableCollection tokensWithCount = this.countPattern.get((Object)count);
            Collection ingredients2 = ingredientsByCount.get((Object)count);
            for (Character token : tokensWithCount) {
                if (this.commonIngredients.containsKey((Object)token)) {
                    class_1856 commonIngredient = (class_1856)this.commonIngredients.get((Object)token);
                    if (ingredients2.stream().noneMatch(ingredient -> IngredientUtil.areEquivalent(ingredient, commonIngredient))) {
                        return Optional.empty();
                    }
                }
                if (unorderedMapping.put(token, new IngredientSet(ingredients2))) continue;
                return Optional.empty();
            }
        }
        if (!unorderedMapping.put(this.outputToken, new IngredientSet(class_1856.method_8101((class_1935)((ShapelessRecipeAccessor)shapelessRecipe).recipe_reshaper$getResult().method_7909())))) {
            return Optional.empty();
        }
        if (!unorderedMapping.reduce(this.getIdSubstrings())) {
            return Optional.empty();
        }
        if (this.removalBehavior() == SourcePattern.RemovalBehavior.ALWAYS) {
            this.idsToAlwaysRemove.add(recipeId);
        }
        return Optional.of(unorderedMapping);
    }

    @Override
    public Stream<class_2960> streamIdsToAlwaysRemove() {
        return this.idsToAlwaysRemove.stream();
    }

    @Override
    public SourcePattern.RemovalBehavior removalBehavior() {
        return this.removalBehavior;
    }

    public record Data(ShapelessPattern.Data shapeless, SourcePattern.Data source) implements SourcePattern.Assembler
    {
        public static final MapCodec<Data> CODEC = Codec.mapPair(ShapelessPattern.Data.codecOf(SourcePattern.Data.COMMON_CODEC), SourcePattern.Data.CODEC).xmap(shapelessAndSource -> new Data((ShapelessPattern.Data)shapelessAndSource.getFirst(), (SourcePattern.Data)shapelessAndSource.getSecond()), shapelessSource -> new Pair((Object)shapelessSource.shapeless, (Object)shapelessSource.source));

        public DataResult<ShapelessSourcePattern> assemble(Set<Character> tokenSet, ImmutableMap<Character, class_1856> commonIngredients, ImmutableMap<Character, Pair<String, Boolean>> idSubstringsByToken) {
            return this.shapeless.createCountPattern(tokenSet, true).map(countPattern -> new ShapelessSourcePattern((ImmutableMultimap<Integer, Character>)countPattern, Character.valueOf(this.shapeless.common().outputToken()), this.shapeless.common().outputCount(), this.source.removalBehavior(), commonIngredients, idSubstringsByToken));
        }
    }
}

