/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.reshaper.pattern.source;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2960;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import net.sssubtlety.recipe_reshaper.reshaper.mapping.IngredientMapping;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.AbstractRecipePattern;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.RecipePattern;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.source.ShapedSourcePattern;
import net.sssubtlety.recipe_reshaper.reshaper.pattern.source.ShapelessSourcePattern;
import net.sssubtlety.recipe_reshaper.util.CodecUtil;
import org.jetbrains.annotations.ApiStatus;

public sealed interface SourcePattern
extends RecipePattern
permits ShapedSourcePattern, ShapelessSourcePattern {
    public static boolean ingredientContainsSubstring(class_1856 ingredient, String substring) {
        for (class_6880 item : ingredient.method_8105().toList()) {
            if (!class_7923.field_41178.method_10221((Object)((class_1792)item.comp_349())).toString().contains(substring)) continue;
            return true;
        }
        return false;
    }

    public ImmutableMap<Character, Pair<String, Boolean>> getIdSubstrings();

    public Optional<? extends IngredientMapping<?>> generateIngredientMapping(class_8786<? extends class_1860<?>> var1, ImmutableSet<Character> var2);

    default public boolean substringsAllow(char token, class_1856 ingredient) {
        Pair stringAndNegate = (Pair)this.getIdSubstrings().get((Object)Character.valueOf(token));
        if (stringAndNegate != null) {
            Boolean negate = (Boolean)stringAndNegate.getSecond();
            String subsString = (String)stringAndNegate.getFirst();
            return SourcePattern.ingredientContainsSubstring(ingredient, subsString) != negate;
        }
        return true;
    }

    public Stream<class_2960> streamIdsToAlwaysRemove();

    public RemovalBehavior removalBehavior();

    public static interface Keys {
        public static final String REMOVAL_BEHAVIOR = "removal_behavior";
        public static final String REMOVE = "remove";
        public static final String ALWAYS_REMOVE = "always_remove";
    }

    public static enum RemovalBehavior implements class_3542
    {
        NEVER((Pair<Optional<Boolean>, Optional<Boolean>>)new Pair(Optional.of(false), Optional.empty())),
        ALWAYS((Pair<Optional<Boolean>, Optional<Boolean>>)new Pair(Optional.empty(), Optional.of(true))),
        NORMAL((Pair<Optional<Boolean>, Optional<Boolean>>)new Pair(Optional.empty(), Optional.empty()));

        private static final MapCodec<RemovalBehavior> DIRECT_CODEC;
        @Deprecated(forRemoval=true)
        @ApiStatus.ScheduledForRemoval(inVersion="Minecraft 1.22")
        private static final MapCodec<RemovalBehavior> BOOL_COMBO_CODEC;
        public static final MapCodec<RemovalBehavior> CODEC;
        private final String name;
        private final Pair<Optional<Boolean>, Optional<Boolean>> boolRepresentation;

        private RemovalBehavior(Pair<Optional<Boolean>, Optional<Boolean>> boolRepresentation) {
            this.boolRepresentation = boolRepresentation;
            this.name = this.name().toLowerCase();
        }

        public String method_15434() {
            return this.name;
        }

        public Pair<Optional<Boolean>, Optional<Boolean>> getBoolRepresentation() {
            return this.boolRepresentation;
        }

        static {
            DIRECT_CODEC = class_3542.method_28140(RemovalBehavior::values).fieldOf("removal_behavior");
            BOOL_COMBO_CODEC = Codec.mapPair((MapCodec)class_3542.class_8808.BOOL.optionalFieldOf("remove"), (MapCodec)class_3542.class_8808.BOOL.optionalFieldOf("always_remove")).flatXmap(removeAndAlwaysRemove -> {
                boolean remove = ((Optional)removeAndAlwaysRemove.getFirst()).orElse(true);
                boolean alwaysRemove = ((Optional)removeAndAlwaysRemove.getSecond()).orElse(false);
                if (alwaysRemove) {
                    if (!remove) {
                        return DataResult.error(() -> "\"%s\" (%s) contradicts \"%s\" (%s)".formatted("always_remove", true, "remove", false));
                    }
                    return DataResult.success((Object)((Object)ALWAYS));
                }
                if (remove) {
                    return DataResult.success((Object)((Object)NORMAL));
                }
                return DataResult.success((Object)((Object)NEVER));
            }, CodecUtil.successOf(RemovalBehavior::getBoolRepresentation));
            CODEC = CodecUtil.withAlternative(DIRECT_CODEC, BOOL_COMBO_CODEC);
        }
    }

    public record Data(RemovalBehavior removalBehavior) {
        public static final MapCodec<Data> CODEC = RemovalBehavior.CODEC.xmap(Data::new, Data::removalBehavior);
        private static final Codec<Integer> OUTPUT_COUNT_CODEC = class_5699.method_48766((int)0, (int)99).orElse((Object)0);
        public static final MapCodec<AbstractRecipePattern.CommonData> COMMON_CODEC = AbstractRecipePattern.CommonData.codecOf(OUTPUT_COUNT_CODEC);
    }

    public static sealed interface Assembler
    permits ShapedSourcePattern.Data, ShapelessSourcePattern.Data {
        public static final MapCodec<Assembler> CODEC = Codec.mapEither(ShapedSourcePattern.Data.CODEC, ShapelessSourcePattern.Data.CODEC).xmap(Either::unwrap, assembler -> {
            Assembler assembler2 = assembler;
            Objects.requireNonNull(assembler2);
            Assembler selector0$temp = assembler2;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedSourcePattern.Data.class, ShapelessSourcePattern.Data.class}, (Object)selector0$temp, index$1)) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    ShapedSourcePattern.Data shaped = (ShapedSourcePattern.Data)selector0$temp;
                    yield Either.left((Object)shaped);
                }
                case 1 -> {
                    ShapelessSourcePattern.Data shapeless = (ShapelessSourcePattern.Data)selector0$temp;
                    yield Either.right((Object)shapeless);
                }
            };
        });

        public DataResult<? extends SourcePattern> assemble(Set<Character> var1, ImmutableMap<Character, class_1856> var2, ImmutableMap<Character, Pair<String, Boolean>> var3);
    }
}

