/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.util;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import net.minecraft.class_1856;
import net.sssubtlety.recipe_reshaper.util.IngredientConvertible;
import net.sssubtlety.recipe_reshaper.util.IngredientWrapper;

public class IngredientSet
extends LinkedHashSet<IngredientWrapper>
implements IngredientConvertible {
    public IngredientSet() {
    }

    public IngredientSet(class_1856 ingredient) {
        this();
        this.add(ingredient);
    }

    public IngredientSet(Collection<class_1856> ingredients) {
        this();
        this.addAllIngredients(ingredients);
    }

    public IngredientSet(IngredientSet ingredientSet) {
        super(ingredientSet);
    }

    @Override
    public boolean add(class_1856 ingredient) {
        return this.add(new IngredientWrapper(ingredient));
    }

    public boolean addAllIngredients(Collection<class_1856> ingredients) {
        boolean changed = false;
        for (class_1856 ingredient : ingredients) {
            changed |= this.add(ingredient);
        }
        return changed;
    }

    public IngredientSet getIntersection(IngredientSet other) {
        IngredientSet intersection = new IngredientSet(this);
        intersection.retainAll(other);
        return intersection;
    }

    @Override
    public boolean remove(Object o) {
        if (o instanceof IngredientWrapper) {
            IngredientWrapper wrappedIngredient = (IngredientWrapper)o;
            return super.remove(wrappedIngredient);
        }
        if (o instanceof class_1856) {
            class_1856 ingredient = (class_1856)o;
            return super.remove(new IngredientWrapper(ingredient));
        }
        return false;
    }

    @Override
    public Optional<class_1856> tryAsIngredient() {
        return this.getSingleIngredient().map(IngredientWrapper::asIngredient);
    }

    public Optional<IngredientWrapper> getSingleIngredient() {
        return this.size() == 1 ? Optional.of((IngredientWrapper)this.iterator().next()) : Optional.empty();
    }
}

