/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.recipe_reshaper.util;

import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.sssubtlety.recipe_reshaper.util.IngredientUtil;

public final class StringUtil {
    public static final String LINE_TAB = System.lineSeparator() + "\t";
    private static final Pattern NON_EMPTY_LINE_START = Pattern.compile("^(?=.)", 8);
    private static final String DEFAULT_ID_DELIM = String.valueOf(':');
    private static final String PATH_ID_DELIM = "..";

    private StringUtil() {
    }

    public static String toPrintableString(class_1856 ingredient) {
        return StringUtil.toString(ingredient, ", ", DEFAULT_ID_DELIM, "[", "]");
    }

    public static String toString(class_1856 ingredient, String itemDelim, String idDelim) {
        return StringUtil.toStringImpl(ingredient, idDelim, Collectors.joining(itemDelim));
    }

    public static String toString(class_1856 ingredient, String itemDelim, String idDelim, String prefix, String suffix) {
        return StringUtil.toStringImpl(ingredient, idDelim, Collectors.joining(itemDelim, prefix, suffix));
    }

    private static String toStringImpl(class_1856 ingredient, String idDelim, Collector<CharSequence, ?, String> collector) {
        return IngredientUtil.streamItems(ingredient).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10221(arg_0)).map(id -> StringUtil.toString(id, idDelim)).collect(collector);
    }

    public static String toString(class_2960 id, String delim) {
        return id.method_12836() + delim + id.method_12832();
    }

    public static String idPathOf(Stream<Optional<class_1856>> ingredients) {
        return ingredients.map(emptyableIngredient -> emptyableIngredient.map(StringUtil::idPathOf).orElse("empty")).collect(Collectors.joining("_/_"));
    }

    public static String idPathOf(class_1856 ingredient) {
        return StringUtil.toString(ingredient, "/", PATH_ID_DELIM);
    }

    public static String idPathOf(class_2960 id) {
        return StringUtil.toString(id, PATH_ID_DELIM);
    }

    public static CharSequence tabIndent(CharSequence string) {
        return NON_EMPTY_LINE_START.matcher(string).replaceAll("\t");
    }

    public static String lineJoin(List<? extends CharSequence> lines) {
        return lines.stream().collect(Collectors.joining(System.lineSeparator()));
    }
}

