/*
 * Decompiled with CFR 0.152.
 */
package vip.fubuki.thirstcanteen.common.item;

import dev.ghen.thirst.content.purity.WaterPurity;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarysurvivaloverhaul.common.capabilities.thirst.ThirstProvider;
import vip.fubuki.thirstcanteen.ThirstCanteen;
import vip.fubuki.thirstcanteen.common.item.Drinkable;
import vip.fubuki.thirstcanteen.config.ThirstCanteenConfig;

public class Canteen
extends Item
implements Drinkable {
    Supplier<Integer> usableTime;
    Supplier<ItemStack> container;
    Supplier<Integer> defaultPurity;

    public Canteen(Item.Properties properties, Supplier<Integer> usableTime, Supplier<ItemStack> container) {
        this(properties, usableTime, container, () -> 0);
    }

    public Canteen(Item.Properties properties, Supplier<Integer> usableTime, Supplier<ItemStack> container, Supplier<Integer> defaultPurity) {
        super(properties.m_41487_(1));
        this.usableTime = usableTime;
        this.defaultPurity = defaultPurity;
        this.container = container;
    }

    public int m_8105_(@NotNull ItemStack p_43001_) {
        return 32;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack p_42997_) {
        return UseAnim.DRINK;
    }

    @Override
    public int getMaxUsableTimes() {
        return this.usableTime.get();
    }

    @Override
    public int getLeftUsableTimes(ItemStack itemStack) {
        return itemStack.m_41784_().m_128451_("Contain");
    }

    public int getDefaultPurity() {
        return Math.min(this.defaultPurity.get(), 3);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack itemStack, @NotNull Level level, @NotNull LivingEntity entity) {
        Player player;
        Player player2 = player = entity instanceof Player ? (Player)entity : null;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            CriteriaTriggers.f_10592_.m_23682_(serverPlayer, itemStack);
        }
        if (ThirstCanteen.legendSurvivalOverhaulLoaded) {
            player.getCapability(ThirstProvider.THIRST_CAPABILITY).ifPresent(thirstCapability -> {
                thirstCapability.addHydrationLevel(((Number)ThirstCanteenConfig.THIRST_RESTORE_EACH_SIP.get()).intValue());
                thirstCapability.addSaturationLevel((float)((Number)ThirstCanteenConfig.QUENCHED_RESTORE_EACH_SIP.get()).intValue());
            });
        }
        itemStack.m_41784_().m_128405_("Contain", Math.max(0, this.getLeftUsableTimes(itemStack) - 1));
        int times = this.getLeftUsableTimes(itemStack);
        if (player != null) {
            player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (times == 0 && !player.m_150110_().f_35937_) {
                ItemStack containerStack = new ItemStack((ItemLike)this.container.get().m_41720_());
                if (containerStack.m_41619_() || !player.m_150109_().m_36054_(containerStack)) {
                    player.m_36176_(containerStack, false);
                }
                itemStack.m_41774_(1);
                return itemStack;
            }
        }
        player.m_146850_(GameEvent.f_223704_);
        return itemStack;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        if (this.getLeftUsableTimes(stack) == this.getMaxUsableTimes()) {
            player.m_6672_(interactionHand);
            return InteractionResultHolder.m_19090_((Object)stack);
        }
        boolean handled = false;
        BlockHitResult blockHitResult = Canteen.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos blockPos = blockHitResult.m_82425_();
        BlockEntity blockEntity = level.m_7702_(blockPos);
        BlockState blockState = level.m_8055_(blockPos);
        int needed = stack.m_41773_();
        if (level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)) {
            stack.m_41784_().m_128405_("Contain", this.getMaxUsableTimes());
            handled = true;
        } else if (blockEntity != null) {
            LazyOptional capability = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER);
            if (capability.isPresent()) {
                IFluidHandler iFluidHandler = (IFluidHandler)capability.orElse(null);
                int totalAmount = 0;
                int purity = 0;
                for (int i = 0; i < iFluidHandler.getTanks() && iFluidHandler.getFluidInTank(i).getFluid() == Fluids.f_76193_; ++i) {
                    totalAmount += iFluidHandler.getFluidInTank(i).getAmount();
                    if (!ThirstCanteen.thirstLoaded) continue;
                    purity = WaterPurity.getPurity((FluidStack)iFluidHandler.getFluidInTank(i));
                }
                int actual = Math.min(needed, totalAmount /= 250);
                if (actual <= 0) {
                    return InteractionResultHolder.m_19098_((Object)stack);
                }
                iFluidHandler.drain(actual * 250, IFluidHandler.FluidAction.EXECUTE);
                stack.m_41784_().m_128405_("Contain", Math.min(this.getMaxUsableTimes(), needed + actual));
                if (ThirstCanteen.thirstLoaded) {
                    WaterPurity.addPurity((ItemStack)stack, (int)Math.min(Math.max(this.getDefaultPurity(), purity), WaterPurity.getPurity((ItemStack)stack)));
                }
                level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        } else if (blockState.m_60734_() instanceof LayeredCauldronBlock) {
            int waterLevel = (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_);
            int actual = Math.min(needed, waterLevel);
            if (actual <= 0) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (waterLevel - actual > 0) {
                blockState.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(waterLevel - actual));
            } else {
                blockState = Blocks.f_50256_.m_49966_();
            }
            level.m_46597_(blockPos, blockState);
            stack.m_41784_().m_128405_("Contain", Math.min(this.getMaxUsableTimes(), needed + waterLevel));
            handled = true;
        } else {
            player.m_6672_(interactionHand);
        }
        if (handled) {
            if (ThirstCanteen.thirstLoaded) {
                WaterPurity.addPurity((ItemStack)stack, (int)Math.min(Math.max(this.getDefaultPurity(), WaterPurity.getBlockPurity((Level)level, (BlockPos)blockPos)), WaterPurity.getPurity((ItemStack)stack)));
            }
            level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
        return InteractionResultHolder.m_19090_((Object)player.m_21120_(interactionHand));
    }
}

