/*
 * Decompiled with CFR 0.152.
 */
package vip.fubuki.thirstcanteen.common.item;

import dev.ghen.thirst.content.purity.WaterPurity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.NotNull;
import vip.fubuki.thirstcanteen.ThirstCanteen;
import vip.fubuki.thirstcanteen.common.item.Canteen;

public class EmptyCanteen
extends Item {
    Supplier<ItemStack> container;

    public EmptyCanteen(Item.Properties properties, Supplier<ItemStack> container) {
        super(properties.m_41487_(1));
        this.container = container;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand interactionHand) {
        ItemStack result = this.container.get().m_41777_();
        ItemStack stack = player.m_21120_(interactionHand);
        BlockHitResult blockHitResult = EmptyCanteen.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        BlockPos blockPos = blockHitResult.m_82425_();
        BlockEntity blockEntity = level.m_7702_(blockPos);
        BlockState blockState = level.m_8055_(blockPos);
        int needed = ((Canteen)result.m_41720_()).getMaxUsableTimes();
        int defaultPurity = ((Canteen)result.m_41720_()).getDefaultPurity();
        boolean handled = false;
        if (level.m_6425_(blockPos).m_205070_(FluidTags.f_13131_)) {
            result.m_41784_().m_128405_("Contain", needed);
            handled = true;
        } else if (blockEntity != null) {
            LazyOptional capability = blockEntity.getCapability(ForgeCapabilities.FLUID_HANDLER);
            if (capability.isPresent()) {
                IFluidHandler iFluidHandler = (IFluidHandler)capability.orElse(null);
                int totalAmount = 0;
                int purity = 0;
                for (int i = 0; i < iFluidHandler.getTanks() && iFluidHandler.getFluidInTank(i).getFluid() == Fluids.f_76193_; ++i) {
                    totalAmount += iFluidHandler.getFluidInTank(i).getAmount();
                    if (!ThirstCanteen.thirstLoaded) continue;
                    purity = WaterPurity.getPurity((FluidStack)iFluidHandler.getFluidInTank(i));
                }
                int actual = Math.min(needed, totalAmount /= 250);
                if (actual <= 0) {
                    return InteractionResultHolder.m_19090_((Object)stack);
                }
                iFluidHandler.drain(actual * 250, IFluidHandler.FluidAction.EXECUTE);
                result.m_41784_().m_128405_("Contain", Math.min(needed, actual));
                stack.m_41774_(1);
                if (ThirstCanteen.thirstLoaded) {
                    WaterPurity.addPurity((ItemStack)result, (int)Math.max(defaultPurity, purity));
                }
                player.m_150109_().m_36054_(result);
                level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        } else if (blockState.m_60734_() instanceof LayeredCauldronBlock) {
            int waterLevel = (Integer)blockState.m_61143_((Property)LayeredCauldronBlock.f_153514_);
            int actual = Math.min(needed, waterLevel);
            if (actual <= 0) {
                return InteractionResultHolder.m_19098_((Object)stack);
            }
            if (waterLevel - actual > 0) {
                blockState.m_61124_((Property)LayeredCauldronBlock.f_153514_, (Comparable)Integer.valueOf(waterLevel - actual));
            } else {
                blockState = Blocks.f_50256_.m_49966_();
            }
            level.m_46597_(blockPos, blockState);
            result.m_41784_().m_128405_("Contain", Math.min(needed, actual));
            handled = true;
        }
        if (handled) {
            stack.m_41774_(1);
            if (ThirstCanteen.thirstLoaded) {
                WaterPurity.addPurity((ItemStack)result, (int)Math.max(defaultPurity, WaterPurity.getBlockPurity((Level)level, (BlockPos)blockPos)));
            }
            player.m_21008_(interactionHand, result);
            level.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11770_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            return InteractionResultHolder.m_19090_((Object)result);
        }
        return InteractionResultHolder.m_19098_((Object)stack);
    }
}

