/*
 * Decompiled with CFR 0.152.
 */
package dev.dokko.autoconfig.api;

import dev.dokko.autoconfig.AutoConfigAPI;
import dev.dokko.autoconfig.api.config.Config;
import dev.dokko.autoconfig.api.config.ConfigSupplier;
import dev.dokko.autoconfig.api.config.serialize.ConfigSerializer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;

public class AutoConfig {
    private static final Map<Class<? extends Config>, ConfigSupplier<? extends Config>> registeredConfigurations = new HashMap<Class<? extends Config>, ConfigSupplier<? extends Config>>();

    public static <T extends Config> void register(Class<T> configClass) {
        try {
            Config config = (Config)configClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ConfigSupplier<Config> supplier = new ConfigSupplier<Config>(config);
            try {
                configClass.getMethod("init", ConfigSupplier.class).invoke((Object)config, supplier);
                registeredConfigurations.put(configClass, supplier);
            }
            catch (Exception e) {
                AutoConfigAPI.LOGGER.error("Error! Cannot instantiate {} because it does not have the method init(ConfigSupplier)", (Object)configClass.getName());
            }
        }
        catch (Exception e) {
            AutoConfigAPI.LOGGER.error("Error! Cannot instantiate {} because a public empty constructor does not exist", (Object)configClass.getName());
        }
    }

    public static <T extends Config> ConfigSupplier<T> getSupplier(Class<T> configClass) {
        if (!registeredConfigurations.containsKey(configClass)) {
            throw new RuntimeException(configClass.getName() + " not registered");
        }
        return registeredConfigurations.get(configClass);
    }

    public static <T extends Config> T getConfig(Class<T> configClass) {
        if (!registeredConfigurations.containsKey(configClass)) {
            throw new RuntimeException(configClass.getName() + " not registered");
        }
        return (T)registeredConfigurations.get(configClass).getConfig();
    }

    public static <T extends Config> void tryLoad(Class<T> configClass) {
        if (!registeredConfigurations.containsKey(configClass)) {
            throw new RuntimeException(configClass.getName() + " not registered");
        }
        try {
            T config = AutoConfig.getConfig(configClass);
            ConfigSerializer serializer = config.getSerializer().getDeclaredConstructor(Config.class).newInstance(config);
            serializer.deserialize(serializer.getContents());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Config> void saveConfig(Class<T> configClass) {
        if (!registeredConfigurations.containsKey(configClass)) {
            throw new RuntimeException(configClass.getName() + " not registered");
        }
        try {
            T config = AutoConfig.getConfig(configClass);
            ConfigSerializer serializer = config.getSerializer().getDeclaredConstructor(Config.class).newInstance(config);
            String serialized = serializer.serialize();
            Files.writeString(serializer.getFile(), (CharSequence)serialized, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

